/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class AtomicArray
implements AtomicSequence {
    private static List<AtomicValue> a = Collections.emptyList();
    public static AtomicArray EMPTY_ATOMIC_ARRAY = new AtomicArray(a);
    private List<AtomicValue> b;

    public AtomicArray(List<AtomicValue> list) {
        this.b = list;
    }

    public AtomicArray(SequenceIterator<? extends AtomicValue> sequenceIterator) {
        ArrayList<AtomicValue> arrayList = new ArrayList<AtomicValue>(10);
        sequenceIterator.forEachOrFail(arrayList::add);
        this.b = arrayList;
    }

    @Override
    public AtomicValue head() {
        if (this.b.isEmpty()) {
            return null;
        }
        return this.b.get(0);
    }

    @Override
    public AtomicIterator iterate() {
        return new ListIterator.Atomic(this.b);
    }

    @Override
    public AtomicValue itemAt(int n2) {
        if (n2 >= 0 && n2 < this.b.size()) {
            return this.b.get(n2);
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.b.size();
    }

    public AtomicArray subsequence(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 + n3 > this.b.size()) {
            n3 = this.b.size() - n2;
        }
        int n4 = n2;
        return new AtomicArray(this.b.subList(n4, n4 + n3));
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        return this.getStringValueCS();
    }

    @Override
    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        boolean bl2 = true;
        for (AtomicValue atomicValue : this.b) {
            if (!bl2) {
                fastStringBuffer.append(' ');
            } else {
                bl2 = false;
            }
            fastStringBuffer.append(atomicValue.getStringValueCS());
        }
        return fastStringBuffer.condense();
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public Comparable getSchemaComparable() {
        if (this.b.size() == 1) {
            return this.b.get(0).getSchemaComparable();
        }
        return new a(this, 0);
    }

    @Override
    public GroundedValue<AtomicValue> reduce() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return EmptySequence.getInstance();
        }
        if (n2 == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return this.b.iterator();
    }

    private class a
    implements Comparable<a> {
        private /* synthetic */ AtomicArray a;

        private a(AtomicArray atomicArray) {
            this.a = atomicArray;
        }

        private int a(a object) {
            AtomicValue atomicValue;
            int n2;
            Object object2 = this;
            AtomicIterator atomicIterator = ((a)object2).a.iterate();
            object2 = object;
            object = ((a)object2).a.iterate();
            do {
                object2 = (AtomicValue)atomicIterator.next();
                atomicValue = (AtomicValue)object.next();
                if (object2 == null && atomicValue == null) {
                    return 0;
                }
                if (object2 == null) {
                    return -1;
                }
                if (atomicValue != null) continue;
                return 1;
            } while ((n2 = ((AtomicValue)object2).getSchemaComparable().compareTo(atomicValue.getSchemaComparable())) == 0);
            return n2;
        }

        public boolean equals(Object object) {
            return a.class.isAssignableFrom(object.getClass()) && this.a((a)object) == 0;
        }

        public int hashCode() {
            try {
                int n2 = 107189858;
                Object object = this;
                object = ((a)object).a.iterate();
                while (true) {
                    Object t2;
                    if ((t2 = object.next()) == null) {
                        return n2;
                    }
                    if (!(t2 instanceof AtomicValue)) continue;
                    n2 ^= ((AtomicValue)t2).getSchemaComparable().hashCode();
                }
            }
            catch (XPathException xPathException) {
                return 0;
            }
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }

        /* synthetic */ a(AtomicArray atomicArray, byte by) {
            this(atomicArray);
        }
    }
}

