/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.KeyManager;

public final class DocumentPool {
    private Map<DocumentURI, TreeInfo> a = new HashMap<DocumentURI, TreeInfo>(10);
    private Set<DocumentURI> b = new HashSet<DocumentURI>(10);

    public final synchronized void add(TreeInfo treeInfo, String string) {
        if (string != null) {
            this.a.put(new DocumentURI(string), treeInfo);
        }
    }

    public final synchronized void add(TreeInfo treeInfo, DocumentURI documentURI) {
        if (documentURI != null) {
            this.a.put(documentURI, treeInfo);
        }
    }

    public final synchronized TreeInfo find(String string) {
        return this.a.get(new DocumentURI(string));
    }

    public final synchronized TreeInfo find(DocumentURI documentURI) {
        return this.a.get(documentURI);
    }

    public final synchronized String getDocumentURI(NodeInfo nodeInfo) {
        for (DocumentURI documentURI : this.a.keySet()) {
            TreeInfo treeInfo = this.find(documentURI);
            if (treeInfo == null || !treeInfo.getRootNode().equals(nodeInfo)) continue;
            return documentURI.toString();
        }
        return null;
    }

    public final synchronized boolean contains(TreeInfo treeInfo) {
        return this.a.values().contains(treeInfo);
    }

    public final synchronized TreeInfo discard(TreeInfo treeInfo) {
        for (Map.Entry<DocumentURI, TreeInfo> entry : this.a.entrySet()) {
            DocumentURI documentURI = entry.getKey();
            TreeInfo object = entry.getValue();
            if (!object.equals(treeInfo)) continue;
            this.a.remove(documentURI);
            return treeInfo;
        }
        return treeInfo;
    }

    public final void discardIndexes(KeyManager keyManager) {
        for (TreeInfo treeInfo : this.a.values()) {
            keyManager.clearDocumentIndexes(treeInfo);
        }
    }

    public final void markUnavailable(DocumentURI documentURI) {
        this.b.add(documentURI);
    }

    public final boolean isMarkedUnavailable(DocumentURI documentURI) {
        return this.b.contains(documentURI);
    }
}

