/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.File;
import java.io.IOException;

public class DocumentURI {
    public static final boolean CASE_BLIND_FILES = new File("a").equals(new File("A"));
    private String a;
    private String b;

    public DocumentURI(String string) {
        if (string == null) {
            throw new NullPointerException("uri");
        }
        this.a = string;
        this.b = DocumentURI.normalizeURI(string);
    }

    public String toString() {
        return this.a;
    }

    public boolean equals(Object object) {
        return object instanceof DocumentURI && this.b.equals(((DocumentURI)object).b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public static String normalizeURI(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("FILE:")) {
            string = "file:" + string.substring(5);
        }
        if (string.startsWith("file:")) {
            if (string.startsWith("file:///")) {
                string = "file:/" + string.substring(8);
            }
            if (string.startsWith("file:/")) {
                try {
                    String string2 = new File(string.substring(5)).getCanonicalPath();
                    string = "file:" + string2;
                }
                catch (IOException iOException) {}
            }
            if (CASE_BLIND_FILES) {
                string = string.toLowerCase();
            }
        }
        return string;
    }
}

