/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;

public class FingerprintedQName
implements NodeName {
    private StructuredQName a;
    private int b = -1;

    public FingerprintedQName(String string, String string2, String string3) {
        this.a = new StructuredQName(string, string2, string3);
    }

    public FingerprintedQName(String string, String string2, String string3, int n2) {
        this.a = new StructuredQName(string, string2, string3);
        this.b = n2;
    }

    public FingerprintedQName(String string, String string2, String string3, NamePool namePool) {
        this.a = new StructuredQName(string, string2, string3);
        this.b = namePool.allocateFingerprint(string2, string3);
    }

    public FingerprintedQName(StructuredQName structuredQName, int n2) {
        this.a = structuredQName;
        this.b = n2;
    }

    public FingerprintedQName(StructuredQName structuredQName, NamePool namePool) {
        this.a = structuredQName;
        this.b = namePool.allocateFingerprint(structuredQName.getURI(), structuredQName.getLocalPart());
    }

    public static FingerprintedQName fromClarkName(String string) {
        String string2;
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string2 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string = string.substring(n2 + 1);
        } else {
            string2 = "";
        }
        return new FingerprintedQName("", string2, string);
    }

    @Override
    public boolean hasFingerprint() {
        return this.b != -1;
    }

    @Override
    public int getFingerprint() {
        return this.b;
    }

    @Override
    public int obtainFingerprint(NamePool namePool) {
        if (this.b == -1) {
            this.b = namePool.allocateFingerprint(this.getURI(), this.getLocalPart());
        }
        return this.b;
    }

    @Override
    public String getDisplayName() {
        return this.a.getDisplayName();
    }

    @Override
    public String getPrefix() {
        return this.a.getPrefix();
    }

    @Override
    public String getURI() {
        return this.a.getURI();
    }

    @Override
    public String getLocalPart() {
        return this.a.getLocalPart();
    }

    @Override
    public StructuredQName getStructuredQName() {
        return this.a;
    }

    @Override
    public boolean isInSameNamespace(NodeName nodeName) {
        return this.a.isInSameNamespace(nodeName);
    }

    @Override
    public boolean hasURI(String string) {
        return this.a.hasURI(string);
    }

    @Override
    public NamespaceBinding getNamespaceBinding() {
        return this.a.getNamespaceBinding();
    }

    @Override
    public int identityHashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof NodeName) {
            if (this.b != -1 && ((NodeName)object).hasFingerprint()) {
                return this.getFingerprint() == ((NodeName)object).getFingerprint();
            }
            return this.getLocalPart().equals(((NodeName)object).getLocalPart()) && this.isInSameNamespace((NodeName)object);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public boolean isIdentical(IdentityComparable identityComparable) {
        return identityComparable instanceof NodeName && this.equals(identityComparable) && this.getPrefix().equals(((NodeName)identityComparable).getPrefix());
    }

    public String toString() {
        return this.a.getDisplayName();
    }
}

