/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.IgnorableWhitespaceStripper;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class IgnorableSpaceStrippingRule
implements SpaceStrippingRule {
    private static final IgnorableSpaceStrippingRule a = new IgnorableSpaceStrippingRule();

    public static IgnorableSpaceStrippingRule getInstance() {
        return a;
    }

    @Override
    public int isSpacePreserving(NodeName nodeName, SchemaType schemaType) {
        if (schemaType != Untyped.getInstance() && schemaType.isComplexType() && !((ComplexType)schemaType).isSimpleContent() && !((ComplexType)schemaType).isMixedContent()) {
            return 2;
        }
        return 1;
    }

    @Override
    public ProxyReceiver makeStripper(Receiver receiver) {
        return new IgnorableWhitespaceStripper(receiver);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("strip.ignorable");
        expressionPresenter.endElement();
    }
}

