/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Iterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.value.EmptySequence;

public interface Item<T extends Item<?>>
extends GroundedValue<T> {
    public Genre getGenre();

    @Override
    default public T head() {
        return (T)this;
    }

    @Override
    public String getStringValue();

    @Override
    public CharSequence getStringValueCS();

    public AtomicSequence atomize();

    @Override
    default public String toShortString() {
        return this.toString();
    }

    @Override
    default public Iterator<T> iterator() {
        return new MonoIterator<T>(this.head());
    }

    @Override
    default public T itemAt(int n2) {
        if (n2 == 0) {
            return this.head();
        }
        return null;
    }

    @Override
    default public GroundedValue<T> subsequence(int n2, int n3) {
        if (n2 <= 0 && n2 + n3 > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    @Override
    default public int getLength() {
        return 1;
    }

    @Override
    default public UnfailingIterator<T> iterate() {
        return SingletonIterator.makeIterator(this.head());
    }

    @Override
    default public GroundedValue<T> reduce() {
        return this;
    }

    public static <T extends Item<?>> GroundedValue<T> toGroundedValue(Item<T> item) {
        return item.reduce();
    }

    default public boolean isStreamed() {
        return false;
    }
}

