/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.QNameException;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public abstract class NameChecker {
    public static boolean isQName(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return NameChecker.isValidNCName(string);
        }
        return n2 != 0 && n2 != string.length() - 1 && NameChecker.isValidNCName(string.substring(0, n2)) && NameChecker.isValidNCName(string.substring(n2 + 1));
    }

    public static String getPrefix(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static String[] getQNameParts(CharSequence charSequence) {
        String[] stringArray = new String[2];
        int n2 = -1;
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (charSequence.charAt(i2) != ':') continue;
            n2 = i2;
            break;
        }
        if (n2 < 0) {
            stringArray[0] = "";
            stringArray[1] = charSequence.toString();
            if (!NameChecker.isValidNCName(stringArray[1])) {
                throw new QNameException("Invalid QName " + Err.wrap(charSequence));
            }
        } else {
            if (n2 == 0) {
                throw new QNameException("QName cannot start with colon: " + Err.wrap(charSequence));
            }
            if (n2 == n3 - 1) {
                throw new QNameException("QName cannot end with colon: " + Err.wrap(charSequence));
            }
            stringArray[0] = charSequence.subSequence(0, n2).toString();
            stringArray[1] = charSequence.subSequence(n2 + 1, n3).toString();
            if (!NameChecker.isValidNCName(stringArray[1])) {
                if (!NameChecker.isValidNCName(stringArray[0])) {
                    throw new QNameException("Both the prefix " + Err.wrap(stringArray[0]) + " and the local part " + Err.wrap(stringArray[1]) + " are invalid");
                }
                throw new QNameException("Invalid QName local part " + Err.wrap(stringArray[1]));
            }
        }
        return stringArray;
    }

    public static String[] checkQNameParts(CharSequence stringArray) {
        try {
            stringArray = NameChecker.getQNameParts((CharSequence)stringArray);
            if (stringArray[0].length() > 0 && !NameChecker.isValidNCName(stringArray[0])) {
                throw new XPathException("Invalid QName prefix " + Err.wrap(stringArray[0]));
            }
            return stringArray;
        }
        catch (QNameException qNameException) {
            XPathException xPathException = new XPathException(qNameException.getMessage());
            xPathException.setErrorCode("FORG0001");
            throw xPathException;
        }
    }

    public static boolean isValidNCName(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return false;
        }
        int n2 = 1;
        char c2 = charSequence.charAt(0);
        if (UTF16CharacterSet.isHighSurrogate(c2)) {
            if (!NameChecker.isNCNameStartChar(UTF16CharacterSet.combinePair(c2, charSequence.charAt(1)))) {
                return false;
            }
            n2 = 2;
        } else if (!NameChecker.isNCNameStartChar(c2)) {
            return false;
        }
        while (n2 < charSequence.length()) {
            c2 = charSequence.charAt(n2);
            if (UTF16CharacterSet.isHighSurrogate(c2) ? !NameChecker.isNCNameChar(UTF16CharacterSet.combinePair(c2, charSequence.charAt(++n2))) : !NameChecker.isNCNameChar(c2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValidNmtoken(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (!(UTF16CharacterSet.isHighSurrogate(c2) ? !NameChecker.isNCNameChar(UTF16CharacterSet.combinePair(c2, charSequence.charAt(++i2))) : c2 != ':' && !NameChecker.isNCNameChar(c2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNameChar(int n2) {
        return XMLCharacterData.isNCName11(n2);
    }

    public static boolean isNCNameStartChar(int n2) {
        return XMLCharacterData.isNCNameStart11(n2);
    }
}

