/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;

public class NameOfNode
implements NodeName {
    private NodeInfo a;

    private NameOfNode(NodeInfo nodeInfo) {
        this.a = nodeInfo;
    }

    public static NodeName makeName(NodeInfo nodeInfo) {
        if (nodeInfo instanceof MutableNodeInfo) {
            return new FingerprintedQName(nodeInfo.getPrefix(), nodeInfo.getURI(), nodeInfo.getLocalPart());
        }
        if (nodeInfo instanceof AbstractVirtualNode) {
            return new NameOfNode(((AbstractVirtualNode)nodeInfo).getUnderlyingNode());
        }
        return new NameOfNode(nodeInfo);
    }

    @Override
    public String getPrefix() {
        return this.a.getPrefix();
    }

    @Override
    public String getURI() {
        return this.a.getURI();
    }

    @Override
    public String getLocalPart() {
        return this.a.getLocalPart();
    }

    @Override
    public String getDisplayName() {
        return this.a.getDisplayName();
    }

    @Override
    public StructuredQName getStructuredQName() {
        return new StructuredQName(this.getPrefix(), this.getURI(), this.getLocalPart());
    }

    @Override
    public boolean isInSameNamespace(NodeName nodeName) {
        return this.a.getURI().equals(nodeName.getURI());
    }

    @Override
    public boolean hasURI(String string) {
        return this.a.getURI().equals(string);
    }

    @Override
    public NamespaceBinding getNamespaceBinding() {
        return NamespaceBinding.makeNamespaceBinding(this.getPrefix(), this.getURI());
    }

    @Override
    public boolean hasFingerprint() {
        return this.a.hasFingerprint();
    }

    @Override
    public int getFingerprint() {
        if (this.hasFingerprint()) {
            return this.a.getFingerprint();
        }
        return -1;
    }

    @Override
    public int obtainFingerprint(NamePool namePool) {
        if (this.a.hasFingerprint()) {
            return this.a.getFingerprint();
        }
        return namePool.allocateFingerprint(this.a.getURI(), this.a.getLocalPart());
    }

    public int hashCode() {
        return StructuredQName.computeHashCode(this.getURI(), this.getLocalPart());
    }

    public boolean equals(Object object) {
        if (object instanceof NodeName) {
            object = (NodeName)object;
            if (this.a.hasFingerprint() && object.hasFingerprint()) {
                return this.a.getFingerprint() == object.getFingerprint();
            }
            return object.getLocalPart().equals(this.a.getLocalPart()) && object.hasURI(this.a.getURI());
        }
        return false;
    }

    @Override
    public boolean isIdentical(IdentityComparable identityComparable) {
        return identityComparable instanceof NodeName && this.equals(identityComparable) && this.getPrefix().equals(((NodeName)identityComparable).getPrefix());
    }

    @Override
    public int identityHashCode() {
        return this.hashCode() ^ this.getPrefix().hashCode();
    }
}

