/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;

public final class NamePool {
    public static final int FP_MASK = 1048575;
    public static final int USER_DEFINED_MASK = 1047552;
    private final ConcurrentHashMap<StructuredQName, Integer> a = new ConcurrentHashMap(1000);
    private final ConcurrentHashMap<Integer, StructuredQName> b = new ConcurrentHashMap(1000);
    private AtomicInteger c = new AtomicInteger(1024);
    private ConcurrentHashMap<String, String> d = new ConcurrentHashMap();

    public final void suggestPrefix(String string, String string2) {
        this.d.put(string2, string);
    }

    public final StructuredQName getUnprefixedQName(int n2) {
        if (((n2 &= 0xFFFFF) & 0xFFC00) == 0) {
            return StandardNames.getUnprefixedQName(n2);
        }
        return this.b.get(n2);
    }

    public final StructuredQName getStructuredQName(int n2) {
        return this.getUnprefixedQName(n2);
    }

    public static boolean isPrefixed(int n2) {
        return (n2 & 0x3FF00000) != 0;
    }

    public final String suggestPrefixForURI(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.d.get(string);
    }

    public final synchronized int allocateFingerprint(String object, String object2) {
        int n2;
        if ((NamespaceConstant.isReserved((String)object) || "http://saxon.sf.net/".equals(object)) && (n2 = StandardNames.getFingerprint((String)object, (String)object2)) != -1) {
            return n2;
        }
        StructuredQName structuredQName = new StructuredQName("", (String)object, (String)object2);
        if ((object = this.a.get(structuredQName)) != null) {
            return (Integer)object;
        }
        object2 = this.c.getAndIncrement();
        if ((Integer)object2 > 1048575) {
            throw new NamePoolLimitException("Too many distinct names in NamePool");
        }
        object = this.a.putIfAbsent(structuredQName, (Integer)object2);
        if (object == null) {
            this.b.put((Integer)object2, structuredQName);
            return (Integer)object2;
        }
        return (Integer)object;
    }

    public final String getURI(int n2) {
        if (((n2 &= 0xFFFFF) & 0xFFC00) == 0) {
            return StandardNames.getURI(n2);
        }
        return this.getUnprefixedQName(n2).getURI();
    }

    public final String getLocalName(int n2) {
        return this.getUnprefixedQName(n2).getLocalPart();
    }

    public final String getDisplayName(int n2) {
        return this.getStructuredQName(n2).getDisplayName();
    }

    public final String getClarkName(int n2) {
        return this.getUnprefixedQName(n2).getClarkName();
    }

    public final String getEQName(int n2) {
        return this.getUnprefixedQName(n2).getEQName();
    }

    public final int allocateClarkName(String string) {
        String string2;
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string2 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string = string.substring(n2 + 1);
        } else {
            string2 = "";
        }
        return this.allocateFingerprint(string2, string);
    }

    public final int getFingerprint(String string, String string2) {
        int n2;
        if ((NamespaceConstant.isReserved(string) || string.equals("http://saxon.sf.net/")) && (n2 = StandardNames.getFingerprint(string, string2)) != -1) {
            return n2;
        }
        Integer n3 = this.a.get(new StructuredQName("", string, string2));
        if (n3 == null) {
            return -1;
        }
        return n3;
    }

    public static class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String string) {
            super(string);
        }
    }
}

