/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Closeable;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ItemConsumer;
import net.sf.saxon.value.SequenceExtent;

public interface SequenceIterator<T extends Item<?>>
extends Closeable {
    public static final int GROUNDED = 1;
    public static final int LAST_POSITION_FINDER = 2;
    public static final int LOOKAHEAD = 4;
    public static final int ATOMIZING = 8;

    public T next();

    @Override
    default public void close() {
    }

    default public int getProperties() {
        return 0;
    }

    default public void forEachOrFail(ItemConsumer<T> itemConsumer) {
        T t2;
        while ((t2 = this.next()) != null) {
            itemConsumer.accept(t2);
        }
    }

    default public GroundedValue<T> materialize() {
        return SequenceExtent.fromIterator(this);
    }
}

