/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.ReverseRangeIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;

public class SequenceTool {
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;

    public static <T extends Item<?>> GroundedValue<T> toGroundedValue(SequenceIterator<T> sequenceIterator) {
        return sequenceIterator.materialize();
    }

    public static <T extends Item<?>> Sequence<T> toMemoSequence(SequenceIterator<T> sequenceIterator) {
        if (sequenceIterator instanceof EmptyIterator) {
            return EmptySequence.getInstance();
        }
        if ((sequenceIterator.getProperties() & 1) != 0) {
            return sequenceIterator.materialize();
        }
        return new MemoSequence<T>(sequenceIterator);
    }

    public static <T extends Item<?>> Sequence<T> toLazySequence(SequenceIterator<T> sequenceIterator) {
        if ((sequenceIterator.getProperties() & 1) != 0 && !(sequenceIterator instanceof RangeIterator) && !(sequenceIterator instanceof ReverseRangeIterator)) {
            return sequenceIterator.materialize();
        }
        return new LazySequence<T>(sequenceIterator);
    }

    public static Sequence<?> toLazySequence2(SequenceIterator<?> sequenceIterator) {
        if ((sequenceIterator.getProperties() & 1) != 0 && !(sequenceIterator instanceof RangeIterator) && !(sequenceIterator instanceof ReverseRangeIterator)) {
            return sequenceIterator.materialize();
        }
        return new LazySequence(sequenceIterator);
    }

    public static boolean isUnrepeatable(Sequence<?> sequence) {
        return sequence instanceof LazySequence || sequence instanceof Closure && !(sequence instanceof MemoClosure) && !(sequence instanceof SingletonClosure);
    }

    public static int getLength(Sequence<?> sequence) {
        if (sequence instanceof GroundedValue) {
            return ((GroundedValue)sequence).getLength();
        }
        return Count.count(sequence.iterate());
    }

    public static boolean hasLength(SequenceIterator sequenceIterator, int n2) {
        if ((sequenceIterator.getProperties() & 2) != 0) {
            return ((LastPositionFinder)((Object)sequenceIterator)).getLength() == n2;
        }
        int n3 = 0;
        while (sequenceIterator.next() != null) {
            if (n3++ != n2) continue;
            sequenceIterator.close();
            return false;
        }
        return n2 == 0;
    }

    public static boolean sameLength(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) {
        Object t2;
        Object t3;
        if ((sequenceIterator.getProperties() & 2) != 0) {
            return SequenceTool.hasLength(sequenceIterator2, ((LastPositionFinder)((Object)sequenceIterator)).getLength());
        }
        if ((sequenceIterator2.getProperties() & 2) != 0) {
            return SequenceTool.hasLength(sequenceIterator, ((LastPositionFinder)((Object)sequenceIterator2)).getLength());
        }
        do {
            t3 = sequenceIterator.next();
            t2 = sequenceIterator2.next();
        } while (t3 != null && t2 != null);
        if (t3 != null) {
            sequenceIterator.close();
        }
        if (t2 != null) {
            sequenceIterator2.close();
        }
        return t3 == null && t2 == null;
    }

    public static <T extends Item<?>> T itemAt(Sequence<T> sequence, int n2) {
        if (sequence instanceof Item && n2 == 0) {
            return (T)((Item)sequence);
        }
        return sequence.materialize().itemAt(n2);
    }

    public static <T extends Item<?>> T asItem(Sequence<T> object) {
        if (object instanceof Item) {
            return (T)((Item)object);
        }
        T t2 = (object = object.iterate()).next();
        if (t2 == null) {
            return null;
        }
        if (object.next() != null) {
            throw new XPathException("Sequence contains more than one item");
        }
        return t2;
    }

    public static Object convertToJava(Item item) {
        if (item instanceof NodeInfo) {
            Object object = item;
            while (object instanceof VirtualNode) {
                object = ((VirtualNode)object).getRealNode();
            }
            return object;
        }
        if (item instanceof Function) {
            return item;
        }
        if (item instanceof ExternalObject) {
            return ((ExternalObject)item).getObject();
        }
        AtomicValue atomicValue = (AtomicValue)item;
        switch (atomicValue.getItemType().getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return atomicValue.getStringValue();
            }
            case 514: {
                if (((BooleanValue)atomicValue).getBooleanValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 515: {
                return ((NumericValue)((BigDecimalValue)atomicValue)).getDecimalValue();
            }
            case 533: {
                return ((NumericValue)atomicValue).longValue();
            }
            case 517: {
                return ((NumericValue)((DoubleValue)atomicValue)).getDoubleValue();
            }
            case 516: {
                return Float.valueOf(((NumericValue)((FloatValue)atomicValue)).getFloatValue());
            }
            case 519: {
                return ((CalendarValue)((DateTimeValue)atomicValue)).getCalendar().getTime();
            }
            case 521: {
                return ((CalendarValue)((DateValue)atomicValue)).getCalendar().getTime();
            }
            case 520: {
                return atomicValue.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)atomicValue).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)atomicValue).getBinaryValue();
            }
        }
        return item;
    }

    public static <T extends Item<?>> String getStringValue(Sequence<T> sequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        sequence.iterate().forEachOrFail(item -> {
            if (!fastStringBuffer.isEmpty()) {
                fastStringBuffer.append(' ');
            }
            fastStringBuffer.append(item.getStringValueCS());
        });
        return fastStringBuffer.toString();
    }

    public static ItemType getItemType(Sequence<?> object, TypeHierarchy typeHierarchy) {
        if (object instanceof Item) {
            return Type.getItemType((Item)object, typeHierarchy);
        }
        if (object instanceof GroundedValue) {
            try {
                Object t2;
                ItemType itemType = null;
                object = object.iterate();
                while ((t2 = object.next()) != null && (itemType = itemType == null ? Type.getItemType(t2, typeHierarchy) : Type.getCommonSuperType(itemType, Type.getItemType(t2, typeHierarchy), typeHierarchy)) != AnyItemType.getInstance()) {
                }
                if (itemType == null) {
                    return ErrorType.getInstance();
                }
                return itemType;
            }
            catch (XPathException xPathException) {
                return AnyItemType.getInstance();
            }
        }
        return AnyItemType.getInstance();
    }

    public static UType getUType(Sequence<?> object) {
        if (object instanceof Item) {
            return UType.getUType((Item)object);
        }
        if (object instanceof GroundedValue) {
            Object t2;
            UType uType = UType.VOID;
            object = ((GroundedValue)object).iterate();
            while ((t2 = object.next()) != null && (uType = uType.union(UType.getUType(t2))) != UType.ANY) {
            }
            return uType;
        }
        return UType.ANY;
    }

    public static int getCardinality(Sequence<?> object) {
        if (object instanceof Item) {
            return 16384;
        }
        if (object instanceof GroundedValue) {
            int n2 = ((GroundedValue)object).getLength();
            switch (n2) {
                case 0: {
                    return 8192;
                }
                case 1: {
                    return 16384;
                }
            }
            return 49152;
        }
        try {
            object = object.iterate();
            Object object2 = object.next();
            if (object2 == null) {
                return 8192;
            }
            object2 = object.next();
            if (object2 == null) {
                return 16384;
            }
            return 49152;
        }
        catch (XPathException xPathException) {
            return 49152;
        }
    }

    public static SequenceType getSequenceType(Sequence<?> sequence, TypeHierarchy typeHierarchy) {
        return SequenceType.makeSequenceType(SequenceTool.getItemType(sequence, typeHierarchy), SequenceTool.getCardinality(sequence));
    }

    public static void process(Sequence<?> sequence, XPathContext object, Location location) {
        object = object.getReceiver();
        sequence.iterate().forEachOrFail(arg_0 -> SequenceTool.a((Receiver)object, location, arg_0));
    }

    public static Sequence<?>[] makeSequenceArray(int n2) {
        return new Sequence[n2];
    }

    public static Sequence<?>[] fromItems(Item<?> ... itemArray) {
        Sequence[] sequenceArray = new Sequence[itemArray.length];
        System.arraycopy(itemArray, 0, sequenceArray, 0, itemArray.length);
        return sequenceArray;
    }

    private static /* synthetic */ void a(Receiver receiver, Location location, Item item) {
        receiver.append(item, location, 524288);
    }
}

