/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Arrays;
import javax.xml.namespace.QName;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class StructuredQName
implements IdentityComparable {
    private char[] a;
    private int b;
    private int c;
    private int d = -1;

    private StructuredQName(char[] cArray, int n2, int n3) {
        this.a = cArray;
        this.b = n2;
        this.c = n3;
    }

    public StructuredQName(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = string3.length();
        this.b = n3;
        this.c = n3 + n4;
        this.a = new char[n3 + n4 + n2];
        string2.getChars(0, n3, this.a, 0);
        string3.getChars(0, n4, this.a, n3);
        string.getChars(0, n2, this.a, n3 + n4);
    }

    public StructuredQName addPrefix(String string) {
        char[] cArray = Arrays.copyOf(this.a, this.a.length + string.length());
        string.getChars(0, string.length(), cArray, this.a.length);
        return new StructuredQName(cArray, this.b, this.a.length);
    }

    public static StructuredQName fromClarkName(String string) {
        String string2;
        if (string.startsWith("Q{")) {
            string = string.substring(1);
        }
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string2 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string = string.substring(n2 + 1);
        } else {
            string2 = "";
        }
        return new StructuredQName("", string2, string);
    }

    public static StructuredQName fromLexicalQName(CharSequence object, boolean n2, boolean bl2, NamespaceResolver namespaceResolver) {
        object = Whitespace.trimWhitespace((CharSequence)object);
        if (bl2 && object.length() >= 4 && object.charAt(0) == 'Q' && object.charAt(1) == '{') {
            n2 = ((String)(object = object.toString())).indexOf(125);
            if (n2 < 0) {
                throw new XPathException("Invalid EQName: closing brace not found");
            }
            if (n2 == ((String)object).length() - 1) {
                throw new XPathException("Invalid EQName: local part is missing");
            }
            String string = ((String)object).substring(2, n2);
            if (!NameChecker.isValidNCName((CharSequence)(object = ((String)object).substring(n2 + 1)))) {
                throw new XPathException("Invalid EQName: local part is not a valid NCName");
            }
            return new StructuredQName("", string, (String)object);
        }
        try {
            object = NameChecker.getQNameParts((CharSequence)object);
            String string = namespaceResolver.getURIForPrefix(object[0], n2 != 0);
            if (string == null) {
                if (NameChecker.isValidNCName(object[0])) {
                    XPathException xPathException = new XPathException("Namespace prefix '" + (String)object[0] + "' has not been declared");
                    xPathException.setErrorCode("FONS0004");
                    throw xPathException;
                }
                XPathException xPathException = new XPathException("Invalid namespace prefix '" + (String)object[0] + "'");
                xPathException.setErrorCode("FOCA0002");
                throw xPathException;
            }
            return new StructuredQName(object[0], string, object[1]);
        }
        catch (QNameException qNameException) {
            XPathException xPathException = new XPathException(qNameException.getMessage());
            xPathException.setErrorCode("FOCA0002");
            throw xPathException;
        }
    }

    public static StructuredQName fromEQName(CharSequence charSequence) {
        if ((charSequence = Whitespace.trimWhitespace(charSequence)).length() >= 4 && charSequence.charAt(0) == 'Q' && charSequence.charAt(1) == '{') {
            int n2 = ((String)(charSequence = charSequence.toString())).indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid EQName: closing brace not found");
            }
            if (n2 == ((String)charSequence).length() - 1) {
                throw new IllegalArgumentException("Invalid EQName: local part is missing");
            }
            String string = ((String)charSequence).substring(2, n2);
            charSequence = ((String)charSequence).substring(n2 + 1);
            return new StructuredQName("", string, (String)charSequence);
        }
        return new StructuredQName("", "", charSequence.toString());
    }

    public String getPrefix() {
        return new String(this.a, this.c, this.a.length - this.c);
    }

    public String getURI() {
        if (this.b == 0) {
            return "";
        }
        return new String(this.a, 0, this.b);
    }

    public boolean hasURI(String string) {
        if (this.b != string.length()) {
            return false;
        }
        for (int i2 = this.b - 1; i2 >= 0; --i2) {
            if (this.a[i2] == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public String getLocalPart() {
        return new String(this.a, this.b, this.c - this.b);
    }

    public String getDisplayName() {
        if (this.c == this.a.length) {
            return this.getLocalPart();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.a.length - this.b + 1);
        fastStringBuffer.append(this.a, this.c, this.a.length - this.c);
        fastStringBuffer.append(':');
        fastStringBuffer.append(this.a, this.b, this.c - this.b);
        return fastStringBuffer.toString();
    }

    public StructuredQName getStructuredQName() {
        return this;
    }

    public String getClarkName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.a.length - this.c + 2);
        if (this.b > 0) {
            fastStringBuffer.append('{');
            fastStringBuffer.append(this.a, 0, this.b);
            fastStringBuffer.append('}');
        }
        fastStringBuffer.append(this.a, this.b, this.c - this.b);
        return fastStringBuffer.toString();
    }

    public String getEQName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.a.length - this.c + 2);
        fastStringBuffer.append("Q{");
        if (this.b > 0) {
            fastStringBuffer.append(this.a, 0, this.b);
        }
        fastStringBuffer.append('}');
        fastStringBuffer.append(this.a, this.b, this.c - this.b);
        return fastStringBuffer.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StructuredQName) {
            int n2 = ((StructuredQName)object).d;
            if (n2 != -1 && n2 != this.hashCode()) {
                return false;
            }
            object = (StructuredQName)object;
            if (this.b != ((StructuredQName)object).b || this.c != ((StructuredQName)object).c) {
                return false;
            }
            for (n2 = this.c - 1; n2 >= 0; --n2) {
                if (this.a[n2] == ((StructuredQName)object).a[n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.d == -1) {
            int n2 = 0x8004A00B ^ this.c;
            n2 ^= this.b;
            for (int i2 = this.b; i2 < this.c; ++i2) {
                n2 ^= this.a[i2] << (i2 & 0x1F);
            }
            this.d = n2;
            return this.d;
        }
        return this.d;
    }

    public static int computeHashCode(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = charSequence2.length();
        int n3 = charSequence.length();
        int n4 = n2 + n3;
        n4 = 0x8004A00B ^ n4;
        n4 ^= n3;
        int n5 = 0;
        while (n5 < n2) {
            n4 ^= charSequence2.charAt(n5) << (n3 & 0x1F);
            ++n5;
            ++n3;
        }
        return n4;
    }

    public boolean isInSameNamespace(NodeName identityComparable) {
        if (this == identityComparable) {
            return true;
        }
        if (identityComparable instanceof StructuredQName) {
            identityComparable = (StructuredQName)identityComparable;
            if (this.b != ((StructuredQName)identityComparable).b) {
                return false;
            }
            for (int i2 = this.b - 1; i2 >= 0; --i2) {
                if (this.a[i2] == ((StructuredQName)identityComparable).a[i2]) continue;
                return false;
            }
            return true;
        }
        return this.getURI().equals(identityComparable.getURI());
    }

    public QName toJaxpQName() {
        return new QName(this.getURI(), this.getLocalPart(), this.getPrefix());
    }

    public NamespaceBinding getNamespaceBinding() {
        return NamespaceBinding.makeNamespaceBinding(this.getPrefix(), this.getURI());
    }

    @Override
    public boolean isIdentical(IdentityComparable identityComparable) {
        return this.equals(identityComparable) && ((StructuredQName)identityComparable).getPrefix().equals(this.getPrefix());
    }

    @Override
    public int identityHashCode() {
        return this.hashCode() ^ this.getPrefix().hashCode();
    }
}

