/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyBuilderCondensed;

public abstract class TreeModel {
    public static final TreeModel TINY_TREE = new b(0);
    public static final TreeModel TINY_TREE_CONDENSED = new c(0);
    public static final TreeModel LINKED_TREE = new a(0);

    public abstract Builder makeBuilder(PipelineConfiguration var1);

    public int getSymbolicValue() {
        return -1;
    }

    public static TreeModel getTreeModel(int n2) {
        switch (n2) {
            case 1: {
                return TINY_TREE;
            }
            case 2: {
                return TINY_TREE_CONDENSED;
            }
            case 0: {
                return LINKED_TREE;
            }
        }
        throw new IllegalArgumentException("tree model " + n2);
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isSchemaAware() {
        return false;
    }

    public String getName() {
        return this.toString();
    }

    private static final class a
    extends TreeModel {
        private a() {
        }

        @Override
        public final Builder makeBuilder(PipelineConfiguration pipelineConfiguration) {
            return new LinkedTreeBuilder(pipelineConfiguration);
        }

        @Override
        public final int getSymbolicValue() {
            return 0;
        }

        @Override
        public final boolean isMutable() {
            return true;
        }

        @Override
        public final boolean isSchemaAware() {
            return true;
        }

        @Override
        public final String getName() {
            return "LinkedTree";
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    private static final class c
    extends TreeModel {
        private c() {
        }

        @Override
        public final Builder makeBuilder(PipelineConfiguration pipelineConfiguration) {
            TinyBuilderCondensed tinyBuilderCondensed = new TinyBuilderCondensed(pipelineConfiguration);
            tinyBuilderCondensed.setStatistics(pipelineConfiguration.getConfiguration().getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
            return tinyBuilderCondensed;
        }

        @Override
        public final int getSymbolicValue() {
            return 2;
        }

        @Override
        public final boolean isSchemaAware() {
            return true;
        }

        @Override
        public final String getName() {
            return "TinyTreeCondensed";
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private static final class b
    extends TreeModel {
        private b() {
        }

        @Override
        public final Builder makeBuilder(PipelineConfiguration pipelineConfiguration) {
            TinyBuilder tinyBuilder = new TinyBuilder(pipelineConfiguration);
            tinyBuilder.setStatistics(pipelineConfiguration.getConfiguration().getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
            return tinyBuilder;
        }

        @Override
        public final int getSymbolicValue() {
            return 1;
        }

        @Override
        public final boolean isSchemaAware() {
            return true;
        }

        @Override
        public final String getName() {
            return "TinyTree";
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }
}

