/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class ZeroOrMore<T extends Item<?>>
implements GroundedValue<T> {
    private List<T> a;

    public ZeroOrMore(T[] TArray) {
        this.a = Arrays.asList(TArray);
    }

    public ZeroOrMore(List<T> list) {
        this.a = list;
    }

    public ZeroOrMore(SequenceIterator<? extends T> sequenceIterator) {
        this.a = new ArrayList<T>();
        sequenceIterator.forEachOrFail(this.a::add);
    }

    @Override
    public T head() {
        if (this.a.isEmpty()) {
            return null;
        }
        return (T)((Item)this.a.get(0));
    }

    @Override
    public UnfailingIterator<T> iterate() {
        return new ListIterator<T>(this.a);
    }

    @Override
    public T itemAt(int n2) {
        if (n2 >= 0 && n2 < this.a.size()) {
            return (T)((Item)this.a.get(n2));
        }
        return null;
    }

    @Override
    public GroundedValue<T> subsequence(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 + n3 > this.a.size()) {
            n3 = this.a.size() - n2;
        }
        int n4 = n2;
        return new ZeroOrMore<T>(this.a.subList(n4, n4 + n3));
    }

    @Override
    public int getLength() {
        return this.a.size();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public GroundedValue<T> reduce() {
        if (this.a.isEmpty()) {
            return EmptySequence.getInstance();
        }
        if (this.a.size() == 1) {
            Item item = (Item)this.a.get(0);
            if (item instanceof AtomicValue) {
                return item;
            }
            return new One<T>(this.head());
        }
        return this;
    }
}

