/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public final class AnyChildNodeTest
extends NodeTest {
    private static final AnyChildNodeTest a = new AnyChildNodeTest();

    public static AnyChildNodeTest getInstance() {
        return a;
    }

    private AnyChildNodeTest() {
    }

    @Override
    public final UType getUType() {
        return UType.CHILD_NODE_KINDS;
    }

    @Override
    public final boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return n2 == 1 || n2 == 3 || n2 == 8 || n2 == 7;
    }

    @Override
    public final IntPredicate getMatcher(NodeVectorTree object) {
        byte[] byArray = object.getNodeKindArray();
        object = byArray;
        return n2 -> {
            int n3 = byArray[n2] & 0xF;
            return n3 == 1 || n3 == 3 || n3 == 4 || n3 == 8 || n3 == 7;
        };
    }

    @Override
    public final boolean matchesNode(NodeInfo nodeInfo) {
        int n2 = nodeInfo.getNodeKind();
        return n2 == 1 || n2 == 3 || n2 == 8 || n2 == 7;
    }

    @Override
    public final double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public final String toString() {
        return "( element() | text() | comment() | processing-instruction() )";
    }

    @Override
    public final String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        return "return SaxonJS.U.isNode(item) && (item.nodeType===1 || item.nodeType===3 || item.nodeType===7 || item.nodeType===8);";
    }
}

