/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public final class AnyNodeTest
extends NodeTest
implements QNameTest {
    private static AnyNodeTest a = new AnyNodeTest();

    public static AnyNodeTest getInstance() {
        return a;
    }

    private AnyNodeTest() {
    }

    @Override
    public final UType getUType() {
        return UType.ANY_NODE;
    }

    @Override
    public final boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return n2 != 12;
    }

    @Override
    public final IntPredicate getMatcher(NodeVectorTree object) {
        byte[] byArray = object.getNodeKindArray();
        object = byArray;
        return n2 -> byArray[n2] != 12;
    }

    @Override
    public final boolean matchesNode(NodeInfo nodeInfo) {
        return true;
    }

    @Override
    public final boolean matches(StructuredQName structuredQName) {
        return true;
    }

    @Override
    public final double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public final String toString() {
        return "node()";
    }

    @Override
    public final String generateJavaScriptNameTest(int n2) {
        return "true";
    }

    @Override
    public final String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        return "return SaxonJS.U.isNode(item);";
    }
}

