/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public class BasePatternWithPredicate
extends Pattern
implements PatternWithPredicate {
    private Operand a;
    private Operand b;

    public BasePatternWithPredicate(Pattern pattern, Expression expression) {
        this.a = new Operand(this, pattern, OperandRole.ATOMIC_SEQUENCE);
        this.b = new Operand(this, expression, OperandRole.FOCUS_CONTROLLED_ACTION);
        BasePatternWithPredicate basePatternWithPredicate = this;
        basePatternWithPredicate.adoptChildExpression(basePatternWithPredicate.getBasePattern());
        BasePatternWithPredicate basePatternWithPredicate2 = this;
        basePatternWithPredicate2.adoptChildExpression(basePatternWithPredicate2.getPredicate());
    }

    @Override
    public Expression getPredicate() {
        return this.b.getChildExpression();
    }

    public Pattern getBasePattern() {
        return (Pattern)this.a.getChildExpression();
    }

    @Override
    public void bindCurrent(LocalBinding localBinding) {
        Expression expression = this.getPredicate();
        if (expression.isCallOn(Current.class)) {
            this.b.setChildExpression(new LocalVariableReference(localBinding));
        } else if (ExpressionTool.callsFunction(expression, Current.FN_CURRENT, false)) {
            BasePatternWithPredicate.replaceCurrent(expression, localBinding);
        }
        this.getBasePattern().bindCurrent(localBinding);
    }

    @Override
    public boolean matchesCurrentGroup() {
        return this.getBasePattern().matchesCurrentGroup();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.a, this.b);
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int n2) {
        n2 = ExpressionTool.allocateSlots(this.getPredicate(), n2, slotManager);
        return this.getBasePattern().allocateSlots(slotManager, n2);
    }

    @Override
    public boolean matches(Item<?> item, XPathContext xPathContext) {
        if (!this.getBasePattern().matches(item, xPathContext)) {
            return false;
        }
        return this.a(item, xPathContext);
    }

    private boolean a(Item<?> object, XPathContext xPathContext) {
        xPathContext = xPathContext.newMinorContext();
        object = new ManualIterator((Item<?>)object);
        xPathContext.setCurrentIterator((FocusIterator<?>)object);
        xPathContext.setCurrentOutputUri(null);
        try {
            return this.getPredicate().effectiveBooleanValue(xPathContext);
        }
        catch (XPathException.Circularity | XPathException.StackOverflow xPathException) {
            object = xPathException;
            throw xPathException;
        }
        catch (XPathException xPathException) {
            this.handleDynamicError(xPathException, xPathContext);
            return false;
        }
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo nodeInfo, NodeInfo nodeInfo2, XPathContext xPathContext) {
        return this.getBasePattern().matchesBeneathAnchor(nodeInfo, nodeInfo2, xPathContext) && this.a(nodeInfo, xPathContext);
    }

    @Override
    public UType getUType() {
        return this.getBasePattern().getUType();
    }

    @Override
    public int getFingerprint() {
        return this.getBasePattern().getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return ((Expression)this.getBasePattern()).getItemType();
    }

    @Override
    public int getDependencies() {
        return this.getPredicate().getDependencies();
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.setChildExpression(this.getBasePattern().typeCheck(expressionVisitor, contextItemStaticInfo));
        contextItemStaticInfo = expressionVisitor.getConfiguration().makeContextItemStaticInfo(((Expression)this.getBasePattern()).getItemType(), false);
        this.b.setChildExpression(this.getPredicate().typeCheck(expressionVisitor, contextItemStaticInfo));
        return this;
    }

    @Override
    public Pattern optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.setChildExpression(this.getBasePattern().optimize(expressionVisitor, contextItemStaticInfo));
        contextItemStaticInfo = expressionVisitor.getConfiguration().makeContextItemStaticInfo(((Expression)this.getBasePattern()).getItemType(), false);
        this.b.setChildExpression(this.getPredicate().optimize(expressionVisitor, contextItemStaticInfo));
        this.b.setChildExpression(expressionVisitor.obtainOptimizer().eliminateCommonSubexpressions(this.getPredicate()));
        return this;
    }

    @Override
    public Pattern convertToTypedPattern(String object) {
        object = this.getBasePattern().convertToTypedPattern((String)object);
        if (object == this.getBasePattern()) {
            return this;
        }
        return new BasePatternWithPredicate((Pattern)object, this.getPredicate());
    }

    @Override
    public String toString() {
        return this.getBasePattern() + "[" + this.getPredicate() + "]";
    }

    @Override
    public String toShortString() {
        return ((Expression)this.getBasePattern()).toShortString() + "[" + this.getPredicate().toShortString() + "]";
    }

    @Override
    public Pattern copy(RebindingMap object) {
        object = new BasePatternWithPredicate(this.getBasePattern().copy((RebindingMap)object), this.getPredicate().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BasePatternWithPredicate && ((BasePatternWithPredicate)object).getBasePattern().isEqual(this.getBasePattern()) && ((BasePatternWithPredicate)object).getPredicate().isEqual(this.getPredicate());
    }

    @Override
    public int computeHashCode() {
        return this.getBasePattern().hashCode() ^ this.getPredicate().hashCode();
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("p.withPredicate");
        ((Expression)this.getBasePattern()).export(expressionPresenter);
        this.getPredicate().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

