/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public class BooleanExpressionPattern
extends Pattern
implements PatternWithPredicate {
    private Operand a;

    public BooleanExpressionPattern(Expression expression) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        this.setPriority(1.0);
    }

    @Override
    public Expression getPredicate() {
        return this.a.getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.a;
    }

    @Override
    public UType getUType() {
        if (this.getPredicate() instanceof InstanceOfExpression) {
            return ((InstanceOfExpression)this.getPredicate()).getRequiredItemType().getUType();
        }
        return UType.ANY;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int n2) {
        return ExpressionTool.allocateSlots(this.getPredicate(), n2, slotManager);
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        contextItemStaticInfo = expressionVisitor.getConfiguration().getDefaultContextItemStaticInfo();
        this.a.setChildExpression(this.getPredicate().typeCheck(expressionVisitor, contextItemStaticInfo));
        return this;
    }

    @Override
    public Pattern optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        contextItemStaticInfo = expressionVisitor.getConfiguration().getDefaultContextItemStaticInfo();
        this.a.setChildExpression(this.getPredicate().optimize(expressionVisitor, contextItemStaticInfo));
        return this;
    }

    @Override
    public boolean matches(Item<?> object, XPathContext xPathContext) {
        xPathContext = xPathContext.newMinorContext();
        object = new ManualIterator((Item<?>)object);
        xPathContext.setCurrentIterator((FocusIterator<?>)object);
        xPathContext.setCurrentOutputUri(null);
        try {
            return this.getPredicate().effectiveBooleanValue(xPathContext);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    @Override
    public ItemType getItemType() {
        InstanceOfExpression instanceOfExpression;
        if (this.getPredicate() instanceof InstanceOfExpression && (instanceOfExpression = (InstanceOfExpression)this.getPredicate()).getBaseExpression() instanceof ContextItemExpression) {
            return instanceOfExpression.getRequiredItemType();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public String toString() {
        return ".[" + this.getPredicate() + "]";
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BooleanExpressionPattern && ((BooleanExpressionPattern)object).getPredicate().isEqual(this.getPredicate());
    }

    @Override
    public int computeHashCode() {
        return 0x7AEFFEA9 ^ this.getPredicate().hashCode();
    }

    @Override
    public Pattern copy(RebindingMap object) {
        object = new BooleanExpressionPattern(this.getPredicate().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("p.booleanExp");
        this.getPredicate().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

