/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntExceptPredicate;
import net.sf.saxon.z.IntSet;

public class CombinedNodeTest
extends NodeTest {
    private NodeTest a;
    private NodeTest b;
    private int c;

    public CombinedNodeTest(NodeTest nodeTest, int n2, NodeTest nodeTest2) {
        this.a = nodeTest;
        this.c = n2;
        this.b = nodeTest2;
    }

    @Override
    public UType getUType() {
        UType uType = this.a.getUType();
        UType uType2 = this.b.getUType();
        switch (this.c) {
            case 1: {
                return uType.union(uType2);
            }
            case 23: {
                return uType.intersection(uType2);
            }
            case 24: {
                return uType;
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    @Override
    public boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        switch (this.c) {
            case 1: {
                return this.a == null || this.b == null || this.a.matches(n2, nodeName, schemaType) || this.b.matches(n2, nodeName, schemaType);
            }
            case 23: {
                return !(this.a != null && !this.a.matches(n2, nodeName, schemaType) || this.b != null && !this.b.matches(n2, nodeName, schemaType));
            }
            case 24: {
                return (this.a == null || this.a.matches(n2, nodeName, schemaType)) && this.b != null && !this.b.matches(n2, nodeName, schemaType);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree nodeVectorTree) {
        switch (this.c) {
            case 1: {
                return this.a.getMatcher(nodeVectorTree).or(this.b.getMatcher(nodeVectorTree));
            }
            case 23: {
                return this.a.getMatcher(nodeVectorTree).and(this.b.getMatcher(nodeVectorTree));
            }
            case 24: {
                return new IntExceptPredicate(this.a.getMatcher(nodeVectorTree), this.b.getMatcher(nodeVectorTree));
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    @Override
    public boolean matchesNode(NodeInfo nodeInfo) {
        switch (this.c) {
            case 1: {
                return this.a == null || this.b == null || this.a.matchesNode(nodeInfo) || this.b.matchesNode(nodeInfo);
            }
            case 23: {
                return !(this.a != null && !this.a.matchesNode(nodeInfo) || this.b != null && !this.b.matchesNode(nodeInfo));
            }
            case 24: {
                return (this.a == null || this.a.matchesNode(nodeInfo)) && this.b != null && !this.b.matchesNode(nodeInfo);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    @Override
    public String toString() {
        return this.a(false);
    }

    private String a(boolean bl2) {
        if (this.a instanceof NameTest && this.c == 23) {
            Object object;
            int n2 = this.a.getPrimitiveType();
            String string = n2 == 1 ? "element(" : "attribute(";
            String string2 = "";
            if (this.b instanceof ContentTypeTest) {
                object = ((ContentTypeTest)this.b).getSchemaType();
                if (bl2) {
                    object = object.getNearestNamedType();
                }
                string2 = ", " + object.getEQName();
                if (this.b.isNillable()) {
                    string2 = string2 + "?";
                }
            }
            object = this.a.getMatchingNodeName().getEQName();
            return string + (String)object + string2 + ')';
        }
        String string = this.a == null ? "item()" : this.a.toString();
        String string3 = this.b == null ? "item()" : this.b.toString();
        return "(" + string + ' ' + Token.tokens[this.c] + ' ' + string3 + ')';
    }

    @Override
    public String toExportString() {
        return this.a(true);
    }

    public void addTypeDetails(DictionaryMap dictionaryMap) {
        if (this.a instanceof NameTest && this.c == 23) {
            dictionaryMap.initialPut("n", new StringValue(this.a.getMatchingNodeName().getEQName()));
            if (this.b instanceof ContentTypeTest) {
                SchemaType schemaType = ((ContentTypeTest)this.b).getSchemaType();
                dictionaryMap.initialPut("c", new StringValue(schemaType.getEQName() + (this.b.isNillable() ? "?" : "")));
            }
        }
    }

    @Override
    public int getPrimitiveType() {
        UType uType = this.getUType();
        if (uType.equals(UType.ELEMENT)) {
            return 1;
        }
        if (uType.equals(UType.ATTRIBUTE)) {
            return 2;
        }
        if (uType.equals(UType.DOCUMENT)) {
            return 9;
        }
        return 0;
    }

    @Override
    public Optional<IntSet> getRequiredNodeNames() {
        Object object = this.a.getRequiredNodeNames();
        Object object2 = this.b.getRequiredNodeNames();
        if (((Optional)object).isPresent() && ((Optional)object2).isPresent()) {
            object = ((Optional)object).get();
            object2 = ((Optional)object2).get();
            switch (this.c) {
                case 1: {
                    return Optional.of(object.union((IntSet)object2));
                }
                case 23: {
                    return Optional.of(object.intersect((IntSet)object2));
                }
                case 24: {
                    return Optional.of(object.except((IntSet)object2));
                }
            }
            throw new IllegalStateException();
        }
        return Optional.empty();
    }

    @Override
    public SchemaType getContentType() {
        SchemaType schemaType;
        SchemaType schemaType2 = this.a.getContentType();
        if (schemaType2.isSameType(schemaType = this.b.getContentType())) {
            return schemaType2;
        }
        if (this.c == 23) {
            if (schemaType instanceof AnyType || schemaType instanceof AnySimpleType && schemaType2.isSimpleType()) {
                return schemaType2;
            }
            if (schemaType2 instanceof AnyType || schemaType2 instanceof AnySimpleType && schemaType.isSimpleType()) {
                return schemaType;
            }
        }
        return AnyType.getInstance();
    }

    @Override
    public AtomicType getAtomizedItemType() {
        AtomicType atomicType;
        AtomicType atomicType2 = this.a.getAtomizedItemType();
        if (atomicType2.isSameType(atomicType = this.b.getAtomizedItemType())) {
            return atomicType2;
        }
        if (this.c == 23) {
            if (atomicType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return atomicType2;
            }
            if (atomicType2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return atomicType;
            }
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        switch (this.c) {
            case 1: {
                return this.a.isAtomizable(typeHierarchy) || this.b.isAtomizable(typeHierarchy);
            }
            case 23: {
                return this.a.isAtomizable(typeHierarchy) && this.b.isAtomizable(typeHierarchy);
            }
            case 24: {
                return this.a.isAtomizable(typeHierarchy);
            }
        }
        return true;
    }

    @Override
    public int getFingerprint() {
        int n2;
        int n3 = this.a.getFingerprint();
        if (n3 == (n2 = this.b.getFingerprint())) {
            return n3;
        }
        if (n2 == -1 && this.c == 23) {
            return n3;
        }
        if (n3 == -1 && this.c == 23) {
            return n2;
        }
        return -1;
    }

    @Override
    public StructuredQName getMatchingNodeName() {
        StructuredQName structuredQName = this.a.getMatchingNodeName();
        StructuredQName structuredQName2 = this.b.getMatchingNodeName();
        if (structuredQName != null && structuredQName.equals(structuredQName2)) {
            return structuredQName;
        }
        if (structuredQName == null && this.c == 23) {
            return structuredQName2;
        }
        if (structuredQName2 == null && this.c == 23) {
            return structuredQName;
        }
        return null;
    }

    @Override
    public boolean isNillable() {
        return this.a.isNillable() && this.b.isNillable();
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof CombinedNodeTest && ((CombinedNodeTest)object).a.equals(this.a) && ((CombinedNodeTest)object).b.equals(this.b) && ((CombinedNodeTest)object).c == this.c;
    }

    @Override
    public double getDefaultPriority() {
        if (this.c == 1) {
            return this.a.getDefaultPriority();
        }
        return 0.25;
    }

    public NodeTest[] getComponentNodeTests() {
        return new NodeTest[]{this.a, this.b};
    }

    public int getOperator() {
        return this.c;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        String string = null;
        switch (this.c) {
            case 1: {
                string = "||";
                break;
            }
            case 23: {
                string = "&&";
                break;
            }
            case 24: {
                string = "&&!";
            }
        }
        fastStringBuffer.append("function a() {" + this.a.generateJavaScriptItemTypeTest(itemType, n2) + "};");
        fastStringBuffer.append("function b() {" + this.b.generateJavaScriptItemTypeTest(itemType, n2) + "};");
        fastStringBuffer.append("return a()" + string + "b();");
        return fastStringBuffer.toString();
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy typeHierarchy) {
        Optional<String> optional = super.explainMismatch(item, typeHierarchy);
        if (optional.isPresent()) {
            return optional;
        }
        if (this.c == 23) {
            if (!this.a.matchesNode((NodeInfo)item)) {
                return this.a.explainMismatch(item, typeHierarchy);
            }
            if (!this.b.matchesNode((NodeInfo)item)) {
                return this.b.explainMismatch(item, typeHierarchy);
            }
        }
        return Optional.empty();
    }
}

