/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.Nilled_1;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;

public class ContentTypeTest
extends NodeTest {
    private int a;
    private SchemaType b;
    private Configuration c;
    private boolean d = false;

    public ContentTypeTest(int n2, SchemaType schemaType, Configuration configuration, boolean bl2) {
        this.a = n2;
        this.b = schemaType;
        this.c = configuration;
        this.d = bl2;
    }

    @Override
    public UType getUType() {
        if (this.a == 1) {
            return UType.ELEMENT;
        }
        return UType.ATTRIBUTE;
    }

    public void setNillable(boolean bl2) {
        this.d = bl2;
    }

    @Override
    public boolean isNillable() {
        return this.d;
    }

    public SchemaType getSchemaType() {
        return this.b;
    }

    public int getNodeKind() {
        return this.a;
    }

    @Override
    public boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return this.a == n2 && this.a(schemaType);
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree nodeVectorTree) {
        byte[] byArray = nodeVectorTree.getNodeKindArray();
        return n2 -> (byArray[n2] & 0xF) == this.a && this.a(((TinyTree)nodeVectorTree).getSchemaType(n2)) && (this.d || !((TinyTree)nodeVectorTree).isNilled(n2));
    }

    @Override
    public boolean matchesNode(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.a && this.a(nodeInfo.getSchemaType()) && (this.d || !Nilled_1.isNilled(nodeInfo));
    }

    private boolean a(SchemaType schemaType) {
        if (schemaType == null) {
            return false;
        }
        if (this.b == AnyType.getInstance()) {
            return true;
        }
        if (schemaType.equals(this.b)) {
            return true;
        }
        int n2 = this.c.getTypeHierarchy().schemaTypeRelationship(schemaType, this.b);
        return n2 == 0 || n2 == 2;
    }

    @Override
    public final double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public int getPrimitiveType() {
        return this.a;
    }

    @Override
    public SchemaType getContentType() {
        return this.b;
    }

    @Override
    public AtomicType getAtomizedItemType() {
        SchemaType schemaType = this.b;
        try {
            if (schemaType.isAtomicType()) {
                return (AtomicType)schemaType;
            }
            if (schemaType instanceof ListType) {
                if ((schemaType = ((ListType)schemaType).getItemType()).isAtomicType()) {
                    return (AtomicType)schemaType;
                }
            } else if (schemaType instanceof ComplexType && ((ComplexType)schemaType).isSimpleContent()) {
                schemaType = ((ComplexType)schemaType).getSimpleContentType();
                assert (schemaType != null);
                if (schemaType.isAtomicType()) {
                    return (AtomicType)schemaType;
                }
                if (schemaType instanceof ListType && (schemaType = ((ListType)schemaType).getItemType()).isAtomicType()) {
                    return (AtomicType)schemaType;
                }
            }
        }
        catch (MissingComponentException missingComponentException) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        return !this.b.isComplexType() || ((ComplexType)this.b).getVariety() != 2;
    }

    @Override
    public String toString() {
        return (this.a == 1 ? "element(*, " : "attribute(*, ") + this.b.getEQName() + ')';
    }

    @Override
    public String toExportString() {
        return (this.a == 1 ? "element(*, " : "attribute(*, ") + this.b.getNearestNamedType().getEQName() + ')';
    }

    public int hashCode() {
        return this.a << 20 ^ this.b.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ContentTypeTest && ((ContentTypeTest)object).a == this.a && ((ContentTypeTest)object).b == this.b && ((ContentTypeTest)object).d == this.d;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        if (this.a == 1) {
            if (this.b == Untyped.getInstance() || this.b == AnyType.getInstance()) {
                return NodeKindTest.makeNodeKindTest(this.getNodeKind()).generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2);
            }
            if (this.b == BuiltInAtomicType.UNTYPED_ATOMIC || this.b == BuiltInAtomicType.ANY_ATOMIC) {
                return "return false;";
            }
        } else if (this.a == 2 && (this.b == Untyped.getInstance() || this.b == AnyType.getInstance() || this.b == BuiltInAtomicType.UNTYPED_ATOMIC || this.b == BuiltInAtomicType.ANY_ATOMIC)) {
            return NodeKindTest.makeNodeKindTest(this.getNodeKind()).generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2);
        }
        throw new XPathException("Cannot generate JS code to test type annotations", "SXJS0001");
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy object) {
        if (((Optional)(object = super.explainMismatch(item, (TypeHierarchy)object))).isPresent()) {
            return object;
        }
        object = (NodeInfo)item;
        if (!this.a(((NodeInfo)item).getSchemaType())) {
            if (object.getSchemaType() == Untyped.getInstance()) {
                return Optional.of("The supplied node has not been schema-validated");
            }
            if (object.getSchemaType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                return Optional.of("The supplied node has not been schema-validated");
            }
            return Optional.of("The supplied node has the wrong type annotation (" + object.getSchemaType().getDescription() + ")");
        }
        if (Nilled_1.isNilled((NodeInfo)object) && !this.d) {
            return Optional.of("The supplied node has xsi:nil='true', which the required type does not allow");
        }
        return Optional.empty();
    }
}

