/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest a;

    public DocumentNodeTest(NodeTest nodeTest) {
        this.a = nodeTest;
    }

    @Override
    public UType getUType() {
        return UType.DOCUMENT;
    }

    @Override
    public boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        if (n2 != 9) {
            return false;
        }
        throw new UnsupportedOperationException("DocumentNodeTest doesn't support this method");
    }

    @Override
    public boolean matchesNode(NodeInfo object) {
        NodeInfo nodeInfo;
        if (object.getNodeKind() != 9) {
            return false;
        }
        object = object.iterateAxis((byte)3);
        boolean bl2 = false;
        while ((nodeInfo = object.next()) != null) {
            int n2 = nodeInfo.getNodeKind();
            if (n2 == 3) {
                return false;
            }
            if (n2 != 1) continue;
            if (bl2) {
                return false;
            }
            if (this.a.matchesNode(nodeInfo)) {
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl2;
    }

    @Override
    public final double getDefaultPriority() {
        return this.a.getDefaultPriority();
    }

    @Override
    public int getPrimitiveType() {
        return 9;
    }

    public NodeTest getElementTest() {
        return this.a;
    }

    @Override
    public String toString() {
        return "document-node(" + this.a + ')';
    }

    public int hashCode() {
        return this.a.hashCode() ^ 0x3039;
    }

    public boolean equals(Object object) {
        return object instanceof DocumentNodeTest && ((DocumentNodeTest)object).a.equals(this.a);
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType object, int n2) {
        object = "function e(item) {" + this.a.generateJavaScriptItemTypeTest(NodeKindTest.ELEMENT, n2) + "};";
        if (n2 == 1) {
            return (String)object + "return SaxonJS.U.isNode(item) && (item.nodeType===9 || item.nodeType===11) && SaxonJS.U.Axis.child(item).filter(e).next();";
        }
        return (String)object + "return SaxonJS.U.isConstrainedDocumentNode(item, e);";
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy object2) {
        NodeInfo nodeInfo;
        Optional<String> optional = super.explainMismatch((Item)object, (TypeHierarchy)object2);
        if (optional.isPresent()) {
            return optional;
        }
        object = (NodeInfo)object;
        object = object.iterateAxis((byte)3);
        boolean bl2 = false;
        while ((nodeInfo = object.next()) != null) {
            int n2 = nodeInfo.getNodeKind();
            if (n2 == 3) {
                return Optional.of("The supplied document node has text node children");
            }
            if (n2 != 1) continue;
            if (bl2) {
                return Optional.of("The supplied document node has more than one element child");
            }
            if (this.a.matchesNode(nodeInfo)) {
                bl2 = true;
                continue;
            }
            object = "The supplied document node has an element child (" + Err.depict(nodeInfo) + ") that does not satisfy the element test";
            if (((Optional)(object2 = this.a.explainMismatch(nodeInfo, (TypeHierarchy)object2))).isPresent()) {
                object = (String)object + ". " + (String)((Optional)object2).get();
            }
            return Optional.of(object);
        }
        return Optional.empty();
    }
}

