/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.NumericValue;

public class GeneralPositionalPattern
extends Pattern {
    private NodeTest a;
    private Expression b;
    private boolean c = true;

    public GeneralPositionalPattern(NodeTest nodeTest, Expression expression) {
        this.a = nodeTest;
        this.b = expression;
    }

    @Override
    public Iterable<Operand> operands() {
        GeneralPositionalPattern generalPositionalPattern = this;
        return new Operand(generalPositionalPattern, generalPositionalPattern.b, OperandRole.FOCUS_CONTROLLED_ACTION);
    }

    public Expression getPositionExpr() {
        return this.b;
    }

    public NodeTest getNodeTest() {
        return this.a;
    }

    public void setUsesPosition(boolean bl2) {
        this.c = bl2;
    }

    @Override
    public Pattern simplify() {
        this.b = this.b.simplify();
        return this;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        contextItemStaticInfo = expressionVisitor.getConfiguration().makeContextItemStaticInfo(((Expression)this).getItemType(), false);
        this.b = this.b.typeCheck(expressionVisitor, contextItemStaticInfo);
        this.b = ExpressionTool.unsortedIfHomogeneous(this.b, false);
        return this;
    }

    @Override
    public Pattern optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Configuration configuration = expressionVisitor.getConfiguration();
        ContextItemStaticInfo contextItemStaticInfo2 = configuration.makeContextItemStaticInfo(((Expression)this).getItemType(), false);
        this.b = this.b.optimize(expressionVisitor, contextItemStaticInfo2);
        if (Literal.isConstantBoolean(this.b, true)) {
            return new NodeTestPattern(this.a);
        }
        if (Literal.isConstantBoolean(this.b, false)) {
            return new NodeTestPattern(ErrorType.getInstance());
        }
        if ((this.b.getDependencies() & 4) == 0) {
            this.c = false;
        }
        if (!FilterExpression.isPositionalFilter(this.b, configuration.getTypeHierarchy())) {
            byte by = 3;
            if (this.a.getPrimitiveType() == 2) {
                by = 2;
            } else if (this.a.getPrimitiveType() == 13) {
                by = 8;
            }
            Expression expression = new AxisExpression(by, this.a);
            expression = new FilterExpression(expression, this.b);
            return PatternMaker.fromExpression(expression, configuration, true).typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.b.getDependencies() & 0x180;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int n2) {
        return ExpressionTool.allocateSlots(this.b, n2, slotManager);
    }

    @Override
    public boolean matches(Item<?> item, XPathContext xPathContext) {
        return item instanceof NodeInfo && ((Pattern)this).matchesBeneathAnchor((NodeInfo)item, null, xPathContext);
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo nodeInfo, NodeInfo nodeInfo2, XPathContext xPathContext) {
        return this.a(nodeInfo, xPathContext);
    }

    private boolean a(NodeInfo nodeInfo, XPathContext xPathContext) {
        if (!this.a.matchesNode(nodeInfo)) {
            return false;
        }
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        Object object = new ManualIterator<NodeInfo>(nodeInfo);
        xPathContextMinor.setCurrentIterator((FocusIterator<?>)object);
        try {
            Object object2;
            object = xPathContextMinor;
            int n2 = -1;
            if (this.c) {
                n2 = this.a(nodeInfo, Integer.MAX_VALUE, xPathContext.getCurrentIterator());
                object = new ManualIterator<NodeInfo>(nodeInfo, n2);
                object2 = xPathContextMinor.newMinorContext();
                object2.setCurrentIterator((FocusIterator<?>)object);
                object = object2;
            }
            if ((object = this.b.evaluateItem((XPathContext)object)) instanceof NumericValue) {
                object2 = (NumericValue)this.b.evaluateItem(xPathContext);
                int n3 = ((NumericValue)object2).asSubscript();
                if (n2 < 0 && n3 != -1) {
                    n2 = this.a(nodeInfo, n3, xPathContext.getCurrentIterator());
                }
                return n3 != -1 && n2 == n3;
            }
            return ExpressionTool.effectiveBooleanValue(object);
        }
        catch (XPathException.Circularity | XPathException.StackOverflow xPathException) {
            object = xPathException;
            throw xPathException;
        }
        catch (XPathException xPathException) {
            this.handleDynamicError(xPathException, xPathContextMinor);
            return false;
        }
    }

    private int a(NodeInfo nodeInfo, int n2, FocusIterator focusIterator) {
        if (focusIterator instanceof FocusTrackingIterator) {
            return ((FocusTrackingIterator)focusIterator).getSiblingPosition(nodeInfo, this.a, n2);
        }
        return Navigator.getSiblingPosition(nodeInfo, this.a, n2);
    }

    @Override
    public UType getUType() {
        return this.a.getUType();
    }

    @Override
    public int getFingerprint() {
        return this.a.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.a;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GeneralPositionalPattern) {
            object = (GeneralPositionalPattern)object;
            return this.a.equals(((GeneralPositionalPattern)object).a) && this.b.isEqual(((GeneralPositionalPattern)object).b);
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    @Override
    public Pattern copy(RebindingMap object) {
        object = new GeneralPositionalPattern(this.a.copy(), this.b.copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public String toString() {
        return this.a + "[" + this.b + "]";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("p.genPos");
        expressionPresenter.emitAttribute("type", this.a.toString());
        if (!this.c) {
            expressionPresenter.emitAttribute("flags", "P");
        }
        if ("JS".equals(((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).target)) {
            try {
                int n2 = ((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).targetVersion;
                expressionPresenter.emitAttribute("jsTest", this.a.generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2));
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw xPathException2;
            }
        }
        this.b.export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

