/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntSet;

public final class LocalNameTest
extends NodeTest
implements QNameTest {
    private NamePool a;
    private int b;
    private String c;
    private UType d;

    public LocalNameTest(NamePool namePool, int n2, String string) {
        this.a = namePool;
        this.b = n2;
        this.c = string;
        this.d = UType.fromTypeCode(n2);
    }

    public final int getNodeKind() {
        return this.b;
    }

    @Override
    public final UType getUType() {
        return this.d;
    }

    @Override
    public final Optional<IntSet> getRequiredNodeNames() {
        return Optional.empty();
    }

    @Override
    public final boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return nodeName != null && n2 == this.b && this.c.equals(nodeName.getLocalPart());
    }

    @Override
    public final IntPredicate getMatcher(NodeVectorTree object) {
        byte[] byArray = object.getNodeKindArray();
        object = object.getNameCodeArray();
        return arg_0 -> this.a(byArray, (int[])object, arg_0);
    }

    @Override
    public final boolean matchesNode(NodeInfo nodeInfo) {
        return this.c.equals(nodeInfo.getLocalPart()) && this.b == nodeInfo.getNodeKind();
    }

    @Override
    public final boolean matches(StructuredQName structuredQName) {
        return this.c.equals(structuredQName.getLocalPart());
    }

    @Override
    public final double getDefaultPriority() {
        return -0.25;
    }

    public final String getLocalName() {
        return this.c;
    }

    @Override
    public final int getPrimitiveType() {
        return this.b;
    }

    @Override
    public final String toString() {
        switch (this.b) {
            case 1: {
                return "*:" + this.c;
            }
            case 2: {
                return "@*:" + this.c;
            }
        }
        return "(*" + this.b + "*):" + this.c;
    }

    public final int hashCode() {
        return this.b << 20 ^ this.c.hashCode();
    }

    public final boolean equals(Object object) {
        return object instanceof LocalNameTest && ((LocalNameTest)object).b == this.b && ((LocalNameTest)object).c.equals(this.c);
    }

    public final NamePool getNamePool() {
        return this.a;
    }

    @Override
    public final String generateJavaScriptNameTest(int n2) {
        return "q.local==='" + this.c + "'";
    }

    @Override
    public final String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        if (n2 == 1) {
            return "var q=SaxonJS.U.nameOfNode(item); return SaxonJS.U.isNode(item) && item.nodeType===" + this.b + "&&" + this.generateJavaScriptNameTest(n2);
        }
        return "return SaxonJS.U.isNode(item) && item.nodeType===" + this.b + " && SaxonJS.U.hasLocalName(item, '" + this.c + "')";
    }

    @Override
    public final Optional<String> explainMismatch(Item object, TypeHierarchy typeHierarchy) {
        if (((Optional)(object = super.explainMismatch((Item)object, typeHierarchy))).isPresent()) {
            return object;
        }
        return Optional.of("The node has the wrong local name");
    }

    private /* synthetic */ boolean a(byte[] byArray, int[] nArray, int n2) {
        return (byArray[n2] & 0xF) == this.b && this.c.equals(this.a.getLocalName(nArray[n2] & 0xFFFFF));
    }
}

