/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public final class MultipleNodeKindTest
extends NodeTest {
    public static final MultipleNodeKindTest PARENT_NODE = new MultipleNodeKindTest(UType.DOCUMENT.union(UType.ELEMENT));
    public static final MultipleNodeKindTest DOC_ELEM_ATTR = new MultipleNodeKindTest(UType.DOCUMENT.union(UType.ELEMENT).union(UType.ATTRIBUTE));
    public static final MultipleNodeKindTest LEAF = new MultipleNodeKindTest(UType.TEXT.union(UType.COMMENT).union(UType.PI).union(UType.NAMESPACE).union(UType.ATTRIBUTE));
    private UType a;
    private int b;

    public MultipleNodeKindTest(UType uType) {
        this.a = uType;
        if (UType.DOCUMENT.overlaps(uType)) {
            this.b |= 0x200;
        }
        if (UType.ELEMENT.overlaps(uType)) {
            this.b |= 2;
        }
        if (UType.ATTRIBUTE.overlaps(uType)) {
            this.b |= 4;
        }
        if (UType.TEXT.overlaps(uType)) {
            this.b |= 8;
        }
        if (UType.COMMENT.overlaps(uType)) {
            this.b |= 0x100;
        }
        if (UType.PI.overlaps(uType)) {
            this.b |= 0x80;
        }
        if (UType.NAMESPACE.overlaps(uType)) {
            this.b |= 0x2000;
        }
    }

    @Override
    public final UType getUType() {
        return this.a;
    }

    @Override
    public final boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return (this.b & 1 << n2) != 0;
    }

    @Override
    public final IntPredicate getMatcher(NodeVectorTree object) {
        object = object.getNodeKindArray();
        return arg_0 -> this.a((byte[])object, arg_0);
    }

    @Override
    public final boolean matchesNode(NodeInfo nodeInfo) {
        int n2 = nodeInfo.getNodeKind();
        return (this.b & 1 << n2) != 0;
    }

    @Override
    public final double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public final String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        LinkedList<PrimitiveUType> linkedList = new LinkedList<PrimitiveUType>(this.a.decompose());
        this.a(linkedList, fastStringBuffer, ItemType::toString);
        return fastStringBuffer.toString();
    }

    @Override
    public final String toExportString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        LinkedList<PrimitiveUType> linkedList = new LinkedList<PrimitiveUType>(this.a.decompose());
        this.a(linkedList, fastStringBuffer, ItemType::toExportString);
        return fastStringBuffer.toString();
    }

    private void a(LinkedList<PrimitiveUType> linkedList, FastStringBuffer fastStringBuffer, Function<ItemType, String> function) {
        if (linkedList.size() == 1) {
            fastStringBuffer.append(linkedList.get(0).toItemType().toString());
            return;
        }
        fastStringBuffer.append('(');
        fastStringBuffer.append(linkedList.removeFirst().toItemType().toString());
        fastStringBuffer.append('|');
        this.a(linkedList, fastStringBuffer, function);
        fastStringBuffer.append(')');
    }

    public final int hashCode() {
        return this.a.hashCode();
    }

    public final boolean equals(Object object) {
        return object instanceof MultipleNodeKindTest && this.a.equals(((MultipleNodeKindTest)object).a);
    }

    @Override
    public final String generateJavaScriptItemTypeTest(ItemType object, int n2) {
        object = new FastStringBuffer(256);
        ((FastStringBuffer)object).append("return SaxonJS.U.isNode(item) && (");
        String string = "";
        UType uType = this.a;
        if (UType.DOCUMENT.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===9||item.nodeType===11");
            string = "||";
        }
        if (UType.ELEMENT.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===1");
            string = "||";
        }
        if (UType.ATTRIBUTE.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===2");
            string = "||";
        }
        if (UType.TEXT.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===3");
            string = "||";
        }
        if (UType.COMMENT.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===8");
            string = "||";
        }
        if (UType.PI.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===7");
            string = "||";
        }
        if (UType.NAMESPACE.overlaps(uType)) {
            ((FastStringBuffer)object).append(string + "item.nodeType===13");
        }
        ((FastStringBuffer)object).append(");");
        return ((FastStringBuffer)object).toString().replace("false||", "");
    }

    private /* synthetic */ boolean a(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xF;
        if (n3 == 4) {
            n3 = 3;
        }
        return (this.b & 1 << n3) != 0;
    }
}

