/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class NameTest
extends NodeTest
implements QNameTest {
    private int a;
    private int b;
    private UType c;
    private NamePool d;
    private String e = null;
    private String f = null;

    public NameTest(int n2, String string, String string2, NamePool namePool) {
        this.e = string;
        this.f = string2;
        this.a = n2;
        this.b = namePool.allocateFingerprint(string, string2) & 0xFFFFF;
        this.d = namePool;
        this.c = UType.fromTypeCode(n2);
    }

    public NameTest(int n2, int n3, NamePool namePool) {
        this.a = n2;
        this.b = n3 & 0xFFFFF;
        this.d = namePool;
        this.c = UType.fromTypeCode(n2);
    }

    public NameTest(int n2, NodeName nodeName, NamePool namePool) {
        this.e = nodeName.getURI();
        this.f = nodeName.getLocalPart();
        this.a = n2;
        this.b = nodeName.obtainFingerprint(namePool);
        this.d = namePool;
        this.c = UType.fromTypeCode(n2);
    }

    public NamePool getNamePool() {
        return this.d;
    }

    public int getNodeKind() {
        return this.a;
    }

    @Override
    public UType getUType() {
        return this.c;
    }

    @Override
    public boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        if (n2 != this.a) {
            return false;
        }
        if (nodeName.hasFingerprint()) {
            return nodeName.getFingerprint() == this.b;
        }
        this.a();
        return nodeName.hasURI(this.e) && nodeName.getLocalPart().equals(this.f);
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree object) {
        byte[] byArray = object.getNodeKindArray();
        object = object.getNameCodeArray();
        return arg_0 -> this.a((int[])object, byArray, arg_0);
    }

    @Override
    public boolean matchesNode(NodeInfo nodeInfo) {
        if (nodeInfo.getNodeKind() != this.a) {
            return false;
        }
        if (nodeInfo.hasFingerprint()) {
            return nodeInfo.getFingerprint() == this.b;
        }
        this.a();
        return this.f.equals(nodeInfo.getLocalPart()) && this.e.equals(nodeInfo.getURI());
    }

    private void a() {
        if (this.e == null || this.f == null) {
            StructuredQName structuredQName = this.d.getUnprefixedQName(this.b);
            this.e = structuredQName.getURI();
            this.f = structuredQName.getLocalPart();
        }
    }

    @Override
    public boolean matches(StructuredQName structuredQName) {
        this.a();
        return structuredQName.getLocalPart().equals(this.f) && structuredQName.hasURI(this.e);
    }

    @Override
    public final double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public int getFingerprint() {
        return this.b;
    }

    @Override
    public StructuredQName getMatchingNodeName() {
        this.a();
        return new StructuredQName("", this.e, this.f);
    }

    @Override
    public int getPrimitiveType() {
        return this.a;
    }

    @Override
    public Optional<IntSet> getRequiredNodeNames() {
        return Optional.of(new IntSingletonSet(this.b));
    }

    public String getNamespaceURI() {
        this.a();
        return this.e;
    }

    public String getLocalPart() {
        this.a();
        return this.f;
    }

    @Override
    public String toString() {
        switch (this.a) {
            case 1: {
                return "element(" + this.d.getEQName(this.b) + ")";
            }
            case 2: {
                return "attribute(" + this.d.getEQName(this.b) + ")";
            }
            case 7: {
                return "processing-instruction(" + this.d.getLocalName(this.b) + ')';
            }
            case 13: {
                return "namespace-node(" + this.d.getLocalName(this.b) + ')';
            }
        }
        return this.d.getEQName(this.b);
    }

    public int hashCode() {
        return this.a << 20 ^ this.b;
    }

    public boolean equals(Object object) {
        return object instanceof NameTest && ((NameTest)object).d == this.d && ((NameTest)object).a == this.a && ((NameTest)object).b == this.b;
    }

    @Override
    public String generateJavaScriptNameTest(int n2) {
        this.a();
        return "q.uri==='" + ExpressionPresenter.jsEscape(this.e) + "'&&q.local==='" + this.f + "'";
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = itemType.getUType() == this.getUType();
        if (this.a == 2 && this.getNamespaceURI().equals("")) {
            String string = "item.name==='" + this.getLocalPart() + "'";
            return "return " + (bl2 ? string : "SaxonJS.U.isAttr(item) && " + string);
        }
        String string = "";
        if (!bl2) {
            string = itemType instanceof NodeTest ? "item.nodeType===" + this.a + " && " : (this.a == 2 ? "SaxonJS.U.isAttr(item) && " : (this.a == 13 ? "SaxonJS.U.isNamespaceNode(item) && " : "SaxonJS.U.isNode(item) && item.nodeType===" + this.a + " && "));
        }
        if (n2 == 1) {
            return "var q=SaxonJS.U.nameOfNode(item); return " + string + this.generateJavaScriptNameTest(n2) + ";";
        }
        this.a();
        return "return " + string + "SaxonJS.U.hasLocalName(item,'" + this.f + "')&&SaxonJS.U.hasURI(item,'" + ExpressionPresenter.jsEscape(this.e) + "')";
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy typeHierarchy) {
        if (((Optional)(object = super.explainMismatch((Item)object, typeHierarchy))).isPresent()) {
            return object;
        }
        return Optional.of("The node has the wrong name");
    }

    @Override
    public String toShortString() {
        switch (this.a) {
            case 1: {
                if (this.getNamespaceURI().isEmpty()) {
                    return this.d.getLocalName(((NodeTest)this).getFingerprint());
                }
                return this.toString();
            }
            case 2: {
                return "@" + (this.getNamespaceURI().isEmpty() ? this.d.getLocalName(((NodeTest)this).getFingerprint()) : this.toString());
            }
        }
        return this.toString();
    }

    private /* synthetic */ boolean a(int[] nArray, byte[] byArray, int n2) {
        return (nArray[n2] & 0xFFFFF) == this.b && (byArray[n2] & 0xF) == this.a;
    }
}

