/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntSet;

public final class NamespaceTest
extends NodeTest
implements QNameTest {
    private NamePool a;
    private int b;
    private UType c;
    private String d;

    public NamespaceTest(NamePool namePool, int n2, String string) {
        this.a = namePool;
        this.b = n2;
        this.d = string;
        this.c = UType.fromTypeCode(n2);
    }

    public final int getNodeKind() {
        return this.b;
    }

    @Override
    public final UType getUType() {
        return this.c;
    }

    @Override
    public final Optional<IntSet> getRequiredNodeNames() {
        return Optional.empty();
    }

    @Override
    public final boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return nodeName != null && nodeName.hasURI(this.d);
    }

    @Override
    public final IntPredicate getMatcher(NodeVectorTree object) {
        byte[] byArray = object.getNodeKindArray();
        object = object.getNameCodeArray();
        return arg_0 -> this.a((int[])object, byArray, arg_0);
    }

    @Override
    public final boolean matchesNode(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.b && nodeInfo.getURI().equals(this.d);
    }

    @Override
    public final boolean matches(StructuredQName structuredQName) {
        return structuredQName.hasURI(this.d);
    }

    @Override
    public final double getDefaultPriority() {
        return -0.25;
    }

    @Override
    public final int getPrimitiveType() {
        return this.b;
    }

    public final String getNamespaceURI() {
        return this.d;
    }

    @Override
    public final String toString() {
        switch (this.b) {
            case 1: {
                return "Q{" + this.d + "}*";
            }
            case 2: {
                return "@Q{" + this.d + "}*";
            }
        }
        return "(*" + this.b + "*)Q{" + this.d + "}*";
    }

    public final int hashCode() {
        return this.d.hashCode() << 5 + this.b;
    }

    public final boolean equals(Object object) {
        return object instanceof NamespaceTest && ((NamespaceTest)object).a == this.a && ((NamespaceTest)object).b == this.b && ((NamespaceTest)object).d.equals(this.d);
    }

    @Override
    public final String generateJavaScriptNameTest(int n2) {
        return "q.uri==='" + ExpressionPresenter.jsEscape(this.d) + "'";
    }

    @Override
    public final String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        if (n2 == 1) {
            return "var q=SaxonJS.U.nameOfNode(item); return SaxonJS.U.isNode(item) && item.nodeType===" + this.b + "&&" + this.generateJavaScriptNameTest(n2);
        }
        return "return SaxonJS.U.isNode(item) && item.nodeType===" + this.b + " && SaxonJS.U.hasURI(item, '" + ExpressionPresenter.jsEscape(this.d) + "');";
    }

    @Override
    public final Optional<String> explainMismatch(Item object, TypeHierarchy typeHierarchy) {
        if (((Optional)(object = super.explainMismatch((Item)object, typeHierarchy))).isPresent()) {
            return object;
        }
        return Optional.of("The node is in the wrong namespace");
    }

    private /* synthetic */ boolean a(int[] nArray, byte[] byArray, int n2) {
        int n3 = nArray[n2] & 0xFFFFF;
        return n3 != -1 && (byArray[n2] & 0xF) == this.b && this.d.equals(this.a.getURI(n3));
    }
}

