/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public class NodeKindTest
extends NodeTest {
    public static final NodeKindTest DOCUMENT = new NodeKindTest(9);
    public static final NodeKindTest ELEMENT = new NodeKindTest(1);
    public static final NodeKindTest ATTRIBUTE = new NodeKindTest(2);
    public static final NodeKindTest TEXT = new NodeKindTest(3);
    public static final NodeKindTest COMMENT = new NodeKindTest(8);
    public static final NodeKindTest PROCESSING_INSTRUCTION = new NodeKindTest(7);
    public static final NodeKindTest NAMESPACE = new NodeKindTest(13);
    private int a;
    private UType b;

    private NodeKindTest(int n2) {
        this.a = n2;
        this.b = UType.fromTypeCode(n2);
    }

    public int getNodeKind() {
        return this.a;
    }

    @Override
    public UType getUType() {
        return this.b;
    }

    public static NodeTest makeNodeKindTest(int n2) {
        switch (n2) {
            case 9: {
                return DOCUMENT;
            }
            case 1: {
                return ELEMENT;
            }
            case 2: {
                return ATTRIBUTE;
            }
            case 8: {
                return COMMENT;
            }
            case 3: {
                return TEXT;
            }
            case 7: {
                return PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NAMESPACE;
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown node kind " + n2 + " in NodeKindTest");
    }

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        return item instanceof NodeInfo && this.a == ((NodeInfo)item).getNodeKind();
    }

    @Override
    public boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        return this.a == n2;
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree object) {
        object = object.getNodeKindArray();
        if (this.a == 3) {
            return arg_0 -> NodeKindTest.b((byte[])object, arg_0);
        }
        return arg_0 -> this.a((byte[])object, arg_0);
    }

    @Override
    public boolean matchesNode(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.a;
    }

    @Override
    public final double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public int getPrimitiveType() {
        return this.a;
    }

    @Override
    public SchemaType getContentType() {
        switch (this.a) {
            case 9: {
                return AnyType.getInstance();
            }
            case 1: {
                return AnyType.getInstance();
            }
            case 2: {
                return AnySimpleType.getInstance();
            }
            case 8: {
                return BuiltInAtomicType.STRING;
            }
            case 3: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 7: {
                return BuiltInAtomicType.STRING;
            }
            case 13: {
                return BuiltInAtomicType.STRING;
            }
        }
        throw new AssertionError((Object)"Unknown node kind");
    }

    @Override
    public AtomicType getAtomizedItemType() {
        switch (this.a) {
            case 9: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 1: {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
            case 2: {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
            case 8: {
                return BuiltInAtomicType.STRING;
            }
            case 3: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 7: {
                return BuiltInAtomicType.STRING;
            }
            case 13: {
                return BuiltInAtomicType.STRING;
            }
        }
        throw new AssertionError((Object)"Unknown node kind");
    }

    @Override
    public String toString() {
        return NodeKindTest.toString(this.a);
    }

    public static String toString(int n2) {
        switch (n2) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "element()";
            }
            case 2: {
                return "attribute()";
            }
            case 8: {
                return "comment()";
            }
            case 3: {
                return "text()";
            }
            case 7: {
                return "processing-instruction()";
            }
            case 13: {
                return "namespace-node()";
            }
        }
        return "** error **";
    }

    public static String nodeKindName(int n2) {
        switch (n2) {
            case 9: {
                return "document";
            }
            case 1: {
                return "element";
            }
            case 2: {
                return "attribute";
            }
            case 8: {
                return "comment";
            }
            case 3: {
                return "text";
            }
            case 7: {
                return "processing-instruction";
            }
            case 13: {
                return "namespace";
            }
        }
        return "** error **";
    }

    public int hashCode() {
        return this.a;
    }

    public boolean equals(Object object) {
        return object instanceof NodeKindTest && ((NodeKindTest)object).a == this.a;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType object, int n2) {
        object = object instanceof NodeTest ? " " : " SaxonJS.U.isNode(item) && ";
        switch (this.getNodeKind()) {
            case 9: {
                return "return" + (String)object + "(item.nodeType===9||item.nodeType===11);";
            }
            case 1: {
                return "return" + (String)object + "item.nodeType===1;";
            }
            case 3: {
                return "return" + (String)object + "item.nodeType===3;";
            }
            case 8: {
                return "return" + (String)object + "item.nodeType===8;";
            }
            case 7: {
                return "return" + (String)object + "item.nodeType===7&&item.target!=='xml';";
            }
            case 2: {
                return "return SaxonJS.U.isAttr(item)";
            }
            case 13: {
                return "return SaxonJS.U.isNamespaceNode(item)";
            }
        }
        return "return false;";
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy object2) {
        if (((Optional)(object2 = super.explainMismatch((Item)object, (TypeHierarchy)object2))).isPresent()) {
            return object2;
        }
        if (object instanceof NodeInfo) {
            object = UType.getUType((Item)object);
            if (!this.getUType().overlaps((UType)object)) {
                return Optional.of("The supplied value is " + ((UType)object).toStringWithIndefiniteArticle());
            }
            return Optional.empty();
        }
        return Optional.of("The supplied value is " + object.getGenre().getDescription());
    }

    @Override
    public String toShortString() {
        switch (this.getNodeKind()) {
            case 1: {
                return "*";
            }
            case 2: {
                return "@*";
            }
            case 9: {
                return "/";
            }
        }
        return this.toString();
    }

    private /* synthetic */ boolean a(byte[] byArray, int n2) {
        return (byArray[n2] & 0xF) == this.a;
    }

    private static /* synthetic */ boolean b(byte[] byArray, int n2) {
        byte by = byArray[n2];
        return by == 3 || by == 4;
    }
}

