/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingletonIntersectExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;

public class NodeSetPattern
extends Pattern {
    protected Operand selectionOp;
    protected ItemType itemType;

    public NodeSetPattern(Expression expression) {
        this.selectionOp = new Operand(this, expression, OperandRole.NAVIGATE);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.selectionOp;
    }

    public Expression getSelectionExpression() {
        return this.selectionOp.getChildExpression();
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.selectionOp.setChildExpression(this.getSelectionExpression().typeCheck(expressionVisitor, (ContextItemStaticInfo)object));
        object = new RoleDiagnostic(19, this.getSelectionExpression().toString(), 0);
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(false);
        try {
            object = typeChecker.staticTypeCheck(this.getSelectionExpression(), SequenceType.NODE_SEQUENCE, (RoleDiagnostic)object, expressionVisitor);
        }
        catch (XPathException xPathException) {
            expressionVisitor.issueWarning("Pattern will never match anything. " + xPathException.getMessage(), this.getLocation());
            object = Literal.makeEmptySequence();
        }
        this.selectionOp.setChildExpression((Expression)object);
        this.itemType = this.getSelectionExpression().getItemType();
        return this;
    }

    public void setItemType(ItemType itemType) {
        this.itemType = itemType;
    }

    @Override
    public int getDependencies() {
        return this.getSelectionExpression().getDependencies();
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int n2) {
        return ExpressionTool.allocateSlots(this.getSelectionExpression(), n2, slotManager);
    }

    @Override
    public SequenceIterator<? extends NodeInfo> selectNodes(TreeInfo object, XPathContext xPathContext) {
        xPathContext = xPathContext.newMinorContext();
        object = new ManualIterator<NodeInfo>(object.getRootNode());
        xPathContext.setCurrentIterator((FocusIterator<?>)object);
        return this.getSelectionExpression().iterate(xPathContext);
    }

    @Override
    public boolean matches(Item<?> item, XPathContext object) {
        if (item instanceof NodeInfo) {
            object = this.getSelectionExpression().iterate((XPathContext)object);
            return SingletonIntersectExpression.containsNode(object, (NodeInfo)item);
        }
        return false;
    }

    @Override
    public UType getUType() {
        return ((Expression)this).getItemType().getUType();
    }

    @Override
    public ItemType getItemType() {
        if (this.itemType == null) {
            this.itemType = this.getSelectionExpression().getItemType();
        }
        if (this.itemType instanceof NodeTest) {
            return this.itemType;
        }
        return AnyNodeTest.getInstance();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NodeSetPattern && ((NodeSetPattern)object).getSelectionExpression().isEqual(this.getSelectionExpression());
    }

    @Override
    public int computeHashCode() {
        return 0x73108728 ^ this.getSelectionExpression().hashCode();
    }

    @Override
    public Pattern copy(RebindingMap object) {
        object = new NodeSetPattern(this.getSelectionExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("p.nodeSet");
        if (this.itemType != null) {
            expressionPresenter.emitAttribute("type", this.itemType.toExportString());
        }
        this.getSelectionExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

