/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public abstract class NodeTest
implements ItemType.WithSequenceTypeCache {
    private SequenceType a;
    private SequenceType b;
    private SequenceType c;
    private SequenceType d;

    @Override
    public Genre getGenre() {
        return Genre.NODE;
    }

    public abstract double getDefaultPriority();

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        return item instanceof NodeInfo && this.matchesNode((NodeInfo)item);
    }

    @Override
    public ItemType getPrimitiveItemType() {
        int n2 = this.getPrimitiveType();
        if (n2 == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(n2);
    }

    @Override
    public int getPrimitiveType() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public StructuredQName getMatchingNodeName() {
        return null;
    }

    @Override
    public String getAlphaCode() {
        switch (this.getPrimitiveType()) {
            case 0: {
                return "N";
            }
            case 1: {
                return "NE";
            }
            case 2: {
                return "NA";
            }
            case 3: {
                return "NT";
            }
            case 8: {
                return "NC";
            }
            case 7: {
                return "NP";
            }
            case 9: {
                return "ND";
            }
            case 13: {
                return "NN";
            }
        }
        return "*";
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isPlainType() {
        return false;
    }

    @Override
    public AtomicType getAtomizedItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        return true;
    }

    public IntPredicate getMatcher(NodeVectorTree nodeVectorTree) {
        return n2 -> this.matchesNode(nodeVectorTree.getNode(n2));
    }

    public abstract boolean matches(int var1, NodeName var2, SchemaType var3);

    public boolean matchesNode(NodeInfo nodeInfo) {
        return this.matches(nodeInfo.getNodeKind(), NameOfNode.makeName(nodeInfo), nodeInfo.getSchemaType());
    }

    public SchemaType getContentType() {
        Object object = this.getUType().decompose();
        Iterator<PrimitiveUType> iterator = object.iterator();
        if (object.size() == 1 && iterator.hasNext()) {
            object = iterator.next();
            switch (1.a[((Enum)object).ordinal()]) {
                case 1: {
                    return AnyType.getInstance();
                }
                case 2: {
                    return AnyType.getInstance();
                }
                case 3: {
                    return AnySimpleType.getInstance();
                }
                case 4: {
                    return BuiltInAtomicType.STRING;
                }
                case 5: {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
                case 6: {
                    return BuiltInAtomicType.STRING;
                }
                case 7: {
                    return BuiltInAtomicType.STRING;
                }
            }
        }
        return AnyType.getInstance();
    }

    public Optional<IntSet> getRequiredNodeNames() {
        return Optional.of(IntUniversalSet.getInstance());
    }

    public boolean isNillable() {
        return true;
    }

    public NodeTest copy() {
        return this;
    }

    @Override
    public String generateJavaScriptItemTypeAcceptor(String string, int n2) {
        return "function test(item) {" + this.generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2) + "};if (test(val)) {return val;} else {throw SaxonJS.XError('Conversion failed', '" + string + "');}";
    }

    @Override
    public SequenceType one() {
        if (this.a == null) {
            this.a = new SequenceType(this, 16384);
        }
        return this.a;
    }

    @Override
    public SequenceType zeroOrOne() {
        if (this.c == null) {
            this.c = new SequenceType(this, 24576);
        }
        return this.c;
    }

    @Override
    public SequenceType oneOrMore() {
        if (this.b == null) {
            this.b = new SequenceType(this, 49152);
        }
        return this.b;
    }

    @Override
    public SequenceType zeroOrMore() {
        if (this.d == null) {
            this.d = new SequenceType(this, 57344);
        }
        return this.d;
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy typeHierarchy) {
        if (object instanceof NodeInfo) {
            object = UType.getUType((Item)object);
            if (!this.getUType().overlaps((UType)object)) {
                return Optional.of("The supplied value is " + ((UType)object).toStringWithIndefiniteArticle());
            }
            return Optional.empty();
        }
        return Optional.of("The supplied value is " + object.getGenre().getDescription());
    }

    public String toShortString() {
        return this.toString();
    }
}

