/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;

public class NodeTestPattern
extends Pattern {
    private NodeTest a;

    public NodeTestPattern(NodeTest nodeTest) {
        this.a = nodeTest;
        this.setPriority(nodeTest.getDefaultPriority());
    }

    @Override
    public boolean matches(Item<?> item, XPathContext xPathContext) {
        return item instanceof NodeInfo && this.a.matchesNode((NodeInfo)item);
    }

    @Override
    public NodeTest getItemType() {
        return this.a;
    }

    @Override
    public UType getUType() {
        return this.a.getUType();
    }

    @Override
    public int getFingerprint() {
        return this.a.getFingerprint();
    }

    @Override
    public String toString() {
        return this.a.toString();
    }

    @Override
    public String toShortString() {
        return this.a.toShortString();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NodeTestPattern && ((NodeTestPattern)object).a.equals(this.a);
    }

    @Override
    public int computeHashCode() {
        return 0x7AEFFEA8 ^ this.a.hashCode();
    }

    @Override
    public Pattern convertToTypedPattern(String object) {
        if (this.a instanceof NameTest && this.a.getUType() == UType.ELEMENT) {
            SchemaDeclaration schemaDeclaration = this.getConfiguration().getElementDeclaration(this.a.getMatchingNodeName());
            if (schemaDeclaration == null) {
                if ("lax".equals(object)) {
                    return this;
                }
                throw new XPathException("The mode specifies typed='strict', but there is no schema element declaration named " + this.a, "XTSE3105");
            }
            object = schemaDeclaration.makeSchemaNodeTest();
            return new NodeTestPattern((NodeTest)object);
        }
        return this;
    }

    @Override
    public void export(ExpressionPresenter object) {
        ((ExpressionPresenter)object).startElement("p.nodeTest");
        ((ExpressionPresenter)object).emitAttribute("test", this.a.toString());
        ExpressionPresenter.ExportOptions exportOptions = (ExpressionPresenter.ExportOptions)((ExpressionPresenter)object).getOptions();
        if ("JS".equals(exportOptions.target)) {
            int n2 = exportOptions.targetVersion;
            try {
                ((ExpressionPresenter)object).emitAttribute("jsTest", this.a.generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2));
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw object;
            }
        }
        if (exportOptions.addStaticType) {
            SequenceType sequenceType = SequenceType.makeSequenceType(this.a, 16384);
            ((ExpressionPresenter)object).emitAttribute("sType", sequenceType.toExportString2());
        }
        ((ExpressionPresenter)object).endElement();
    }

    @Override
    public Pattern copy(RebindingMap object) {
        object = new NodeTestPattern(this.a.copy());
        ((Pattern)object).setPriority(this.getDefaultPriority());
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    public NodeTest getNodeTest() {
        return this.a;
    }
}

