/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PseudoExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Current;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ConcatenatingAxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public abstract class Pattern
extends PseudoExpression {
    private double a = 0.5;
    private boolean b = true;

    public static Pattern make(String object, StaticContext staticContext, PackageData packageData) {
        int n2 = staticContext.getConfiguration().getConfigurationProperty(Feature.XPATH_VERSION_FOR_XSLT);
        if (n2 == 30) {
            n2 = 305;
        }
        if (staticContext instanceof ExpressionContext) {
            ((NodeImpl)((ExpressionContext)staticContext).getStyleElement()).getLineNumber();
        }
        PatternParser patternParser = (PatternParser)((Object)staticContext.getConfiguration().newExpressionParser("PATTERN", false, n2));
        ((XPathParser)((Object)patternParser)).setLanguage(1, 30);
        object = patternParser.parsePattern((String)object, staticContext);
        ((Expression)object).setRetainedStaticContext(staticContext.makeRetainedStaticContext());
        object = ((Pattern)object).simplify();
        return object;
    }

    protected static void replaceCurrent(Expression object, LocalBinding localBinding) {
        for (Operand operand : ((Expression)object).operands()) {
            Expression expression = operand.getChildExpression();
            if (expression.isCallOn(Current.class)) {
                expression = new LocalVariableReference(localBinding);
                operand.setChildExpression(expression);
                continue;
            }
            Pattern.replaceCurrent(expression, localBinding);
        }
    }

    public static boolean patternContainsVariable(Pattern pattern) {
        return pattern != null && (((Expression)pattern).getDependencies() & 0x80) != 0;
    }

    @Override
    public boolean isLiftable(boolean bl2) {
        return false;
    }

    public void bindCurrent(LocalBinding localBinding) {
    }

    public boolean matchesCurrentGroup() {
        return false;
    }

    public void setOriginalText(String string) {
    }

    public boolean isRecoverable() {
        return this.b;
    }

    public void setRecoverable(boolean bl2) {
        this.b = bl2;
    }

    protected void handleDynamicError(XPathException xPathException, XPathContext xPathContext) {
        if ("XTDE0640".equals(xPathException.getErrorCodeLocalPart())) {
            throw xPathException;
        }
        if (!this.isRecoverable()) {
            throw xPathException;
        }
        XPathException xPathException2 = new XPathException("An error occurred matching pattern {" + this + "}: ", xPathException);
        xPathException2.setXPathContext(xPathContext);
        xPathException2.setErrorCodeQName(xPathException.getErrorCodeQName());
        xPathException2.setLocation(this.getLocation());
        xPathContext.getController().recoverableError(xPathException2);
    }

    @Override
    public Pattern simplify() {
        return this;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    @Override
    public int getDependencies() {
        return 0;
    }

    public int allocateSlots(SlotManager slotManager, int n2) {
        return n2;
    }

    public boolean isMotionless() {
        return true;
    }

    @Override
    public final boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.matches(xPathContext.getContextItem(), xPathContext);
    }

    public abstract boolean matches(Item<?> var1, XPathContext var2);

    public boolean matchesBeneathAnchor(NodeInfo nodeInfo, NodeInfo nodeInfo2, XPathContext xPathContext) {
        return this.matches(nodeInfo, xPathContext);
    }

    public SequenceIterator<? extends NodeInfo> selectNodes(TreeInfo mappingIterator, XPathContext object) {
        mappingIterator = mappingIterator.getRootNode();
        Object object2 = this.getUType();
        if (UType.DOCUMENT.subsumes((UType)object2)) {
            if (this.matches((Item<?>)((Object)mappingIterator), (XPathContext)object)) {
                return SingletonIterator.makeIterator(mappingIterator);
            }
            return new EmptyIterator.OfNodes();
        }
        if (UType.ATTRIBUTE.subsumes((UType)object2)) {
            AxisIterator axisIterator = mappingIterator.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            mappingIterator = nodeInfo -> nodeInfo.iterateAxis((byte)2);
            object2 = new MappingIterator(axisIterator, mappingIterator);
            return new ItemMappingIterator<NodeInfo, NodeInfo>((SequenceIterator<NodeInfo>)object2, arg_0 -> this.d((XPathContext)object, arg_0));
        }
        if (UType.NAMESPACE.subsumes((UType)object2)) {
            AxisIterator axisIterator = mappingIterator.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            mappingIterator = nodeInfo -> nodeInfo.iterateAxis((byte)8);
            object2 = new MappingIterator(axisIterator, mappingIterator);
            return new ItemMappingIterator<NodeInfo, NodeInfo>((SequenceIterator<NodeInfo>)object2, arg_0 -> this.c((XPathContext)object, arg_0));
        }
        if (UType.CHILD_NODE_KINDS.subsumes((UType)object2)) {
            NodeTest nodeTest = ((UType)object2).equals(UType.ELEMENT) ? NodeKindTest.ELEMENT : new MultipleNodeKindTest((UType)object2);
            mappingIterator = mappingIterator.iterateAxis((byte)4, nodeTest);
            return new ItemMappingIterator<NodeInfo, NodeInfo>(mappingIterator, arg_0 -> this.b((XPathContext)object, arg_0));
        }
        byte by = ((UType)object2).subsumes(UType.DOCUMENT) ? (byte)5 : 4;
        mappingIterator = mappingIterator.iterateAxis(by);
        object2 = nodeInfo -> {
            AxisIterator axisIterator = SingleNodeIterator.makeIterator(nodeInfo);
            if (object2.subsumes(UType.NAMESPACE)) {
                axisIterator = new ConcatenatingAxisIterator(axisIterator, nodeInfo.iterateAxis((byte)8));
            }
            if (object2.subsumes(UType.ATTRIBUTE)) {
                axisIterator = new ConcatenatingAxisIterator(axisIterator, nodeInfo.iterateAxis((byte)2));
            }
            return axisIterator;
        };
        mappingIterator = new MappingIterator(mappingIterator, object2);
        object = arg_0 -> this.a((XPathContext)object, arg_0);
        return new ItemMappingIterator(mappingIterator, object);
    }

    public abstract UType getUType();

    public int getFingerprint() {
        return -1;
    }

    @Override
    public abstract ItemType getItemType();

    public void setPriority(double d2) {
        this.a = d2;
    }

    public double getDefaultPriority() {
        return this.a;
    }

    @Override
    public String toString() {
        return "pattern matching " + ((Expression)this).getItemType();
    }

    public int getHostLanguage() {
        return 50;
    }

    public Pattern convertToTypedPattern(String string) {
        return null;
    }

    @Override
    public abstract void export(ExpressionPresenter var1);

    @Override
    public abstract Pattern copy(RebindingMap var1);

    @Override
    public Pattern optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this;
    }

    @Override
    public String toShortString() {
        return ((Expression)this).toString();
    }

    private /* synthetic */ NodeInfo a(XPathContext xPathContext, NodeInfo nodeInfo) {
        if (this.matches(nodeInfo, xPathContext)) {
            return nodeInfo;
        }
        return null;
    }

    private /* synthetic */ NodeInfo b(XPathContext xPathContext, NodeInfo nodeInfo) {
        if (this.matches(nodeInfo, xPathContext)) {
            return nodeInfo;
        }
        return null;
    }

    private /* synthetic */ NodeInfo c(XPathContext xPathContext, NodeInfo nodeInfo) {
        if (this.matches(nodeInfo, xPathContext)) {
            return nodeInfo;
        }
        return null;
    }

    private /* synthetic */ NodeInfo d(XPathContext xPathContext, NodeInfo nodeInfo) {
        if (this.matches(nodeInfo, xPathContext)) {
            return nodeInfo;
        }
        return null;
    }
}

