/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class SameNameTest
extends NodeTest
implements QNameTest {
    private NodeInfo a;

    public SameNameTest(NodeInfo nodeInfo) {
        this.a = nodeInfo;
    }

    public int getNodeKind() {
        return this.a.getNodeKind();
    }

    @Override
    public UType getUType() {
        return UType.fromTypeCode(this.a.getNodeKind());
    }

    @Override
    public boolean matches(int n2, NodeName nodeName, SchemaType schemaType) {
        if (n2 != this.a.getNodeKind()) {
            return false;
        }
        if (nodeName.hasFingerprint() && this.a.hasFingerprint()) {
            return nodeName.getFingerprint() == this.a.getFingerprint();
        }
        return nodeName.hasURI(this.a.getURI()) && nodeName.getLocalPart().equals(this.a.getLocalPart());
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree nodeVectorTree) {
        byte[] byArray = nodeVectorTree.getNodeKindArray();
        int[] nArray = nodeVectorTree.getNameCodeArray();
        return n2 -> {
            int n3 = byArray[n2] & 0xF;
            if (n3 == 4) {
                n3 = 3;
            }
            if (n3 != this.a.getNodeKind()) {
                return false;
            }
            if (this.a.hasFingerprint()) {
                return (nArray[n2] & 0xFFFFF) == this.a.getFingerprint();
            }
            return Navigator.haveSameName(nodeVectorTree.getNode(n2), this.a);
        };
    }

    @Override
    public boolean matchesNode(NodeInfo nodeInfo) {
        return nodeInfo == this.a || nodeInfo.getNodeKind() == this.a.getNodeKind() && Navigator.haveSameName(nodeInfo, this.a);
    }

    @Override
    public boolean matches(StructuredQName structuredQName) {
        return NameOfNode.makeName(this.a).getStructuredQName().equals(structuredQName);
    }

    @Override
    public final double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public int getFingerprint() {
        if (this.a.hasFingerprint()) {
            return this.a.getFingerprint();
        }
        NamePool namePool = this.a.getConfiguration().getNamePool();
        return namePool.allocateFingerprint(this.a.getURI(), this.a.getLocalPart());
    }

    @Override
    public int getPrimitiveType() {
        return this.a.getNodeKind();
    }

    @Override
    public Optional<IntSet> getRequiredNodeNames() {
        return Optional.of(new IntSingletonSet(((NodeTest)this).getFingerprint()));
    }

    public String getNamespaceURI() {
        return this.a.getURI();
    }

    public String getLocalPart() {
        return this.a.getLocalPart();
    }

    @Override
    public String toString() {
        switch (this.a.getNodeKind()) {
            case 1: {
                return "element(" + NameOfNode.makeName(this.a).getStructuredQName().getEQName() + ")";
            }
            case 2: {
                return "attribute(" + NameOfNode.makeName(this.a).getStructuredQName().getEQName() + ")";
            }
            case 7: {
                return "processing-instruction(" + this.a.getLocalPart() + ')';
            }
            case 13: {
                return "namespace-node(" + this.a.getLocalPart() + ')';
            }
            case 8: {
                return "comment()";
            }
            case 9: {
                return "document-node()";
            }
            case 3: {
                return "text()";
            }
        }
        return "***";
    }

    public int hashCode() {
        return this.a.getNodeKind() << 20 ^ this.a.getURI().hashCode() ^ this.a.getLocalPart().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SameNameTest && ((NodeTest)this).matchesNode(((SameNameTest)object).a);
    }

    public NameTest getEquivalentNameTest() {
        return new NameTest(this.a.getNodeKind(), this.a.getURI(), this.a.getLocalPart(), this.a.getConfiguration().getNamePool());
    }

    @Override
    public String generateJavaScriptNameTest(int n2) {
        return "false";
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        throw new XPathException("Cannot generate JS code for a SameNameTest", "SXJS0001");
    }
}

