/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.VennPattern;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UType;

public class UnionPattern
extends VennPattern {
    public UnionPattern(Pattern pattern, Pattern pattern2) {
        super(pattern, pattern2);
        this.setPriority(Double.NaN);
    }

    @Override
    public ItemType getItemType() {
        ItemType itemType = ((Expression)this.p1).getItemType();
        ItemType itemType2 = ((Expression)this.p2).getItemType();
        return Type.getCommonSuperType(itemType, itemType2);
    }

    @Override
    public UType getUType() {
        return this.p1.getUType().union(this.p2.getUType());
    }

    @Override
    public boolean matches(Item<?> item, XPathContext xPathContext) {
        return this.p1.matches(item, xPathContext) || this.p2.matches(item, xPathContext);
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo nodeInfo, NodeInfo nodeInfo2, XPathContext xPathContext) {
        return this.p1.matchesBeneathAnchor(nodeInfo, nodeInfo2, xPathContext) || this.p2.matchesBeneathAnchor(nodeInfo, nodeInfo2, xPathContext);
    }

    @Override
    public Pattern convertToTypedPattern(String object) {
        Pattern pattern = this.p1.convertToTypedPattern((String)object);
        object = this.p2.convertToTypedPattern((String)object);
        if (this.p1 == pattern && this.p2 == object) {
            return this;
        }
        return new UnionPattern(pattern, (Pattern)object);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof UnionPattern) {
            HashSet<Pattern> hashSet = new HashSet<Pattern>(10);
            this.gatherComponentPatterns(hashSet);
            HashSet<Pattern> hashSet2 = new HashSet<Pattern>(10);
            ((UnionPattern)object).gatherComponentPatterns(hashSet2);
            return hashSet.equals(hashSet2);
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return 0x9BD723A6 ^ this.p1.hashCode() ^ this.p2.hashCode();
    }

    @Override
    protected String getOperatorName() {
        return "union";
    }

    @Override
    public Pattern copy(RebindingMap object) {
        object = new UnionPattern(this.p1.copy((RebindingMap)object), this.p2.copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }
}

