/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public abstract class VennPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;

    public VennPattern(Pattern pattern, Pattern pattern2) {
        this.p1 = pattern;
        this.p2 = pattern2;
        this.adoptChildExpression(pattern);
        this.adoptChildExpression(pattern2);
    }

    @Override
    public Iterable<Operand> operands() {
        Operand[] operandArray = new Operand[2];
        VennPattern vennPattern = this;
        operandArray[0] = new Operand(vennPattern, vennPattern.p1, OperandRole.SAME_FOCUS_ACTION);
        VennPattern vennPattern2 = this;
        operandArray[1] = new Operand(vennPattern2, vennPattern2.p2, OperandRole.SAME_FOCUS_ACTION);
        return this.operandList(operandArray);
    }

    @Override
    public Pattern simplify() {
        this.p1 = this.p1.simplify();
        this.p2 = this.p2.simplify();
        return this;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        VennPattern.a(this.p1);
        this.p1 = this.p1.typeCheck(expressionVisitor, contextItemStaticInfo);
        VennPattern.a(this.p2);
        this.p2 = this.p2.typeCheck(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    private static void a(Pattern object) {
        if (object instanceof NodeTestPattern && !((object = ((Expression)object).getItemType()) instanceof NodeTest)) {
            object = new XPathException("The operands of a union, intersect, or except pattern must be patterns that match nodes", "XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
    }

    @Override
    public void bindCurrent(LocalBinding localBinding) {
        this.p1.bindCurrent(localBinding);
        this.p2.bindCurrent(localBinding);
    }

    @Override
    public boolean isMotionless() {
        return this.p1.isMotionless() && this.p2.isMotionless();
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int n2) {
        n2 = this.p1.allocateSlots(slotManager, n2);
        n2 = this.p2.allocateSlots(slotManager, n2);
        return n2;
    }

    public void gatherComponentPatterns(Set<Pattern> set) {
        if (this.p1 instanceof VennPattern) {
            ((VennPattern)this.p1).gatherComponentPatterns(set);
        } else {
            set.add(this.p1);
        }
        if (this.p2 instanceof VennPattern) {
            ((VennPattern)this.p2).gatherComponentPatterns(set);
            return;
        }
        set.add(this.p2);
    }

    @Override
    public int getDependencies() {
        return ((Expression)this.p1).getDependencies() | ((Expression)this.p2).getDependencies();
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }

    @Override
    public boolean matchesCurrentGroup() {
        return this.p1.matchesCurrentGroup() || this.p2.matchesCurrentGroup();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof VennPattern) {
            HashSet<Pattern> hashSet = new HashSet<Pattern>(10);
            this.gatherComponentPatterns(hashSet);
            HashSet<Pattern> hashSet2 = new HashSet<Pattern>(10);
            ((VennPattern)object).gatherComponentPatterns(hashSet2);
            return hashSet.equals(hashSet2);
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return 0x9BD723A6 ^ this.p1.hashCode() ^ this.p2.hashCode();
    }

    protected abstract String getOperatorName();

    @Override
    public String toString() {
        return this.p1 + " " + this.getOperatorName() + " " + this.p2;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        Object object = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        expressionPresenter.startElement("p.venn");
        expressionPresenter.emitAttribute("op", this.getOperatorName());
        if (((ExpressionPresenter.ExportOptions)object).addStaticType) {
            object = SequenceType.makeSequenceType(((Expression)this).getItemType(), 16384);
            expressionPresenter.emitAttribute("sType", ((SequenceType)object).toExportString2());
        }
        ((Expression)this.p1).export(expressionPresenter);
        ((Expression)this.p2).export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

