/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Annotation;

public class AnnotationList
implements Iterable<Annotation> {
    private List<Annotation> a;
    public static AnnotationList EMPTY = new AnnotationList(Collections.emptyList());

    public AnnotationList(List<Annotation> list) {
        this.a = list;
    }

    public static AnnotationList singleton(Annotation annotation) {
        return new AnnotationList(Collections.singletonList(annotation));
    }

    public void check(Configuration configuration, String string) {
        Object object = this;
        HashMap object22 = new HashMap();
        for (Annotation annotation : ((AnnotationList)object).a) {
            String string2 = annotation.getAnnotationQName().getURI();
            if (object22.containsKey(string2)) {
                ((List)object22.get(string2)).add(annotation);
                continue;
            }
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            arrayList.add(annotation);
            object22.put(string2, arrayList);
        }
        object = object22;
        for (Map.Entry entry : object.entrySet()) {
            FunctionAnnotationHandler functionAnnotationHandler = configuration.getFunctionAnnotationHandler((String)entry.getKey());
            if (functionAnnotationHandler == null) continue;
            functionAnnotationHandler.check(new AnnotationList((List)entry.getValue()), string);
        }
    }

    public AnnotationList filterByNamespace(String string) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Annotation annotation : this.a) {
            if (!annotation.getAnnotationQName().hasURI(string)) continue;
            arrayList.add(annotation);
        }
        return new AnnotationList(arrayList);
    }

    @Override
    public Iterator<Annotation> iterator() {
        return this.a.iterator();
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public int size() {
        return this.a.size();
    }

    public Annotation get(int n2) {
        return this.a.get(n2);
    }

    public boolean includes(StructuredQName structuredQName) {
        for (Annotation annotation : this.a) {
            if (!annotation.getAnnotationQName().equals(structuredQName)) continue;
            return true;
        }
        return false;
    }

    public boolean includes(String string) {
        for (Annotation annotation : this.a) {
            if (!annotation.getAnnotationQName().getLocalPart().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof AnnotationList && this.a.equals(((AnnotationList)object).a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

