/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;

public class DynamicQueryContext {
    private Item a;
    private GlobalParameterSet b = new GlobalParameterSet();
    private Configuration c;
    private URIResolver d;
    private ErrorListener e;
    private TraceListener f;
    private UnparsedTextURIResolver g;
    private DateTimeValue h;
    private Logger i;
    private int j = 0;
    private boolean k = true;

    public DynamicQueryContext(Configuration configuration) {
        this.c = configuration;
        this.d = configuration.getURIResolver();
        this.e = configuration.getErrorListener();
        if (this.e instanceof StandardErrorListener) {
            this.e = ((StandardErrorListener)this.e).makeAnother(51);
            ((StandardErrorListener)this.e).setRecoveryPolicy(2);
        }
        this.i = configuration.getLogger();
    }

    public int getSchemaValidationMode() {
        return this.j;
    }

    public void setSchemaValidationMode(int n2) {
        this.j = n2;
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean bl2) {
        this.k = bl2;
    }

    public boolean isApplyFunctionConversionRulesToExternalVariables() {
        return this.k;
    }

    public void setContextItem(Item item) {
        if (item == null) {
            throw new NullPointerException("Context item cannot be null");
        }
        if (item instanceof DocumentInfo) {
            item = ((DocumentInfo)item).getUnderlyingNode();
        }
        if (item instanceof NodeInfo && !((NodeInfo)item).getConfiguration().isCompatible(this.c)) {
            throw new IllegalArgumentException("Supplied node must be built using the same or a compatible Configuration");
        }
        this.a = item;
    }

    public Item getContextItem() {
        return this.a;
    }

    public void setParameter(StructuredQName structuredQName, GroundedValue<?> groundedValue) {
        if (this.b == null) {
            this.b = new GlobalParameterSet();
        }
        this.b.put(structuredQName, groundedValue);
    }

    public void clearParameters() {
        this.b = new GlobalParameterSet();
    }

    public GroundedValue<?> getParameter(StructuredQName structuredQName) {
        if (this.b == null) {
            return null;
        }
        return this.b.get(structuredQName);
    }

    public GlobalParameterSet getParameters() {
        if (this.b == null) {
            return new GlobalParameterSet();
        }
        return this.b;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.d = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.d;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.g = unparsedTextURIResolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.g;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.e = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.e;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.f = traceListener;
    }

    public TraceListener getTraceListener() {
        return this.f;
    }

    public void setTraceFunctionDestination(Logger logger) {
        this.i = logger;
    }

    public Logger getTraceFunctionDestination() {
        return this.i;
    }

    public DateTimeValue getCurrentDateTime() {
        return this.h;
    }

    public void setCurrentDateTime(DateTimeValue dateTimeValue) {
        this.h = dateTimeValue;
        if (((AtomicValue)dateTimeValue).getComponent(AccessorFn.Component.TIMEZONE) == null) {
            throw new XPathException("Supplied date/time must include a timezone");
        }
    }

    public Configuration getConfiguration() {
        return this.c;
    }

    public void initializeController(Controller controller) {
        controller.setURIResolver(this.getURIResolver());
        controller.setErrorListener(this.getErrorListener());
        controller.addTraceListener(this.getTraceListener());
        if (this.g != null) {
            controller.setUnparsedTextURIResolver(this.g);
        }
        controller.setTraceFunctionDestination(this.getTraceFunctionDestination());
        controller.setSchemaValidationMode(this.getSchemaValidationMode());
        DateTimeValue dateTimeValue = this.getCurrentDateTime();
        if (dateTimeValue != null) {
            try {
                controller.setCurrentDateTime(dateTimeValue);
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)xPathException);
            }
        }
        controller.setGlobalContextItem(this.a);
        controller.initializeController(this.b);
        controller.setApplyFunctionConversionRulesToExternalVariables(this.k);
    }
}

