/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.function.IntPredicate;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class QueryReader {
    private QueryReader() {
    }

    public static String readSourceQuery(StreamSource object, IntPredicate intPredicate) {
        if (((StreamSource)object).getInputStream() != null) {
            if (!((InputStream)(object = ((StreamSource)object).getInputStream())).markSupported()) {
                object = new BufferedInputStream((InputStream)object);
            }
            String string = QueryReader.readEncoding((InputStream)object);
            object = QueryReader.readInputStream((InputStream)object, string, intPredicate);
        } else if (((StreamSource)object).getReader() != null) {
            object = QueryReader.a(((StreamSource)object).getReader(), intPredicate);
        } else {
            throw new XPathException("Module URI Resolver must supply either an InputStream or a Reader");
        }
        return object.toString();
    }

    public static String readEncoding(InputStream object) {
        try {
            if (!((InputStream)object).markSupported()) {
                throw new IllegalArgumentException("InputStream must have markSupported() = true");
            }
            ((InputStream)object).mark(100);
            byte[] byArray = new byte[100];
            Object object2 = ((InputStream)object).read(byArray, 0, 100);
            if (object2 == -1) {
                throw new XPathException("Query source file is empty");
            }
            ((InputStream)object).reset();
            int n2 = object2;
            object = byArray;
            if (n2 >= 2) {
                Object object3 = object[0];
                object2 = object3;
                if ((object3 & 0xFF) == 254) {
                    Object object4 = object[1];
                    object2 = object4;
                    if ((object4 & 0xFF) == 255) {
                        return "UTF-16";
                    }
                }
                Object object5 = object[0];
                object2 = object5;
                if ((object5 & 0xFF) == 255) {
                    Object object6 = object[1];
                    object2 = object6;
                    if ((object6 & 0xFF) == 254) {
                        return "UTF-16LE";
                    }
                }
            }
            if (n2 >= 3) {
                Object object7 = object[0];
                object2 = object7;
                if ((object7 & 0xFF) == 239) {
                    Object object8 = object[1];
                    object2 = object8;
                    if ((object8 & 0xFF) == 187) {
                        Object object9 = object[2];
                        object2 = object9;
                        if ((object9 & 0xFF) == 191) {
                            return "UTF-8";
                        }
                    }
                }
            }
            if (n2 >= 8 && object[0] == false && object[2] == false && object[4] == false && object[6] == false) {
                return "UTF-16";
            }
            if (n2 >= 8 && object[1] == false && object[3] == false && object[5] == false && object[7] == false) {
                return "UTF-16LE";
            }
            String string = QueryReader.a((byte[])object, 0, n2);
            if (!Whitespace.trim(string).equals("xquery")) {
                return "UTF-8";
            }
            object2 = 0 + string.length();
            string = QueryReader.a((byte[])object, object2, n2);
            if (Whitespace.trim(string).equals("encoding")) {
                object2 += string.length();
            } else {
                if (Whitespace.trim(string).equals("version")) {
                    object2 += string.length();
                } else {
                    return "UTF-8";
                }
                string = QueryReader.a((byte[])object, object2, n2);
                object2 += string.length();
                string = QueryReader.a((byte[])object, object2, n2);
                if (Whitespace.trim(string).equals("encoding")) {
                    object2 += string.length();
                } else {
                    return "UTF-8";
                }
            }
            string = Whitespace.trim(QueryReader.a((byte[])object, object2, n2));
            if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
                return string.substring(1, string.length() - 1);
            }
            if (string.startsWith("'") && string.endsWith("'") && string.length() > 2) {
                return string.substring(1, string.length() - 1);
            }
            throw new XPathException("Unrecognized encoding " + Err.wrap(string) + " in query prolog");
        }
        catch (IOException iOException) {
            throw new XPathException("Failed to read query source file", iOException);
        }
    }

    public static String readInputStream(InputStream closeable, String string, IntPredicate intPredicate) {
        if (string == null) {
            if (!closeable.markSupported()) {
                closeable = new BufferedInputStream((InputStream)closeable);
            }
            string = QueryReader.readEncoding(closeable);
        }
        try {
            closeable = new BufferedReader(new InputStreamReader((InputStream)closeable, string));
            return QueryReader.a((Reader)closeable, intPredicate);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            XPathException xPathException = new XPathException("Unknown encoding " + Err.wrap(string), unsupportedEncodingException);
            xPathException.setErrorCode("XQST0087");
            throw xPathException;
        }
    }

    private static String a(Reader object, IntPredicate intPredicate) {
        try {
            object = UnparsedTextFunction.readFile(intPredicate, (Reader)object);
            return object.toString();
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.setErrorCode("XPST0003");
            ((XPathException)object).setIsStaticError(true);
            throw object;
        }
        catch (IOException iOException) {
            throw new XPathException("Failed to read supplied query file", iOException);
        }
    }

    private static String a(byte[] byArray, int n2, int n3) {
        byte by;
        int n4;
        for (n4 = n2; n4 < n3 && " \n\r\t".indexOf((by = byArray[n4]) & 0xFF) >= 0; ++n4) {
        }
        by = byArray[n4];
        if ((by & 0xFF) == 34) {
            ++n4;
            while (n4 < n3 && ((by = byArray[n4]) & 0xFF) != 34) {
                ++n4;
            }
        } else {
            by = byArray[n4];
            if ((by & 0xFF) == 39) {
                ++n4;
                while (n4 < n3 && ((by = byArray[n4]) & 0xFF) != 39) {
                    ++n4;
                }
            } else {
                while (n4 < n3 && " \n\r\t".indexOf((by = byArray[n4]) & 0xFF) < 0) {
                    ++n4;
                }
            }
        }
        if (n4 >= n3) {
            return new String(byArray, n2, n3 - n2);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n4 - n2 + 1);
        while (n2 <= n4) {
            by = byArray[n2];
            fastStringBuffer.append((char)(by & 0xFF));
            ++n2;
        }
        return fastStringBuffer.toString();
    }
}

