/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCopier;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class QueryResult {
    public static String RESULT_NS = "http://saxon.sf.net/xquery-results";

    private QueryResult() {
    }

    public static String serialize(NodeInfo nodeInfo) {
        StringWriter stringWriter = new StringWriter();
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("omit-xml-declaration", "yes");
        QueryResult.serialize(nodeInfo, (Result)new StreamResult(stringWriter), properties);
        return stringWriter.toString();
    }

    public static DocumentInfo wrap(SequenceIterator sequenceIterator, Configuration object) {
        Object object2 = ((Configuration)object).makePipelineConfiguration();
        object2 = new TinyBuilder((PipelineConfiguration)object2);
        ((TinyBuilder)object2).setStatistics(((Configuration)object).getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
        object = new NamespaceReducer((Receiver)object2);
        object = new ComplexContentOutputter((Receiver)object);
        QueryResult.sendWrappedSequence(sequenceIterator, (Receiver)object);
        return new DocumentInfo(((Builder)object2).getCurrentRoot());
    }

    public static void sendWrappedSequence(SequenceIterator sequenceIterator, Receiver receiver) {
        SerializerFactory serializerFactory = receiver.getPipelineConfiguration().getConfiguration().getSerializerFactory();
        SequenceCopier.copySequence(sequenceIterator, serializerFactory.newSequenceWrapper(receiver));
    }

    public static void serialize(NodeInfo nodeInfo, Result result, Properties properties) {
        Configuration configuration = nodeInfo.getConfiguration();
        QueryResult.serializeSequence(SingletonIterator.makeIterator(nodeInfo), configuration, result, properties);
    }

    public static void serialize(NodeInfo nodeInfo, Result result, SerializationProperties serializationProperties) {
        Configuration configuration = nodeInfo.getConfiguration();
        QueryResult.serializeSequence(SingletonIterator.makeIterator(nodeInfo), configuration, result, serializationProperties);
    }

    public static void serializeSequence(SequenceIterator<?> sequenceIterator, Configuration configuration, OutputStream outputStream, Properties properties) {
        QueryResult.serializeSequence(sequenceIterator, configuration, (Result)new StreamResult(outputStream), properties);
        try {
            outputStream.flush();
            return;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    public static void serializeSequence(SequenceIterator<?> sequenceIterator, Configuration configuration, Writer writer, Properties properties) {
        QueryResult.serializeSequence(sequenceIterator, configuration, (Result)new StreamResult(writer), properties);
        try {
            writer.flush();
            return;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    public static void serializeSequence(SequenceIterator<?> sequenceIterator, Configuration object, Result result, Properties properties) {
        object = ((Configuration)object).getSerializerFactory();
        object = ((SerializerFactory)object).getReceiver(result, new SerializationProperties(properties));
        object = new NamespaceReducer((Receiver)object);
        SequenceCopier.copySequence(sequenceIterator, (Receiver)object);
    }

    public static void serializeSequence(SequenceIterator<?> sequenceIterator, Configuration object, Result result, SerializationProperties serializationProperties) {
        object = ((Configuration)object).getSerializerFactory();
        object = ((SerializerFactory)object).getReceiver(result, serializationProperties);
        SequenceCopier.copySequence(sequenceIterator, (Receiver)object);
    }

    public static void rewriteToDisk(NodeInfo nodeInfo, Properties object, boolean bl2, PrintStream printStream) {
        Comparable<URI> comparable;
        Object object2;
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                break;
            }
            case 1: {
                object2 = nodeInfo.getParent();
                if (object2 == null || object2.getNodeKind() == 9) break;
                throw new XPathException("Cannot rewrite an element node unless it is top-level");
            }
            default: {
                throw new XPathException("Node to be rewritten must be a document or element node");
            }
        }
        object2 = nodeInfo.getSystemId();
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new XPathException("Cannot rewrite a document with no known URI");
        }
        try {
            comparable = new URI((String)object2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("SystemId of updated document is not a valid URI: " + (String)object2);
        }
        object2 = new File((URI)comparable);
        comparable = ((File)object2).getParentFile();
        if (bl2 && ((File)object2).exists()) {
            boolean bl3;
            File file = new File((File)comparable, ((File)object2).getName() + ".bak");
            if (printStream != null) {
                printStream.println("Creating backup file " + file);
            }
            if (!(bl3 = ((File)object2).renameTo(file))) {
                throw new XPathException("Failed to create backup file of " + file);
            }
        }
        if (!((File)object2).exists()) {
            if (printStream != null) {
                printStream.println("Creating file " + object2);
            }
            try {
                ((File)object2).createNewFile();
            }
            catch (IOException iOException) {
                throw new XPathException("Failed to create new file " + object2);
            }
        } else if (printStream != null) {
            printStream.println("Overwriting file " + object2);
        }
        Configuration configuration = nodeInfo.getConfiguration();
        SerializerFactory serializerFactory = configuration.getSerializerFactory();
        object = serializerFactory.getReceiver(new StreamResult((File)object2), new SerializationProperties((Properties)object));
        nodeInfo.copy((Receiver)object, 2, ExplicitLocation.UNKNOWN_LOCATION);
        object.close();
    }
}

