/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class StaticQueryContext {
    private Configuration a;
    private NamePool b;
    private String c;
    private HashMap<String, String> d;
    private Set<GlobalVariable> e;
    private boolean f = true;
    private boolean g = true;
    private int h = 3;
    private NamespaceResolver i = null;
    private String j = "http://www.w3.org/2005/xpath-functions";
    private String k = "";
    private ItemType l = AnyItemType.getInstance();
    private boolean m = false;
    private boolean n = true;
    private ModuleURIResolver o;
    private UnfailingErrorListener p;
    private CodeInjector q;
    private boolean r = false;
    private int s = 30;
    private String t;
    private Location u;
    private OptimizerOptions v;

    protected StaticQueryContext() {
    }

    public StaticQueryContext(Configuration configuration) {
        this(configuration, true);
    }

    public StaticQueryContext(Configuration configuration, boolean bl2) {
        this.a = configuration;
        this.b = configuration.getNamePool();
        if (bl2) {
            this.copyFrom(configuration.getDefaultStaticQueryContext());
            return;
        }
        this.d = new HashMap();
        this.e = new HashSet<GlobalVariable>();
        this.v = configuration.getOptimizerOptions();
        this.clearNamespaces();
    }

    public StaticQueryContext(StaticQueryContext staticQueryContext) {
        this.copyFrom(staticQueryContext);
    }

    public static StaticQueryContext makeDefaultStaticQueryContext(Configuration configuration) {
        StaticQueryContext staticQueryContext = new StaticQueryContext();
        new StaticQueryContext().a = configuration;
        staticQueryContext.b = configuration.getNamePool();
        staticQueryContext.reset();
        return staticQueryContext;
    }

    public void copyFrom(StaticQueryContext staticQueryContext) {
        this.a = staticQueryContext.a;
        this.b = staticQueryContext.b;
        this.c = staticQueryContext.c;
        this.o = staticQueryContext.o;
        if (staticQueryContext.d != null) {
            this.d = new HashMap<String, String>(staticQueryContext.d);
        }
        if (staticQueryContext.e != null) {
            this.e = new HashSet<GlobalVariable>(staticQueryContext.e);
        }
        this.f = staticQueryContext.f;
        this.g = staticQueryContext.g;
        this.h = staticQueryContext.h;
        this.i = staticQueryContext.i;
        this.k = staticQueryContext.k;
        this.j = staticQueryContext.j;
        this.l = staticQueryContext.l;
        this.m = staticQueryContext.m;
        this.n = staticQueryContext.n;
        this.o = staticQueryContext.o;
        this.p = staticQueryContext.p;
        this.q = staticQueryContext.q;
        this.r = staticQueryContext.r;
        this.v = staticQueryContext.v;
    }

    public void reset() {
        this.d = new HashMap(10);
        this.i = null;
        this.p = this.a.getErrorListener();
        if (this.p instanceof StandardErrorListener) {
            this.p = ((StandardErrorListener)this.p).makeAnother(51);
            ((StandardErrorListener)this.p).setRecoveryPolicy(2);
        }
        this.h = this.getConfiguration().isLicensedFeature(4) ? 3 : 4;
        this.m = false;
        this.n = true;
        this.l = AnyItemType.getInstance();
        this.j = "http://www.w3.org/2005/xpath-functions";
        this.k = "";
        this.o = null;
        this.t = this.a.getDefaultCollationName();
        this.clearNamespaces();
        this.r = false;
        this.v = this.a.getOptimizerOptions();
    }

    public void setConfiguration(Configuration configuration) {
        if (this.a != null && this.a != configuration) {
            throw new IllegalArgumentException("Configuration cannot be changed dynamically");
        }
        this.a = configuration;
        this.b = configuration.getNamePool();
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public Executable makeExecutable() {
        Executable executable = new Executable(this.a);
        executable.setSchemaAware(this.isSchemaAware());
        executable.setHostLanguage(51);
        return executable;
    }

    public void setSchemaAware(boolean bl2) {
        if (bl2) {
            throw new UnsupportedOperationException("Schema-awareness requires Saxon-EE");
        }
    }

    public boolean isSchemaAware() {
        return false;
    }

    public void setStreaming(boolean bl2) {
        if (bl2) {
            throw new UnsupportedOperationException("Streaming requires Saxon-EE");
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public void setBaseURI(String string) {
        this.c = string;
    }

    public TreeInfo buildDocument(Source source) {
        return this.a.buildDocumentTree(source);
    }

    public void setLanguageVersion(int n2) {
        if (n2 != 10 && n2 != 30 && n2 != 31) {
            throw new IllegalArgumentException("languageVersion = " + n2);
        }
    }

    public int getLanguageVersion() {
        return 31;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return null;
    }

    public boolean isCompileWithTracing() {
        return this.q instanceof TraceCodeInjector;
    }

    public void setCompileWithTracing(boolean bl2) {
        if (bl2) {
            this.q = new TraceCodeInjector();
            return;
        }
        this.q = null;
    }

    public void setCodeInjector(CodeInjector codeInjector) {
        this.q = codeInjector;
    }

    public CodeInjector getCodeInjector() {
        return this.q;
    }

    public boolean isUpdating() {
        return this.r;
    }

    public void setInheritNamespaces(boolean bl2) {
        this.f = bl2;
    }

    public boolean isInheritNamespaces() {
        return this.f;
    }

    public void setPreserveNamespaces(boolean bl2) {
        this.g = bl2;
    }

    public boolean isPreserveNamespaces() {
        return this.g;
    }

    public void setConstructionMode(int n2) {
        this.h = n2;
    }

    public int getConstructionMode() {
        return this.h;
    }

    public void setModuleLocation(Location location) {
        this.u = location;
    }

    public Location getModuleLocation() {
        return this.u;
    }

    public void setOptimizerOptions(OptimizerOptions optimizerOptions) {
        this.v = optimizerOptions;
    }

    public OptimizerOptions getOptimizerOptions() {
        return this.v;
    }

    public XQueryExpression compileQuery(String string) {
        XQueryParser xQueryParser = (XQueryParser)this.a.newExpressionParser("XQ", this.r, 31);
        if (this.q != null) {
            xQueryParser.setCodeInjector(this.q);
        } else if (this.a.isCompileWithTracing()) {
            xQueryParser.setCodeInjector(new TraceCodeInjector());
        }
        xQueryParser.setStreaming(this.isStreaming());
        QueryModule queryModule = new QueryModule(this);
        return xQueryParser.makeXQueryExpression(string, queryModule, this.a);
    }

    public synchronized XQueryExpression compileQuery(Reader reader) {
        int n2;
        char[] cArray = new char[4096];
        StringBuilder stringBuilder = new StringBuilder(4096);
        while ((n2 = reader.read(cArray)) > 0) {
            stringBuilder.append(cArray, 0, n2);
        }
        return this.compileQuery(stringBuilder.toString());
    }

    public synchronized XQueryExpression compileQuery(InputStream object, String string) {
        object = QueryReader.readInputStream((InputStream)object, string, this.a.getValidCharacterChecker());
        return this.compileQuery((String)object);
    }

    public void compileLibrary(String string) {
        throw new XPathException("Separate compilation of query libraries requires Saxon-EE");
    }

    public void compileLibrary(Reader reader) {
        throw new XPathException("Separate compilation of query libraries requires Saxon-EE");
    }

    public void compileLibrary(InputStream inputStream, String string) {
        throw new UnsupportedOperationException("Separate compilation of query libraries requires Saxon-EE");
    }

    public QueryLibrary getCompiledLibrary(String string) {
        return null;
    }

    public Collection<QueryLibrary> getCompiledLibraries() {
        return Collections.emptySet();
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if (string.equals("xml") != string2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalArgumentException("Misdeclaration of XML namespace");
        }
        if (string.equals("xmlns") || string2.equals("http://www.w3.org/2000/xmlns/")) {
            throw new IllegalArgumentException("Misdeclaration of xmlns namespace");
        }
        if (string.isEmpty()) {
            this.k = string2;
        }
        if (string2.isEmpty()) {
            this.d.remove(string);
            return;
        }
        this.d.put(string, string2);
    }

    public void clearNamespaces() {
        this.d.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
        this.declareNamespace("local", "http://www.w3.org/2005/xquery-local-functions");
        this.declareNamespace("err", "http://www.w3.org/2005/xqt-errors");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("", "");
    }

    protected HashMap<String, String> getUserDeclaredNamespaces() {
        return this.d;
    }

    public Iterator<String> iterateDeclaredPrefixes() {
        return this.d.keySet().iterator();
    }

    public String getNamespaceForPrefix(String string) {
        return this.d.get(string);
    }

    public void setExternalNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.i = namespaceResolver;
    }

    public NamespaceResolver getExternalNamespaceResolver() {
        return this.i;
    }

    public String getDefaultFunctionNamespace() {
        return this.j;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.j = string;
    }

    public void setDefaultElementNamespace(String string) {
        this.k = string;
        this.declareNamespace("", string);
    }

    public String getDefaultElementNamespace() {
        return this.k;
    }

    public void declareGlobalVariable(StructuredQName structuredQName, SequenceType sequenceType, Sequence<?> sequence, boolean bl2) {
        if (sequence == null && !bl2) {
            throw new NullPointerException("No initial value for declared variable");
        }
        if (sequence != null && !sequenceType.matches(sequence, this.getConfiguration().getTypeHierarchy())) {
            throw new XPathException("Value of declared variable does not match its type");
        }
        GlobalVariable globalVariable = bl2 ? new GlobalParam() : new GlobalVariable();
        globalVariable.setVariableQName(structuredQName);
        globalVariable.setRequiredType(sequenceType);
        if (sequence != null) {
            globalVariable.setSelectExpression(Literal.makeLiteral(sequence.materialize()));
        }
        if (this.e == null) {
            this.e = new HashSet<GlobalVariable>();
        }
        this.e.add(globalVariable);
    }

    public Iterator<GlobalVariable> iterateDeclaredGlobalVariables() {
        if (this.e == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.e.iterator();
    }

    public void clearDeclaredGlobalVariables() {
        this.e = null;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.o = moduleURIResolver;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.o;
    }

    public void declareCollation(String string, Comparator comparator) {
        this.getConfiguration().registerCollation(string, new SimpleCollation(string, comparator));
    }

    public void declareCollation(String string, StringCollator stringCollator) {
        this.getConfiguration().registerCollation(string, stringCollator);
    }

    public void declareDefaultCollation(String string) {
        StringCollator stringCollator;
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            stringCollator = this.getConfiguration().getCollation(string);
        }
        catch (XPathException xPathException) {
            stringCollator = null;
        }
        if (stringCollator == null) {
            throw new IllegalStateException("Unknown collation " + string);
        }
        this.t = string;
    }

    public StringCollator getCollation(String string) {
        try {
            return this.getConfiguration().getCollation(string);
        }
        catch (XPathException xPathException) {
            this.getErrorListener().warning(xPathException);
            return null;
        }
    }

    public String getDefaultCollationName() {
        return this.t;
    }

    public void setRequiredContextItemType(ItemType itemType) {
        this.l = itemType;
    }

    public ItemType getRequiredContextItemType() {
        return this.l;
    }

    public NamePool getNamePool() {
        return this.b;
    }

    public String getSystemId() {
        return this.c;
    }

    public String getBaseURI() {
        return this.c;
    }

    public void setPreserveBoundarySpace(boolean bl2) {
        this.m = bl2;
    }

    public boolean isPreserveBoundarySpace() {
        return this.m;
    }

    public void setEmptyLeast(boolean bl2) {
        this.n = bl2;
    }

    public boolean isEmptyLeast() {
        return this.n;
    }

    public void setErrorListener(ErrorListener errorListener) {
        if (errorListener instanceof StandardErrorListener) {
            this.p = ((StandardErrorListener)errorListener).makeAnother(51);
            ((StandardErrorListener)this.p).setRecoveryPolicy(2);
            return;
        }
        if (errorListener instanceof UnfailingErrorListener) {
            this.p = (UnfailingErrorListener)errorListener;
            return;
        }
        this.p = new DelegatingErrorListener(errorListener);
    }

    public UnfailingErrorListener getErrorListener() {
        if (this.p == null) {
            this.p = this.a.getErrorListener();
        }
        return this.p;
    }

    public void setUpdatingEnabled(boolean bl2) {
        this.r = bl2;
    }

    public boolean isUpdatingEnabled() {
        return this.r;
    }
}

