/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class UnboundFunctionLibrary
implements FunctionLibrary {
    private List<UserFunctionResolvable> a = new ArrayList<UserFunctionResolvable>(20);
    private List<StaticContext> b = new ArrayList<StaticContext>(20);
    private List<List<String>> c = new ArrayList<List<String>>();
    private boolean d = false;

    @Override
    public Expression bind(SymbolicName.F f2, Expression[] expressionArray, StaticContext staticContext, List<String> list) {
        if (this.d) {
            return null;
        }
        if (!list.isEmpty() && list.get(0).startsWith("Cannot call the private XQuery function")) {
            return null;
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFunctionName(f2.getComponentName());
        userFunctionCall.setArguments(expressionArray);
        this.a.add(userFunctionCall);
        this.b.add(staticContext);
        this.c.add(list);
        return userFunctionCall;
    }

    @Override
    public boolean isAvailable(SymbolicName.F f2) {
        return false;
    }

    public void bindUnboundFunctionReferences(XQueryFunctionBinder object, Configuration configuration) {
        this.d = true;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            int n2;
            Object object2;
            UserFunctionResolvable userFunctionResolvable = this.a.get(i2);
            if (userFunctionResolvable instanceof UserFunctionCall) {
                userFunctionResolvable = (UserFunctionCall)userFunctionResolvable;
                object2 = (QueryModule)this.b.get(i2);
                if (object2 == null) continue;
                this.b.set(i2, null);
                StructuredQName structuredQName = ((FunctionCall)((Object)userFunctionResolvable)).getFunctionName();
                int n3 = ((FunctionCall)((Object)userFunctionResolvable)).getArity();
                object2 = object.getDeclaration(structuredQName, n3);
                if (object2 != null) {
                    ((XQueryFunction)object2).registerReference(userFunctionResolvable);
                    ((UserFunctionCall)userFunctionResolvable).setStaticType(((XQueryFunction)object2).getResultType());
                    continue;
                }
                object = new StringBuilder("Cannot find a " + n3 + "-argument function named " + structuredQName.getEQName() + "()");
                List<String> list = this.c.get(i2);
                object2 = list.iterator();
                while (object2.hasNext()) {
                    String string = object2.next();
                    ((StringBuilder)object).append(". ").append(string);
                }
                if (list.isEmpty() && (object2 = XPathParser.getMissingFunctionExplanation(structuredQName, configuration)) != null) {
                    ((StringBuilder)object).append(". ").append((String)object2);
                }
                object2 = new XPathException(((StringBuilder)object).toString(), "XPST0017", ((Expression)((Object)userFunctionResolvable)).getLocation());
                ((XPathException)object2).setIsStaticError(true);
                throw object2;
            }
            if (!(userFunctionResolvable instanceof XQueryFunctionLibrary.UnresolvedCallable)) continue;
            object2 = ((XQueryFunctionLibrary.UnresolvedCallable)(userFunctionResolvable = (XQueryFunctionLibrary.UnresolvedCallable)userFunctionResolvable)).getFunctionName();
            XQueryFunction xQueryFunction = object.getDeclaration((StructuredQName)object2, n2 = ((XQueryFunctionLibrary.UnresolvedCallable)userFunctionResolvable).getArity());
            if (xQueryFunction != null) {
                xQueryFunction.registerReference(userFunctionResolvable);
                continue;
            }
            object2 = "Cannot find a " + n2 + "-argument function named " + ((StructuredQName)object2).getEQName() + "()";
            if (!configuration.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
                object2 = (String)object2 + ". Note: external function calls have been disabled";
            }
            object = new XPathException((String)object2);
            ((XPathException)object).setErrorCode("XPST0017");
            ((XPathException)object).setIsStaticError(true);
            throw object;
        }
    }

    @Override
    public FunctionLibrary copy() {
        UnboundFunctionLibrary unboundFunctionLibrary = new UnboundFunctionLibrary();
        new UnboundFunctionLibrary().a = new ArrayList<UserFunctionResolvable>(this.a);
        unboundFunctionLibrary.b = new ArrayList<StaticContext>(this.b);
        unboundFunctionLibrary.d = this.d;
        return unboundFunctionLibrary;
    }
}

