/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.LoopLifter;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class XQueryExpression
implements ExpressionOwner,
Location {
    protected Expression expression;
    protected SlotManager stackFrameMap;
    protected Executable executable;
    protected QueryModule mainModule;

    public XQueryExpression(Expression object, QueryModule queryModule, boolean bl2) {
        Object object2;
        Object object3 = queryModule.getExecutable();
        Configuration configuration = queryModule.getConfiguration();
        this.stackFrameMap = configuration.makeSlotManager();
        this.executable = object3;
        this.mainModule = queryModule;
        ((Expression)object).setRetainedStaticContext(queryModule.makeRetainedStaticContext());
        try {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.make(queryModule);
            Optimizer object4 = expressionVisitor.obtainOptimizer();
            expressionVisitor.setOptimizeForStreaming(bl2);
            object = ((Expression)object).simplify();
            ((Expression)object).checkForUpdatingSubexpressions();
            object2 = ((Executable)object3).getGlobalContextRequirement();
            object2 = object2 == null ? AnyItemType.getInstance() : ((GlobalContextRequirement)object2).getRequiredItemType();
            object2 = configuration.makeContextItemStaticInfo((ItemType)object2, true);
            object3 = ((Expression)object).typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
            if (object3 != object) {
                ((Expression)object3).setRetainedStaticContext(((Expression)object).getRetainedStaticContext());
                ((Expression)object3).setParentExpression(null);
                object = object3;
            }
            if (object4.isOptionSet(256) && (object3 = ((Expression)object).optimize(expressionVisitor, (ContextItemStaticInfo)object2)) != object) {
                ((Expression)object3).setRetainedStaticContext(((Expression)object).getRetainedStaticContext());
                ((Expression)object3).setParentExpression(null);
                object = object3;
            }
            if (object4.isOptionSet(1) && (object3 = LoopLifter.process((Expression)object, expressionVisitor, (ContextItemStaticInfo)object2)) != object) {
                ((Expression)object3).setRetainedStaticContext(((Expression)object).getRetainedStaticContext());
                ((Expression)object3).setParentExpression(null);
                object = object3;
            }
        }
        catch (XPathException xPathException) {
            queryModule.reportStaticError(xPathException);
            throw xPathException;
        }
        ExpressionTool.allocateSlots((Expression)object, 0, this.stackFrameMap);
        ExpressionTool.computeEvaluationModesForUserFunctionCalls((Expression)object);
        for (GlobalVariable globalVariable : this.getPackageData().getGlobalVariableList()) {
            object2 = globalVariable.getSelectExpression();
            if (object2 == null) continue;
            ExpressionTool.computeEvaluationModesForUserFunctionCalls((Expression)object2);
        }
        this.expression = object;
        this.executable.setConfiguration(configuration);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public PackageData getPackageData() {
        return this.mainModule.getPackageData();
    }

    public Configuration getConfiguration() {
        return this.mainModule.getConfiguration();
    }

    public boolean usesContextItem() {
        if (ExpressionTool.dependsOnFocus(this.expression)) {
            return true;
        }
        List<GlobalVariable> list = this.getPackageData().getGlobalVariableList();
        if (list != null) {
            for (GlobalVariable globalVariable : list) {
                Expression object = globalVariable.getSelectExpression();
                if (object == null || !ExpressionTool.dependsOnFocus(object)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUpdateQuery() {
        return false;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public void explainPathMap() {
    }

    public QueryModule getMainModule() {
        return this.mainModule;
    }

    public StructuredQName[] getExternalVariableNames() {
        List<StructuredQName> list = this.stackFrameMap.getVariableMap();
        StructuredQName[] structuredQNameArray = new StructuredQName[this.stackFrameMap.getNumberOfVariables()];
        for (int i2 = 0; i2 < structuredQNameArray.length; ++i2) {
            structuredQNameArray[i2] = list.get(i2);
        }
        return structuredQNameArray;
    }

    public List<Object> evaluate(DynamicQueryContext dynamicQueryContext) {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call evaluate() on an updating query");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        this.iterator(dynamicQueryContext).forEachOrFail(item -> arrayList.add(SequenceTool.convertToJava(item)));
        return arrayList;
    }

    public Object evaluateSingle(DynamicQueryContext object) {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call evaluateSingle() on an updating query");
        }
        object = this.iterator((DynamicQueryContext)object);
        if ((object = object.next()) == null) {
            return null;
        }
        return SequenceTool.convertToJava((Item)object);
    }

    public SequenceIterator<?> iterator(DynamicQueryContext sequenceIterator) {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call iterator() on an updating query");
        }
        if (!((DynamicQueryContext)((Object)sequenceIterator)).getConfiguration().isCompatible(this.getExecutable().getConfiguration())) {
            throw new XPathException("The query must be compiled and executed under the same Configuration", "SXXP0004");
        }
        Controller controller = this.newController((DynamicQueryContext)((Object)sequenceIterator));
        try {
            Item<?> item = controller.getGlobalContextItem();
            if (item instanceof NodeInfo && ((NodeInfo)item).getTreeInfo().isTyped() && !this.getExecutable().isSchemaAware()) {
                throw new XPathException("A typed input document can only be used with a schema-aware query");
            }
            sequenceIterator = this.initialContext((DynamicQueryContext)((Object)sequenceIterator), controller);
            if (controller.getTraceListener() != null) {
                controller.preEvaluateGlobals((XPathContext)((Object)sequenceIterator));
            }
            ((XPathContextMajor)((Object)sequenceIterator)).openStackFrame(this.stackFrameMap);
            sequenceIterator = this.expression.iterate((XPathContext)((Object)sequenceIterator));
            if ((sequenceIterator.getProperties() & 1) != 0) {
                return sequenceIterator;
            }
            return new a(this, sequenceIterator, controller.getErrorListener());
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            sequenceIterator = xPathException;
            while (((TransformerException)((Object)sequenceIterator)).getException() instanceof TransformerException) {
                sequenceIterator = (TransformerException)((TransformerException)((Object)sequenceIterator)).getException();
            }
            sequenceIterator = XPathException.makeXPathException((Exception)((Object)sequenceIterator));
            controller.reportFatalError((XPathException)((Object)sequenceIterator));
            throw sequenceIterator;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(DynamicQueryContext object, Result object2, Properties object3) {
        Object object4;
        Object object5;
        boolean bl2;
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call run() on an updating query");
        }
        if (!((DynamicQueryContext)object).getConfiguration().isCompatible(this.getExecutable().getConfiguration())) {
            throw new XPathException("The query must be compiled and executed under the same Configuration", "SXXP0004");
        }
        Object object6 = ((DynamicQueryContext)object).getContextItem();
        if (object6 instanceof NodeInfo && ((NodeInfo)object6).getTreeInfo().isTyped() && !this.getExecutable().isSchemaAware()) {
            throw new XPathException("A typed input document can only be used with a schema-aware query");
        }
        object6 = this.newController((DynamicQueryContext)object);
        if (object2 instanceof Receiver) {
            ((Receiver)object2).getPipelineConfiguration().setController((Controller)object6);
        }
        object3 = this.validateOutputProperties((Controller)object6, (Properties)object3);
        object = this.initialContext((DynamicQueryContext)object, (Controller)object6);
        TraceListener traceListener = ((Controller)object6).getTraceListener();
        if (traceListener != null) {
            ((Controller)object6).preEvaluateGlobals((XPathContext)object);
        }
        ((XPathContextMajor)object).openStackFrame(this.stackFrameMap);
        boolean bl3 = bl2 = object2 instanceof StreamResult && ((StreamResult)object2).getOutputStream() == null;
        if (object2 instanceof Receiver) {
            object3 = (Receiver)object2;
        } else {
            object5 = ((XPathContextMinor)object).getConfiguration().getSerializerFactory();
            object4 = ((Controller)object6).makePipelineConfiguration();
            ((PipelineConfiguration)object4).setHostLanguage(51);
            object3 = ((SerializerFactory)object5).getReceiver((Result)object2, new SerializationProperties((Properties)object3), (PipelineConfiguration)object4);
        }
        object5 = new NamespaceReducer((Receiver)object3);
        object3 = new ComplexContentOutputter((Receiver)object5);
        ((XPathContextMinor)object).setReceiver((Receiver)object3);
        object3.open();
        try {
            this.expression.process((XPathContext)object);
        }
        catch (XPathException xPathException) {
            try {
                ((Controller)object6).reportFatalError(xPathException);
                throw xPathException;
            }
            catch (Throwable throwable) {
                try {
                    if (traceListener != null) {
                        traceListener.close();
                    }
                    object3.close();
                    throw throwable;
                }
                catch (XPathException xPathException2) {
                    object2 = xPathException2;
                    xPathException2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            if (traceListener != null) {
                traceListener.close();
            }
            object3.close();
        }
        catch (XPathException xPathException) {
            object4 = xPathException;
            xPathException.printStackTrace();
        }
        if (!(object2 instanceof StreamResult)) return;
        this.closeStreamIfNecessary((StreamResult)object2, bl2);
    }

    protected void closeStreamIfNecessary(StreamResult object, boolean bl2) {
        if (bl2 && (object = ((StreamResult)object).getOutputStream()) != null) {
            try {
                ((OutputStream)object).close();
                return;
            }
            catch (IOException iOException) {
                throw new XPathException(iOException);
            }
        }
    }

    public void runStreamed(DynamicQueryContext dynamicQueryContext, Source source, Result result, Properties properties) {
        throw new XPathException("Streaming requires Saxon-EE");
    }

    protected Properties validateOutputProperties(Controller controller, Properties properties) {
        Properties properties2 = controller.getExecutable().getPrimarySerializationProperties().getProperties();
        SerializerFactory serializerFactory = controller.getConfiguration().getSerializerFactory();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                try {
                    string2 = serializerFactory.checkOutputProperty(string, string2);
                    properties2.setProperty(string, string2);
                }
                catch (XPathException xPathException) {
                    properties.remove(string);
                    controller.getErrorListener().warning(xPathException);
                }
            }
        }
        if (properties2.getProperty("method") == null) {
            properties2.setProperty("method", "xml");
        }
        return properties2;
    }

    public void pull(DynamicQueryContext dynamicQueryContext, Result result, Properties properties) {
        this.run(dynamicQueryContext, result, properties);
    }

    public void pull(DynamicQueryContext dynamicQueryContext, SequenceReceiver sequenceReceiver) {
        this.run(dynamicQueryContext, sequenceReceiver, this.getConfiguration().getDefaultSerializationProperties());
    }

    public Set<MutableNodeInfo> runUpdate(DynamicQueryContext dynamicQueryContext) {
        throw new XPathException("Calling runUpdate() on a non-updating query");
    }

    public void runUpdate(DynamicQueryContext dynamicQueryContext, UpdateAgent updateAgent) {
        throw new XPathException("Calling runUpdate() on a non-updating query");
    }

    protected XPathContextMajor initialContext(DynamicQueryContext object, Controller controller) {
        object = controller.getGlobalContextItem();
        XPathContextMajor xPathContextMajor = controller.newXPathContext();
        if (object != null) {
            ManualIterator<Object> manualIterator = new ManualIterator<Object>(object);
            xPathContextMajor.setCurrentIterator(manualIterator);
            controller.setGlobalContextItem((Item)object);
        }
        return xPathContextMajor;
    }

    public Controller newController(DynamicQueryContext dynamicQueryContext) {
        Controller controller = new Controller(this.executable.getConfiguration(), this.executable);
        dynamicQueryContext.initializeController(controller);
        return controller;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("query");
        this.mainModule.getKeyManager().exportKeys(expressionPresenter, null);
        this.getExecutable().explainGlobalVariables(expressionPresenter);
        this.mainModule.explainGlobalFunctions(expressionPresenter);
        expressionPresenter.startElement("body");
        this.expression.export(expressionPresenter);
        expressionPresenter.endElement();
        expressionPresenter.endElement();
        expressionPresenter.close();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setAllowDocumentProjection(boolean bl2) {
        if (bl2) {
            throw new UnsupportedOperationException("Document projection requires Saxon-EE");
        }
    }

    public boolean isDocumentProjectionAllowed() {
        return false;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.mainModule.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    public int getHostLanguage() {
        return 51;
    }

    @Override
    public void setChildExpression(Expression expression) {
        this.expression = expression;
    }

    private final class a<T extends Item<?>>
    implements SequenceIterator<T> {
        private SequenceIterator<T> a;
        private UnfailingErrorListener b;
        private /* synthetic */ XQueryExpression c;

        public a(XQueryExpression xQueryExpression, SequenceIterator<T> sequenceIterator, UnfailingErrorListener unfailingErrorListener) {
            this.c = xQueryExpression;
            this.a = sequenceIterator;
            this.b = unfailingErrorListener;
        }

        @Override
        public final T next() {
            try {
                return this.a.next();
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.maybeSetLocation(this.c.expression.getLocation());
                this.b.fatalError(xPathException2);
                xPathException2.setHasBeenReported(true);
                throw xPathException2;
            }
        }

        @Override
        public final void close() {
            this.a.close();
        }

        @Override
        public final int getProperties() {
            return 0;
        }
    }
}

