/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.LoopLifter;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.PairIterator;
import net.sf.saxon.value.SequenceType;

public class XQueryFunction
implements Declaration,
InstructionInfo {
    private StructuredQName a;
    private List<UserFunctionParameter> b;
    private SequenceType c;
    private Expression d = null;
    private List<UserFunctionResolvable> e = new ArrayList<UserFunctionResolvable>(10);
    private Location f;
    private UserFunction g = null;
    private boolean h;
    private NamespaceResolver i;
    private QueryModule j;
    private boolean k = false;
    private AnnotationList l = AnnotationList.EMPTY;

    public XQueryFunction() {
        this.b = new ArrayList<UserFunctionParameter>(8);
    }

    public PackageData getPackageData() {
        return this.j.getPackageData();
    }

    public void setFunctionName(StructuredQName structuredQName) {
        this.a = structuredQName;
    }

    public void addArgument(UserFunctionParameter userFunctionParameter) {
        this.b.add(userFunctionParameter);
    }

    public void setResultType(SequenceType sequenceType) {
        this.c = sequenceType;
    }

    public void setBody(Expression expression) {
        this.d = expression;
    }

    public Expression getBody() {
        return this.d;
    }

    public void setLocation(Location location) {
        this.f = location;
    }

    public StructuredQName getFunctionName() {
        return this.a;
    }

    public String getDisplayName() {
        return this.a.getDisplayName();
    }

    public SymbolicName getIdentificationKey() {
        return new SymbolicName.F(this.a, this.b.size());
    }

    public static SymbolicName getIdentificationKey(StructuredQName structuredQName, int n2) {
        return new SymbolicName.F(structuredQName, n2);
    }

    public SequenceType getResultType() {
        return this.c;
    }

    public void setStaticContext(QueryModule queryModule) {
        this.j = queryModule;
    }

    public StaticContext getStaticContext() {
        return this.j;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] sequenceTypeArray = new SequenceType[this.b.size()];
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            sequenceTypeArray[i2] = this.b.get(i2).getRequiredType();
        }
        return sequenceTypeArray;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        UserFunctionParameter[] userFunctionParameterArray = new UserFunctionParameter[this.b.size()];
        return this.b.toArray(userFunctionParameterArray);
    }

    public int getNumberOfArguments() {
        return this.b.size();
    }

    public void registerReference(UserFunctionResolvable userFunctionResolvable) {
        this.e.add(userFunctionResolvable);
    }

    public void setMemoFunction(boolean bl2) {
        this.h = bl2;
    }

    public boolean isMemoFunction() {
        return this.h;
    }

    public void setUpdating(boolean bl2) {
        this.k = bl2;
    }

    public boolean isUpdating() {
        return this.k;
    }

    public void setAnnotations(AnnotationList annotationList) {
        this.l = annotationList;
        if (this.g != null) {
            this.g.setAnnotations(annotationList);
        }
        if (annotationList.includes(Annotation.UPDATING)) {
            this.setUpdating(true);
        }
    }

    public AnnotationList getAnnotations() {
        return this.l;
    }

    public boolean hasAnnotation(StructuredQName structuredQName) {
        return this.l.includes(structuredQName);
    }

    public boolean isPrivate() {
        return this.hasAnnotation(Annotation.PRIVATE);
    }

    public void compile() {
        Configuration configuration = this.j.getConfiguration();
        try {
            if (this.g == null) {
                SlotManager slotManager = configuration.makeSlotManager();
                UserFunctionParameter[] userFunctionParameterArray = this.getParameterDefinitions();
                for (int i2 = 0; i2 < userFunctionParameterArray.length; ++i2) {
                    userFunctionParameterArray[i2].setSlotNumber(i2);
                    slotManager.allocateSlotNumber(userFunctionParameterArray[i2].getVariableQName());
                }
                RetainedStaticContext retainedStaticContext = null;
                try {
                    retainedStaticContext = this.getStaticContext().makeRetainedStaticContext();
                    this.d.setRetainedStaticContext(retainedStaticContext);
                    Object object = ExpressionVisitor.make(this.j);
                    this.d = this.d.simplify().typeCheck((ExpressionVisitor)object, ContextItemStaticInfo.ABSENT);
                    RoleDiagnostic roleDiagnostic = new RoleDiagnostic(5, this.a.getDisplayName(), 0);
                    this.d = configuration.getTypeChecker(false).staticTypeCheck(this.d, this.c, roleDiagnostic, (ExpressionVisitor)object);
                    if (this.j.getUserQueryContext().isCompileWithTracing()) {
                        this.i = this.j.getNamespaceResolver();
                        object = new TraceExpression(this.d);
                        ((TraceExpression)object).setConstructType(158);
                        ((TraceExpression)object).setObjectName(this.a);
                        ((TraceExpression)object).setNamespaceResolver(this.j.getNamespaceResolver());
                        ((Expression)object).setLocation(this.f);
                        this.d = object;
                    }
                }
                catch (XPathException xPathException) {
                    XPathException xPathException2 = xPathException;
                    xPathException.maybeSetLocation(this);
                    if (xPathException2.isReportableStatically()) {
                        throw xPathException2;
                    }
                    ErrorExpression errorExpression = new ErrorExpression(xPathException2);
                    ExpressionTool.copyLocationInfo(this.d, errorExpression);
                    this.d = errorExpression;
                }
                this.g = configuration.newUserFunction(this.h, FunctionStreamability.UNCLASSIFIED);
                this.g.setRetainedStaticContext(retainedStaticContext);
                this.g.setPackageData(this.j.getPackageData());
                this.g.setBody(this.d);
                this.g.setFunctionName(this.a);
                this.g.setParameterDefinitions(userFunctionParameterArray);
                this.g.setResultType(this.getResultType());
                this.g.setLineNumber(this.f.getLineNumber());
                this.g.setSystemId(this.f.getSystemId());
                this.g.setStackFrameMap(slotManager);
                this.g.setUpdating(this.k);
                this.g.setAnnotations(this.l);
            }
            this.fixupReferences();
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException3 = xPathException;
            xPathException.maybeSetLocation(this);
            throw xPathException3;
        }
    }

    public void optimize() {
        int n2;
        this.d.checkForUpdatingSubexpressions();
        if (this.k) {
            if (ExpressionTool.isNotAllowedInUpdatingContext(this.d)) {
                XPathException xPathException = new XPathException("The body of an updating function must be an updating expression", "XUST0002");
                xPathException.setLocator(this.d.getLocation());
                throw xPathException;
            }
        } else if (this.d.isUpdatingExpression()) {
            XPathException xPathException = new XPathException("The body of a non-updating function must be a non-updating expression", "XUST0001");
            xPathException.setLocator(this.d.getLocation());
            throw xPathException;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.make(this.j);
        Configuration configuration = this.j.getConfiguration();
        Optimizer optimizer = expressionVisitor.obtainOptimizer();
        int n3 = this.b.size();
        if (optimizer.isOptionSet(256)) {
            this.d = this.d.optimize(expressionVisitor, ContextItemStaticInfo.ABSENT);
        }
        this.d.setParentExpression(null);
        if (optimizer.isOptionSet(1)) {
            this.d = LoopLifter.process(this.d, expressionVisitor, ContextItemStaticInfo.ABSENT);
        }
        if (optimizer.isOptionSet(2)) {
            Object object = ((QueryModule)this.getStaticContext()).getExecutable();
            object = new GlobalVariableManager(this, (Executable)object){
                private /* synthetic */ Executable a;
                private /* synthetic */ XQueryFunction b;
                {
                    this.b = xQueryFunction;
                    this.a = executable;
                }

                @Override
                public final void addGlobalVariable(GlobalVariable globalVariable) {
                    PackageData packageData = this.b.j.getPackageData();
                    globalVariable.setPackageData(packageData);
                    SlotManager slotManager = packageData.getGlobalSlotManager();
                    int n2 = slotManager.allocateSlotNumber(globalVariable.getVariableQName());
                    globalVariable.compile(this.a, n2);
                    packageData.addGlobalVariable(globalVariable);
                }

                @Override
                public final GlobalVariable getEquivalentVariable(Expression expression) {
                    return null;
                }
            };
            if ((object = optimizer.promoteExpressionsToGlobal(this.d, (GlobalVariableManager)object, expressionVisitor)) != null) {
                this.d = this.d.optimize(expressionVisitor, ContextItemStaticInfo.ABSENT);
            }
        }
        if (optimizer.getOptimizerOptions().isSet(16384) && !this.k && (n2 = ExpressionTool.markTailFunctionCalls(this.d, this.a, n3)) != 0) {
            this.g.setBody(this.d);
            this.g.setTailRecursive(n2 > 0, n2 > 1);
            this.d = new TailCallLoop(this.g, this.d);
        }
        this.g.setBody(this.d);
        this.g.computeEvaluationMode();
        ExpressionTool.allocateSlots(this.d, n3, this.g.getStackFrameMap());
        if (configuration.isGenerateByteCode(51)) {
            if (configuration.getCountDown() == 0) {
                Object object = configuration.makeCompilerService(51);
                if ((object = optimizer.compileToByteCode((ICompilerService)object, this.d, this.getFunctionName().getDisplayName(), 6)) != null) {
                    this.d = object;
                }
            } else {
                optimizer.injectByteCodeCandidates(this.d);
                this.d = optimizer.makeByteCodeCandidate(this.g, this.d, this.getDisplayName(), 6);
            }
            this.g.setBody(this.d);
            this.g.computeEvaluationMode();
        }
    }

    public void fixupReferences() {
        for (UserFunctionResolvable userFunctionResolvable : this.e) {
            userFunctionResolvable.setFunction(this.g);
        }
    }

    public void checkReferences(ExpressionVisitor expressionVisitor) {
        for (UserFunctionResolvable userFunctionResolvable : this.e) {
            if (!(userFunctionResolvable instanceof UserFunctionCall)) continue;
            userFunctionResolvable = (UserFunctionCall)userFunctionResolvable;
            ((FunctionCall)((Object)userFunctionResolvable)).checkFunctionCall(this.g, expressionVisitor);
        }
        this.e = new ArrayList<UserFunctionResolvable>(0);
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("declareFunction");
        expressionPresenter.emitAttribute("name", this.a.getDisplayName());
        expressionPresenter.emitAttribute("arity", "" + this.getNumberOfArguments());
        if (this.g == null) {
            expressionPresenter.emitAttribute("unreferenced", "true");
        } else {
            if (this.g.isMemoFunction()) {
                expressionPresenter.emitAttribute("memo", "true");
            }
            expressionPresenter.emitAttribute("tailRecursive", this.g.isTailRecursive() ? "true" : "false");
            this.d.export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    public UserFunction getUserFunction() {
        return this.g;
    }

    @Override
    public int getConstructType() {
        return 158;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.a;
    }

    @Override
    public String getSystemId() {
        return this.f.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.f.getLineNumber();
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.i;
    }

    @Override
    public Object getProperty(String string) {
        if ("name".equals(string)) {
            return this.a.getDisplayName();
        }
        if ("as".equals(string)) {
            return this.c.toString();
        }
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        return new PairIterator<String>("name", "as");
    }

    public int getHostLanguage() {
        return 51;
    }
}

