/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class XQueryFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private Configuration a;
    private HashMap<SymbolicName, XQueryFunction> b = new HashMap(20);

    public XQueryFunctionLibrary(Configuration configuration) {
        this.a = configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.a = configuration;
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public void declareFunction(XQueryFunction xQueryFunction) {
        Object object = xQueryFunction.getIdentificationKey();
        XQueryFunction xQueryFunction2 = this.b.get(object);
        if (xQueryFunction2 == xQueryFunction) {
            return;
        }
        if (xQueryFunction2 != null) {
            object = new XPathException("Duplicate definition of function " + xQueryFunction.getDisplayName() + " (see line " + xQueryFunction2.getLineNumber() + " in " + xQueryFunction2.getSystemId() + ')');
            ((XPathException)object).setErrorCode("XQST0034");
            ((XPathException)object).setIsStaticError(true);
            ((TransformerException)object).setLocator(xQueryFunction);
            throw object;
        }
        this.b.put((SymbolicName)object, xQueryFunction);
    }

    @Override
    public boolean isAvailable(SymbolicName.F f2) {
        return this.b.get(f2) != null;
    }

    @Override
    public Expression bind(SymbolicName.F object, Expression[] object2, StaticContext staticContext, List<String> list) {
        XQueryFunction xQueryFunction = this.b.get(object);
        if (xQueryFunction != null) {
            if (xQueryFunction.isPrivate() && xQueryFunction.getStaticContext() != staticContext) {
                list.add("Cannot call the private XQuery function " + ((SymbolicName)object).getComponentName().getDisplayName() + " from outside its module");
                return null;
            }
            object = new UserFunctionCall();
            ((UserFunctionCall)object).setFunctionName(xQueryFunction.getFunctionName());
            ((FunctionCall)object).setArguments((Expression[])object2);
            ((UserFunctionCall)object).setStaticType(xQueryFunction.getResultType());
            object2 = xQueryFunction.getUserFunction();
            if (object2 == null) {
                xQueryFunction.registerReference((UserFunctionResolvable)object);
            } else {
                ((UserFunctionCall)object).setFunction((UserFunction)object2);
            }
            return object;
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName object, int n2) {
        object = XQueryFunction.getIdentificationKey((StructuredQName)object, n2);
        return this.b.get(object);
    }

    public XQueryFunction getDeclarationByKey(SymbolicName symbolicName) {
        return this.b.get(symbolicName);
    }

    public Iterator<XQueryFunction> getFunctionDefinitions() {
        return this.b.values().iterator();
    }

    protected void fixupGlobalFunctions(QueryModule object) {
        object = ExpressionVisitor.make((StaticContext)object);
        for (XQueryFunction xQueryFunction : this.b.values()) {
            xQueryFunction.compile();
        }
        for (XQueryFunction xQueryFunction : this.b.values()) {
            xQueryFunction.checkReferences((ExpressionVisitor)object);
        }
    }

    protected void optimizeGlobalFunctions(QueryModule queryModule) {
        for (XQueryFunction xQueryFunction : this.b.values()) {
            if (((QueryModule)xQueryFunction.getStaticContext()).getTopLevelModule() != queryModule) continue;
            xQueryFunction.optimize();
        }
    }

    public void explainGlobalFunctions(ExpressionPresenter expressionPresenter) {
        for (XQueryFunction xQueryFunction : this.b.values()) {
            xQueryFunction.explain(expressionPresenter);
        }
    }

    public UserFunction getUserDefinedFunction(String object, String string, int n2) {
        object = new SymbolicName.F(new StructuredQName("", (String)object, string), n2);
        if ((object = this.b.get(object)) == null) {
            return null;
        }
        return ((XQueryFunction)object).getUserFunction();
    }

    @Override
    public FunctionLibrary copy() {
        XQueryFunctionLibrary xQueryFunctionLibrary = new XQueryFunctionLibrary(this.a);
        new XQueryFunctionLibrary(this.a).b = new HashMap<SymbolicName, XQueryFunction>(this.b);
        return xQueryFunctionLibrary;
    }

    public static class UnresolvedCallable
    implements Callable,
    UserFunctionResolvable {
        private SymbolicName.F a;
        private UserFunction b;

        public UnresolvedCallable(SymbolicName.F f2) {
            this.a = f2;
        }

        public StructuredQName getFunctionName() {
            return this.a.getComponentName();
        }

        public int getArity() {
            return this.a.getArity();
        }

        @Override
        public Sequence<?> call(XPathContext xPathContext, Sequence<?>[] sequenceArray) {
            if (this.b == null) {
                throw new XPathException("Forwards reference to XQuery function has not been resolved");
            }
            Sequence[] sequenceArray2 = new Sequence[sequenceArray.length];
            for (int i2 = 0; i2 < sequenceArray.length; ++i2) {
                sequenceArray2[i2] = sequenceArray[i2].iterate().materialize();
            }
            return this.b.call((XPathContext)xPathContext.newCleanContext(), sequenceArray2);
        }

        @Override
        public void setFunction(UserFunction userFunction) {
            this.b = userFunction;
        }

        public UserFunction getFunction() {
            return this.b;
        }
    }
}

