/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.EagerLetExpression;
import net.sf.saxon.expr.EquivalenceComparison;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.CountClause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.GroupByClause;
import net.sf.saxon.expr.flwor.LetClause;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OrderByClause;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.WhereClause;
import net.sf.saxon.expr.flwor.WindowClause;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Comment;
import net.sf.saxon.expr.instruct.ComputedAttribute;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NamespaceConstructor;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.ProcessingInstruction;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.pattern.UnionQNameTest;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceResolverWithDefault;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashSet;

public class XQueryParser
extends XPathParser {
    public static final String XQUERY10 = "1.0";
    public static final String XQUERY30 = "3.0";
    public static final String XQUERY31 = "3.1";
    private boolean a = false;
    private boolean b = false;
    private int c = 0;
    private XPathException d = null;
    protected Executable executable;
    private boolean e = false;
    private boolean f = false;
    private boolean g = false;
    private boolean h = false;
    private boolean i = false;
    private boolean j = false;
    private boolean k = false;
    private boolean l = false;
    private boolean m = false;
    private boolean n = false;
    private boolean o = false;
    private boolean p = false;
    public final Set<String> importedModules = new HashSet<String>(5);
    private List<String> q = new ArrayList<String>(10);
    private List<b> r = new ArrayList<b>(5);
    private List<b> s = new ArrayList<b>(5);
    private final Set<StructuredQName> u = new HashSet<StructuredQName>(4);
    private Properties v;
    private static final Pattern w = Pattern.compile("^[A-Za-z]([A-Za-z0-9._\\x2D])*$");
    public static final StructuredQName SAXON_MEMO_FUNCTION = new StructuredQName("saxon", "http://saxon.sf.net/", "memo-function");

    public XQueryParser() {
        this.setLanguage(3, 31);
    }

    public XQueryParser newParser() {
        XQueryParser xQueryParser = new XQueryParser();
        xQueryParser.setLanguage(this.language, 31);
        xQueryParser.setParserExtension(this.parserExtension);
        return xQueryParser;
    }

    public XQueryExpression makeXQueryExpression(String object, QueryModule queryModule, Configuration configuration) {
        try {
            Object object2;
            this.setLanguage(3, 31);
            object = configuration.getXMLVersion() == 10 ? XQueryParser.b((String)object) : XQueryParser.a((String)object);
            Executable executable = queryModule.getExecutable();
            if (executable == null) {
                executable = new Executable(configuration);
                executable.setHostLanguage(51);
                executable.setTopLevelPackage(queryModule.getPackageData());
                this.setExecutable(executable);
            }
            if ((object2 = executable.getGlobalContextRequirement()) != null) {
                ((GlobalContextRequirement)object2).addRequiredItemType(queryModule.getRequiredContextItemType());
            } else if (queryModule.getRequiredContextItemType() != null && queryModule.getRequiredContextItemType() != AnyItemType.getInstance()) {
                object2 = new GlobalContextRequirement();
                ((GlobalContextRequirement)object2).setExternal(true);
                ((GlobalContextRequirement)object2).addRequiredItemType(queryModule.getRequiredContextItemType());
                executable.setGlobalContextRequirement((GlobalContextRequirement)object2);
            }
            object2 = new Properties(configuration.getDefaultSerializationProperties());
            if (((Properties)object2).getProperty("method") == null) {
                ((Properties)object2).setProperty("method", "xml");
            }
            this.v = new Properties((Properties)object2);
            executable.setDefaultOutputProperties(new Properties(this.v));
            object2 = new FunctionLibraryList();
            ((FunctionLibraryList)object2).addFunctionLibrary(new ExecutableFunctionLibrary(configuration));
            executable.setFunctionLibrary((FunctionLibraryList)object2);
            this.setExecutable(executable);
            this.setCodeInjector(queryModule.getCodeInjector());
            object = this.a((String)object, queryModule);
            if (this.b) {
                this.env.getConfiguration().checkLicensedFeature(4, "streaming", -1);
            }
            executable.fixupQueryModules(queryModule);
            object = configuration.makeXQueryExpression((Expression)object, queryModule, this.b);
            object2 = executable.getFunctionLibrary();
            FunctionLibraryList functionLibraryList = new FunctionLibraryList();
            functionLibraryList.addFunctionLibrary(queryModule.getBuiltInFunctionSet());
            functionLibraryList.addFunctionLibrary(configuration.getBuiltInExtensionLibraryList());
            functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(configuration));
            functionLibraryList.addFunctionLibrary(configuration.getIntegratedFunctionLibrary());
            functionLibraryList.addFunctionLibrary(queryModule.getGlobalFunctionLibrary());
            configuration.addExtensionBinders(functionLibraryList);
            functionLibraryList.addFunctionLibrary((FunctionLibrary)object2);
            executable.setFunctionLibrary(functionLibraryList);
            return object;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            if (!xPathException.hasBeenReported()) {
                this.a(xPathException2);
            }
            throw xPathException2;
        }
    }

    public int getPermittedFunctions() {
        return 17;
    }

    public void checkStreamability(Expression expression, ContextItemStaticInfo contextItemStaticInfo) {
        throw new XPathException("Streaming requires Saxon-EE");
    }

    private static String a(String string) {
        if (string.indexOf(13) < 0 && string.indexOf(133) < 0 && string.indexOf(8232) < 0) {
            return string;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u0085': 
                case '\u2028': {
                    fastStringBuffer.append('\n');
                    continue block4;
                }
                case '\r': {
                    if (i2 < string.length() - 1 && (string.charAt(i2 + 1) == '\n' || string.charAt(i2 + 1) == '\u0085')) {
                        fastStringBuffer.append('\n');
                        ++i2;
                        continue block4;
                    }
                    fastStringBuffer.append('\n');
                    continue block4;
                }
                default: {
                    fastStringBuffer.append(c2);
                }
            }
        }
        return fastStringBuffer.toString();
    }

    private static String b(String string) {
        if (string.indexOf(13) < 0) {
            return string;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        block3: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\r': {
                    if (i2 < string.length() - 1 && string.charAt(i2 + 1) == '\n') {
                        fastStringBuffer.append('\n');
                        ++i2;
                        continue block3;
                    }
                    fastStringBuffer.append('\n');
                    continue block3;
                }
                default: {
                    fastStringBuffer.append(c2);
                }
            }
        }
        return fastStringBuffer.toString();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    @Override
    protected void customizeTokenizer(Tokenizer tokenizer) {
        tokenizer.isXQuery = true;
    }

    public void setStreaming(boolean bl2) {
        this.b = bl2;
    }

    public boolean isStreaming() {
        return this.b;
    }

    private Expression a(String object, QueryModule queryModule) {
        this.env = Objects.requireNonNull(queryModule);
        this.charChecker = queryModule.getConfiguration().getValidCharacterChecker();
        this.language = 3;
        this.t = new Tokenizer();
        this.t.languageLevel = 31;
        this.t.isXQuery = true;
        try {
            this.t.tokenize(Objects.requireNonNull(object), 0, -1);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        this.a();
        XQueryParser xQueryParser = this;
        xQueryParser.allowSaxonExtensions = xQueryParser.t.allowSaxonExtensions = queryModule.getConfiguration().getBooleanProperty(Feature.ALLOW_SYNTAX_EXTENSIONS);
        object = new QNameParser(queryModule.getLiveNamespaceResolver());
        ((QNameParser)object).setAcceptEQName(true);
        ((QNameParser)object).setUnescaper(new Unescaper(queryModule.getConfiguration().getValidCharacterChecker()));
        this.setQNameParser((QNameParser)object);
        this.b();
        this.c();
        object = this.parseExpression();
        object = this.makeTracer(0, (Expression)object, 2070, null);
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of query");
        }
        this.setLocation((Expression)object);
        ExpressionTool.setDeepRetainedStaticContext((Expression)object, queryModule.makeRetainedStaticContext());
        if (this.c == 0) {
            return object;
        }
        object = new XPathException("One or more static errors were reported during query analysis");
        ((XPathException)object).setHasBeenReported(true);
        ((XPathException)object).setErrorCodeQName(this.d.getErrorCodeQName());
        throw object;
    }

    public final void parseLibraryModule(String object, QueryModule object2) {
        this.env = object2;
        Object object3 = ((QueryModule)object2).getConfiguration();
        this.charChecker = ((Configuration)object3).getValidCharacterChecker();
        object = ((Configuration)object3).getXMLVersion() == 10 ? XQueryParser.b((String)object) : XQueryParser.a((String)object);
        Executable executable = ((QueryModule)object2).getExecutable();
        if (executable == null) {
            throw new IllegalStateException("Query library module has no associated Executable");
        }
        this.executable = executable;
        this.t = new Tokenizer();
        this.t.languageLevel = 31;
        this.t.isXQuery = true;
        object2 = new QNameParser(((QueryModule)object2).getLiveNamespaceResolver());
        ((QNameParser)object2).setAcceptEQName(true);
        ((QNameParser)object2).setUnescaper(new Unescaper(((Configuration)object3).getValidCharacterChecker()));
        this.setQNameParser((QNameParser)object2);
        try {
            this.t.tokenize((String)object, 0, -1);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        this.a();
        object = this;
        ((XPathParser)object).expect(101);
        ((XPathParser)object).nextToken();
        ((XPathParser)object).expect(201);
        object2 = ((XPathParser)object).t.currentTokenValue;
        ((XPathParser)object).nextToken();
        ((XPathParser)object).expect(6);
        ((XPathParser)object).nextToken();
        ((XPathParser)object).expect(202);
        Object object4 = object;
        object3 = ((XQueryParser)object4).uriLiteral(((XPathParser)object4).t.currentTokenValue);
        super.a((String)object2, (String)object3);
        if (((String)object3).isEmpty()) {
            ((XPathParser)object).grumble("Module namespace cannot be \"\"", "XQST0088");
            object3 = "http://saxon.fallback.namespace/";
        }
        ((XPathParser)object).nextToken();
        ((XPathParser)object).expect(149);
        ((XPathParser)object).nextToken();
        try {
            ((QueryModule)((XPathParser)object).env).setModuleNamespace((String)object3);
            ((QueryModule)((XPathParser)object).env).declarePrologNamespace((String)object2, (String)object3);
            ((XQueryParser)object).executable.addQueryLibraryModule((QueryModule)((XPathParser)object).env);
        }
        catch (XPathException xPathException) {
            object2 = xPathException;
            xPathException.setLocator(((XPathParser)object).makeLocation());
            super.a((XPathException)object2);
        }
        this.b();
        this.c();
        if (this.t.currentToken != 0) {
            this.grumble("Unrecognized content found after the variable and function declarations in a library module");
        }
        if (this.c != 0) {
            object = new XPathException("Static errors were reported in the imported library module");
            ((XPathException)object).setErrorCodeQName(this.d.getErrorCodeQName());
            throw object;
        }
    }

    private void a(XPathException xPathException) {
        ++this.c;
        if (this.d == null) {
            this.d = xPathException;
        }
        ((QueryModule)this.env).reportStaticError(xPathException);
        throw xPathException;
    }

    private void a() {
        if (this.t.currentToken == 88) {
            this.nextToken();
            this.expect(202);
            XQueryParser xQueryParser = this;
            String string = xQueryParser.unescape(xQueryParser.t.currentTokenValue).toString();
            Object[] objectArray = new String[]{XQUERY10, XQUERY30, XQUERY31};
            if (Arrays.binarySearch(objectArray, string) < 0) {
                this.grumble("Invalid XQuery version " + string, "XQST0031");
            }
            this.nextToken();
            if ("encoding".equals(this.t.currentTokenValue)) {
                this.nextToken();
                this.expect(202);
                XQueryParser xQueryParser2 = this;
                if (!w.matcher(xQueryParser2.unescape(xQueryParser2.t.currentTokenValue)).matches()) {
                    this.grumble("Encoding name contains invalid characters", "XQST0087");
                }
                this.nextToken();
            }
            this.expect(149);
            this.nextToken();
            return;
        }
        if (this.t.currentToken == 89) {
            this.nextToken();
            this.expect(202);
            if (!w.matcher(this.t.currentTokenValue).matches()) {
                this.grumble("Encoding name contains invalid characters", "XQST0087");
            }
            this.nextToken();
            this.expect(149);
            this.nextToken();
        }
    }

    private void b() {
        boolean bl2 = true;
        boolean bl3 = true;
        while (true) {
            Object object;
            try {
                while (true) {
                    if (this.t.currentToken == 101) {
                        object = ((QueryModule)this.env).getModuleNamespace();
                        if (object == null) {
                            this.grumble("Module declaration must not be used in a main module");
                        } else {
                            this.grumble("Module declaration appears more than once");
                        }
                        if (!bl2) {
                            this.grumble("Module declaration must precede other declarations in the query prolog");
                        }
                    }
                    bl2 = false;
                    block1 : switch (this.t.currentToken) {
                        case 90: {
                            if (!bl3) {
                                this.grumble("Namespace declarations cannot follow variables, functions, or options");
                            }
                            this.r();
                            break;
                        }
                        case 123: {
                            this.c();
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.nextToken();
                            this.expect(106);
                            object = this.parseAnnotationsList();
                            if (this.isKeyword("function")) {
                                ((AnnotationList)object).check(this.env.getConfiguration(), "DF");
                                this.parseFunctionDeclaration((AnnotationList)object);
                                break;
                            }
                            if (this.isKeyword("variable")) {
                                ((AnnotationList)object).check(this.env.getConfiguration(), "DV");
                                this.a((AnnotationList)object);
                                break;
                            }
                            this.grumble("Annotations can appear only in 'declare variable' and 'declare function'");
                            break;
                        }
                        case 91: {
                            this.nextToken();
                            this.expect(201);
                            switch (this.t.currentTokenValue) {
                                case "element": {
                                    if (!bl3) {
                                        this.grumble("Namespace declarations cannot follow variables, functions, or options");
                                    }
                                    this.q();
                                    break block1;
                                }
                                case "function": {
                                    if (!bl3) {
                                        this.grumble("Namespace declarations cannot follow variables, functions, or options");
                                    }
                                    this.p();
                                    break block1;
                                }
                                case "collation": {
                                    if (!bl3) {
                                        this.grumble("Collation declarations must appear earlier in the prolog");
                                    }
                                    this.d();
                                    break block1;
                                }
                                case "order": {
                                    if (!bl3) {
                                        this.grumble("Order declarations must appear earlier in the prolog");
                                    }
                                    this.e();
                                    break block1;
                                }
                                case "decimal-format": {
                                    this.nextToken();
                                    this.o();
                                    break block1;
                                }
                            }
                            this.grumble("After 'declare default', expected 'element', 'function', or 'collation'");
                            break;
                        }
                        case 94: {
                            if (!bl3) {
                                this.grumble("'declare boundary-space' must appear earlier in the query prolog");
                            }
                            this.f();
                            break;
                        }
                        case 107: {
                            if (!bl3) {
                                this.grumble("'declare ordering' must appear earlier in the query prolog");
                            }
                            this.g();
                            break;
                        }
                        case 108: {
                            if (!bl3) {
                                this.grumble("'declare copy-namespaces' must appear earlier in the query prolog");
                            }
                            this.h();
                            break;
                        }
                        case 93: {
                            if (!bl3) {
                                this.grumble("'declare base-uri' must appear earlier in the query prolog");
                            }
                            this.m();
                            break;
                        }
                        case 95: {
                            if (!bl3) {
                                this.grumble("'declare decimal-format' must appear earlier in the query prolog");
                            }
                            this.n();
                            break;
                        }
                        case 96: {
                            if (!bl3) {
                                this.grumble("Import schema must appear earlier in the prolog");
                            }
                            this.j();
                            break;
                        }
                        case 97: {
                            if (!bl3) {
                                this.grumble("Import module must appear earlier in the prolog");
                            }
                            this.l();
                            break;
                        }
                        case 98: {
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.c();
                            this.a(AnnotationList.EMPTY);
                            break;
                        }
                        case 99: {
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.c();
                            this.s();
                            break;
                        }
                        case 100: {
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.c();
                            this.parseFunctionDeclaration(AnnotationList.EMPTY);
                            break;
                        }
                        case 122: {
                            this.nextToken();
                            if (!this.isKeyword("function")) {
                                this.grumble("expected 'function' after 'declare updating");
                            }
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.c();
                            this.parserExtension.parseUpdatingFunctionDeclaration(this);
                            break;
                        }
                        case 109: {
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.t();
                            break;
                        }
                        case 124: {
                            this.checkSyntaxExtensions("declare type");
                            if (bl3) {
                                XQueryParser.a(this.q, this.env.getConfiguration());
                                bl3 = false;
                            }
                            this.parseTypeAliasDeclaration();
                            break;
                        }
                        case 92: {
                            if (!bl3) {
                                this.grumble("'declare construction' must appear earlier in the query prolog");
                            }
                            this.i();
                            break;
                        }
                        case 110: {
                            if (!bl3) {
                                this.grumble("'declare revalidation' must appear earlier in the query prolog");
                            }
                            this.parserExtension.parseRevalidationDeclaration(this);
                            break;
                        }
                        case 0: {
                            object = ((QueryModule)this.env).getModuleNamespace();
                            if (object == null) {
                                this.grumble("The main module must contain a query expression after any declarations in the prolog");
                                break;
                            }
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                    this.expect(149);
                    this.nextToken();
                }
            }
            catch (XPathException xPathException) {
                object = xPathException;
                if (xPathException.getLocator() == null) {
                    ((TransformerException)object).setLocator(this.makeLocation());
                }
                if (!((XPathException)object).hasBeenReported()) {
                    ++this.c;
                    if (this.d == null) {
                        this.d = object;
                    }
                    ((QueryModule)this.env).reportStaticError((XPathException)object);
                }
                while (this.t.currentToken != 149) {
                    this.nextToken();
                    if (this.t.currentToken == 0) {
                        return;
                    }
                    if (this.t.currentToken == 215) {
                        this.t.lookAhead();
                        continue;
                    }
                    if (this.t.currentToken != 217) continue;
                    this.a(true);
                }
                this.nextToken();
                continue;
            }
            break;
        }
    }

    @Override
    protected AnnotationList parseAnnotationsList() {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        do {
            Object object;
            String string;
            this.t.setState(1);
            this.nextToken();
            this.expect(201);
            this.t.setState(0);
            if (this.t.currentTokenValue.indexOf(58) < 0) {
                string = "http://www.w3.org/2012/xquery";
                object = new StructuredQName("", string, this.t.currentTokenValue);
            } else {
                XQueryParser xQueryParser = this;
                object = xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, "");
                assert (object != null);
                string = ((StructuredQName)object).getURI();
            }
            Annotation annotation = new Annotation((StructuredQName)object);
            if (string.equals("http://www.w3.org/2012/xquery")) {
                if (!(((StructuredQName)object).equals(Annotation.PRIVATE) || ((StructuredQName)object).equals(Annotation.PUBLIC) || ((StructuredQName)object).equals(Annotation.UPDATING) || ((StructuredQName)object).equals(Annotation.SIMPLE))) {
                    this.grumble("Unrecognized variable or function annotation " + ((StructuredQName)object).getDisplayName(), "XQST0045");
                }
                annotation.addAnnotationParameter(new Int64Value(0L));
            } else if (this.isReservedInQuery(string)) {
                this.grumble("The annotation " + this.t.currentTokenValue + " is in a reserved namespace", "XQST0045");
            } else if (string.equals("")) {
                this.grumble("The annotation " + this.t.currentTokenValue + " is in no namespace", "XQST0045");
            }
            this.nextToken();
            if (this.t.currentToken == 5) {
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.grumble("Annotation parameter list cannot be empty");
                }
                while (true) {
                    switch (this.t.currentToken) {
                        case 202: {
                            object = (Literal)this.parseStringLiteral(false);
                            break;
                        }
                        case 209: {
                            object = (Literal)this.parseNumericLiteral(false);
                            break;
                        }
                        default: {
                            this.grumble("Annotation parameter must be a literal");
                            return null;
                        }
                    }
                    object = ((Literal)object).getValue();
                    if (object instanceof StringValue || object instanceof NumericValue) {
                        annotation.addAnnotationParameter((AtomicValue)object);
                    } else {
                        this.grumble("Annotation parameter must be a string or number");
                    }
                    if (this.t.currentToken == 204) {
                        this.nextToken();
                        break;
                    }
                    this.expect(7);
                    this.nextToken();
                }
            }
            arrayList.add(annotation);
        } while (this.t.currentToken == 106);
        return new AnnotationList(arrayList);
    }

    private static void a(List object, Configuration configuration) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (String)object2;
            configuration.sealNamespace((String)object2);
        }
    }

    private void c() {
        Serializable serializable;
        if (this.p) {
            return;
        }
        this.p = true;
        if (this.i) {
            Object object = this.env.getDefaultCollationName();
            try {
                URI object2 = new URI((String)object);
                if (!object2.isAbsolute()) {
                    serializable = new URI(this.env.getStaticBaseURI());
                    URI uRI = ((URI)serializable).resolve(object2);
                    object = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.grumble("Default collation name '" + object + "' is not a valid URI", "XQST0046");
                object = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            if (this.env.getConfiguration().getCollation((String)object) == null) {
                this.grumble("Default collation name '" + (String)object + "' is not a recognized collation", "XQST0038");
                object = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            ((QueryModule)this.env).setDefaultCollationName((String)object);
        }
        for (b b2 : this.r) {
            try {
                this.a(b2);
            }
            catch (XPathException xPathException) {
                serializable = xPathException;
                if (xPathException.hasBeenReported()) continue;
                throw serializable;
            }
        }
        for (b b3 : this.s) {
            try {
                this.applyModuleImport(b3);
            }
            catch (XPathException xPathException) {
                serializable = xPathException;
                if (xPathException.hasBeenReported()) continue;
                throw serializable;
            }
        }
    }

    private void d() {
        if (this.i) {
            this.grumble("default collation appears more than once", "XQST0038");
        }
        this.i = true;
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser = this;
        String string = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
        ((QueryModule)this.env).setDefaultCollationName(string);
        this.nextToken();
    }

    private void e() {
        if (this.h) {
            this.grumble("empty ordering declaration appears more than once", "XQST0069");
        }
        this.h = true;
        this.nextToken();
        if (!this.isKeyword("empty")) {
            this.grumble("After 'declare default order', expected keyword 'empty'");
        }
        this.nextToken();
        if (this.isKeyword("least")) {
            ((QueryModule)this.env).setEmptyLeast(true);
        } else if (this.isKeyword("greatest")) {
            ((QueryModule)this.env).setEmptyLeast(false);
        } else {
            this.grumble("After 'declare default order empty', expected keyword 'least' or 'greatest'");
        }
        this.nextToken();
    }

    private void f() {
        if (this.f) {
            this.grumble("'declare boundary-space' appears more than once", "XQST0068");
        }
        this.f = true;
        this.nextToken();
        this.expect(201);
        if ("preserve".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveBoundarySpace(true);
        } else if ("strip".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveBoundarySpace(false);
        } else {
            this.grumble("boundary-space must be 'preserve' or 'strip'");
        }
        this.nextToken();
    }

    private void g() {
        if (this.g) {
            this.grumble("ordering mode declaration appears more than once", "XQST0065");
        }
        this.g = true;
        this.nextToken();
        this.expect(201);
        if (!"ordered".equals(this.t.currentTokenValue) && !"unordered".equals(this.t.currentTokenValue)) {
            this.grumble("ordering mode must be 'ordered' or 'unordered'");
        }
        this.nextToken();
    }

    private void h() {
        if (this.e) {
            this.grumble("declare copy-namespaces appears more than once", "XQST0055");
        }
        this.e = true;
        this.nextToken();
        this.expect(201);
        if ("preserve".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveNamespaces(true);
        } else if ("no-preserve".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveNamespaces(false);
        } else {
            this.grumble("copy-namespaces must be followed by 'preserve' or 'no-preserve'");
        }
        this.nextToken();
        this.expect(7);
        this.nextToken();
        this.expect(201);
        if ("inherit".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setInheritNamespaces(true);
        } else if ("no-inherit".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setInheritNamespaces(false);
        } else {
            this.grumble("After the comma in the copy-namespaces declaration, expected 'inherit' or 'no-inherit'");
        }
        this.nextToken();
    }

    private void i() {
        int n2;
        if (this.j) {
            this.grumble("declare construction appears more than once", "XQST0067");
        }
        this.j = true;
        this.nextToken();
        this.expect(201);
        if ("preserve".equals(this.t.currentTokenValue)) {
            n2 = 3;
        } else if ("strip".equals(this.t.currentTokenValue)) {
            n2 = 4;
        } else {
            this.grumble("construction mode must be 'preserve' or 'strip'");
            n2 = 4;
        }
        ((QueryModule)this.env).setConstructionMode(n2);
        this.nextToken();
    }

    protected void parseRevalidationDeclaration() {
        this.grumble("declare revalidation is allowed only in XQuery Update");
    }

    /*
     * WARNING - void declaration
     */
    private void j() {
        void var2_5;
        Iterator<b> iterator;
        this.ensureSchemaAware("import schema");
        b b2 = new b(0);
        Object object2 = null;
        b2.a = null;
        b2.b = new ArrayList<String>(5);
        this.nextToken();
        if (this.isKeyword("namespace")) {
            String string = this.k();
        } else if (this.isKeyword("default")) {
            this.nextToken();
            if (!this.isKeyword("element")) {
                this.grumble("In 'import schema', expected 'element namespace'");
            }
            this.nextToken();
            if (!this.isKeyword("namespace")) {
                this.grumble("In 'import schema', expected keyword 'namespace'");
            }
            this.nextToken();
            String string = "";
        }
        if (this.t.currentToken == 202) {
            XQueryParser xQueryParser = this;
            iterator = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
            this.a((String)var2_5, (String)((Object)iterator));
            b2.a = iterator;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(202);
                XQueryParser xQueryParser2 = this;
                b2.b.add(xQueryParser2.uriLiteral(xQueryParser2.t.currentTokenValue));
                this.nextToken();
                while (this.t.currentToken == 7) {
                    this.nextToken();
                    this.expect(202);
                    XQueryParser xQueryParser3 = this;
                    b2.b.add(xQueryParser3.uriLiteral(xQueryParser3.t.currentTokenValue));
                    this.nextToken();
                }
            } else if (this.t.currentToken != 149) {
                this.grumble("After the target namespace URI, expected 'at' or ';'");
            }
        } else {
            this.grumble("After 'import schema', expected 'namespace', 'default', or a string-literal");
        }
        if (var2_5 != null) {
            try {
                if (var2_5.isEmpty()) {
                    ((QueryModule)this.env).setDefaultElementNamespace(b2.a);
                } else {
                    if (b2.a == null || "".equals(b2.a)) {
                        this.grumble("A prefix cannot be bound to the null namespace", "XQST0057");
                    }
                    ((QueryModule)this.env).declarePrologNamespace((String)var2_5, b2.a);
                }
            }
            catch (XPathException xPathException) {
                iterator = xPathException;
                xPathException.setLocator(this.makeLocation());
                this.a((XPathException)((Object)iterator));
            }
        }
        iterator = this.r.iterator();
        while (iterator.hasNext()) {
            b b3;
            b b4 = b3 = iterator.next();
            if (!b3.a.equals(b2.a)) continue;
            this.grumble("Schema namespace '" + b2.a + "' is imported more than once", "XQST0058");
            break;
        }
        this.r.add(b2);
    }

    private String k() {
        this.t.setState(0);
        this.nextToken();
        this.expect(201);
        String string = this.t.currentTokenValue;
        this.nextToken();
        this.expect(6);
        this.nextToken();
        return string;
    }

    protected void ensureSchemaAware(String string) {
        if (!this.env.getConfiguration().isLicensedFeature(4)) {
            throw new XPathException("This Saxon version and license does not allow use of '" + string + "'", "XQST0009");
        }
        this.env.getConfiguration().checkLicensedFeature(4, string, -1);
        this.getExecutable().setSchemaAware(true);
        this.getStaticContext().getPackageData().setSchemaAware(true);
    }

    private void a(b b2) {
        Configuration configuration;
        Configuration configuration2 = configuration = this.env.getConfiguration();
        synchronized (configuration) {
            if (!configuration.isSchemaAvailable(b2.a)) {
                if (!b2.b.isEmpty()) {
                    try {
                        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
                        configuration.readMultipleSchemas(pipelineConfiguration, this.env.getStaticBaseURI(), b2.b, b2.a);
                        this.q.add(b2.a);
                    }
                    catch (SchemaException schemaException) {
                        this.grumble("Error in schema " + b2.a + ": " + schemaException.getMessage(), "XQST0059");
                    }
                } else if (b2.a.equals("http://www.w3.org/XML/1998/namespace") || b2.a.equals("http://www.w3.org/2005/xpath-functions") || b2.a.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    configuration.addSchemaForBuiltInNamespace(b2.a);
                } else {
                    this.grumble("Unable to locate requested schema " + b2.a, "XQST0059");
                }
            }
            ((QueryModule)this.env).addImportedSchema(b2.a, this.env.getStaticBaseURI(), b2.b);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private void l() {
        Object object;
        QueryModule queryModule = (QueryModule)this.env;
        b b2 = new b(0);
        String string = null;
        b2.a = null;
        b2.b = new ArrayList<String>(5);
        this.nextToken();
        if (this.t.currentToken == 201 && this.t.currentTokenValue.equals("namespace")) {
            string = this.k();
        }
        if (this.t.currentToken == 202) {
            XQueryParser xQueryParser = this;
            object = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
            this.a(string, (String)object);
            b2.a = object;
            if (b2.a.isEmpty()) {
                this.grumble("Imported module namespace cannot be \"\"", "XQST0088");
                b2.a = "http://saxon.fallback.namespace/line" + this.t.getLineNumber();
            }
            if (this.importedModules.contains(b2.a)) {
                this.grumble("Two 'import module' declarations specify the same module namespace", "XQST0047");
            }
            this.importedModules.add(b2.a);
            ((QueryModule)this.env).addImportedNamespace(b2.a);
            this.nextToken();
            if (this.isKeyword("at")) {
                do {
                    this.nextToken();
                    this.expect(202);
                    XQueryParser xQueryParser2 = this;
                    b2.b.add(xQueryParser2.uriLiteral(xQueryParser2.t.currentTokenValue));
                    this.nextToken();
                } while (this.t.currentToken == 7);
            }
        } else {
            this.grumble("After 'import module', expected 'namespace' or a string-literal");
        }
        if (string != null) {
            try {
                if (!b2.a.equals(queryModule.getModuleNamespace()) || !b2.a.equals(queryModule.checkURIForPrefix(string))) {
                    queryModule.declarePrologNamespace(string, b2.a);
                }
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.setLocator(this.makeLocation());
                this.a((XPathException)object);
            }
        }
        this.s.add(b2);
    }

    public void applyModuleImport(b b2) {
        List<QueryModule> list;
        String[] stringArray;
        List<QueryModule> list2;
        for (int i2 = 0; i2 < b2.b.size(); ++i2) {
            try {
                list2 = b2.b.get(i2);
                stringArray = ResolveURI.makeAbsolute((String)((Object)list2), this.env.getStaticBaseURI());
                b2.b.set(i2, stringArray.toString());
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.grumble("Invalid URI " + b2.b.get(i2) + ": " + uRISyntaxException.getMessage(), "XQST0046");
            }
        }
        QueryLibrary queryLibrary = ((QueryModule)this.env).getUserQueryContext().getCompiledLibrary(b2.a);
        if (queryLibrary != null) {
            this.executable.addQueryLibraryModule(queryLibrary);
            list2 = new ArrayList<QueryLibrary>();
            list2.add(queryLibrary);
            queryLibrary.link((QueryModule)this.env);
        } else if (!this.env.getConfiguration().getBooleanProperty(Feature.XQUERY_MULTIPLE_MODULE_IMPORTS)) {
            list2 = this.executable.getQueryLibraryModules(b2.a);
            if (list2 != null && !list2.isEmpty()) {
                return;
            }
        } else {
            for (int i3 = b2.b.size() - 1; i3 >= 0; --i3) {
                if (!this.executable.isQueryLocationHintProcessed(b2.b.get(i3))) continue;
                b2.b.remove(i3);
            }
        }
        if (b2.b.isEmpty() && (list = this.executable.getQueryLibraryModules(b2.a)) != null && !list.isEmpty()) {
            return;
        }
        Object object = ((QueryModule)this.env).getUserQueryContext().getModuleURIResolver();
        stringArray = new String[b2.b.size()];
        for (int i4 = 0; i4 < stringArray.length; ++i4) {
            stringArray[i4] = b2.b.get(i4);
        }
        StreamSource[] streamSourceArray = null;
        if (object != null) {
            try {
                streamSourceArray = object.resolve(b2.a, this.env.getStaticBaseURI(), stringArray);
            }
            catch (XPathException xPathException) {
                this.grumble("Failed to resolve URI of imported module: " + xPathException.getMessage(), "XQST0059");
            }
        }
        if (streamSourceArray == null) {
            if (stringArray.length == 0) {
                this.grumble("Cannot locate module for namespace " + b2.a, "XQST0059");
            }
            object = this.env.getConfiguration().getStandardModuleURIResolver();
            streamSourceArray = object.resolve(b2.a, this.env.getStaticBaseURI(), stringArray);
        }
        for (String object2 : b2.b) {
            this.executable.addQueryLocationHintProcessed(object2);
        }
        for (int i5 = 0; i5 < streamSourceArray.length; ++i5) {
            StreamSource streamSource = streamSourceArray[i5];
            String string = streamSource.getSystemId();
            if (string == null) {
                if (i5 < stringArray.length) {
                    string = stringArray[i5];
                    streamSource.setSystemId(stringArray[i5]);
                } else {
                    this.grumble("No base URI available for imported module", "XQST0059");
                }
            }
            object = this.executable.getQueryLibraryModules(b2.a);
            boolean bl2 = false;
            if (object != null && i5 < stringArray.length) {
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = (QueryModule)object.next();
                    if ((object2 = ((QueryModule)object2).getLocationURI()) == null || !((URI)object2).toString().equals(b2.b.get(i5))) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) break;
            try {
                object = QueryReader.readSourceQuery(streamSource, this.charChecker);
                try {
                    if (streamSource.getInputStream() != null) {
                        streamSource.getInputStream().close();
                    } else if (streamSource.getReader() != null) {
                        streamSource.getReader().close();
                    }
                }
                catch (IOException iOException) {
                    throw new XPathException("Failure while closing file for imported query module");
                }
                QueryModule.makeQueryModule(string, this.executable, (QueryModule)this.env, (String)object, b2.a);
                continue;
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.makeLocation());
                this.a((XPathException)object);
            }
        }
    }

    private void m() {
        if (this.m) {
            this.grumble("Base URI Declaration may only appear once", "XQST0032");
        }
        this.m = true;
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser = this;
        String string = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
        try {
            Object object = new URI(string);
            if (!((URI)object).isAbsolute()) {
                object = this.env.getStaticBaseURI();
                string = ResolveURI.makeAbsolute(string, (String)object).toString();
            }
            ((QueryModule)this.env).setBaseURI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            ((QueryModule)this.env).setBaseURI(string);
        }
        this.nextToken();
    }

    private void n() {
        this.nextToken();
        this.expect(201);
        XQueryParser xQueryParser = this;
        StructuredQName structuredQName = xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, "");
        if (this.env.getDecimalFormatManager().getNamedDecimalFormat(structuredQName) != null) {
            this.grumble("Duplicate declaration of decimal-format " + structuredQName.getDisplayName(), "XQST0111");
        }
        this.nextToken();
        this.a(structuredQName);
    }

    private void o() {
        if (this.o) {
            this.grumble("Duplicate declaration of default decimal-format", "XQST0111");
        }
        this.o = true;
        this.a((StructuredQName)null);
    }

    private void a(StructuredQName object) {
        int n2 = this.t.currentTokenStartOffset;
        Object object2 = this.env.getDecimalFormatManager();
        object2 = object == null ? ((DecimalFormatManager)object2).getDefaultDecimalFormat() : ((DecimalFormatManager)object2).obtainNamedDecimalFormat((StructuredQName)object);
        ((DecimalSymbols)object2).setHostLanguage(51, 31);
        HashSet<String> hashSet = new HashSet<String>(10);
        block30: while (this.t.currentToken != 149) {
            int n3 = this.t.currentTokenStartOffset;
            String string = this.t.currentTokenValue;
            if (hashSet.contains(string)) {
                this.grumble("Property name " + string + " is defined more than once", "XQST0114", n3);
            }
            this.nextToken();
            this.expect(6);
            this.nextToken();
            this.expect(202);
            XQueryParser xQueryParser = this;
            String string2 = xQueryParser.unescape(xQueryParser.t.currentTokenValue).toString();
            this.nextToken();
            hashSet.add(string);
            switch (string) {
                case "decimal-separator": {
                    ((DecimalSymbols)object2).setDecimalSeparator(string2);
                    continue block30;
                }
                case "grouping-separator": {
                    ((DecimalSymbols)object2).setGroupingSeparator(string2);
                    continue block30;
                }
                case "infinity": {
                    ((DecimalSymbols)object2).setInfinity(string2);
                    continue block30;
                }
                case "minus-sign": {
                    ((DecimalSymbols)object2).setMinusSign(string2);
                    continue block30;
                }
                case "NaN": {
                    ((DecimalSymbols)object2).setNaN(string2);
                    continue block30;
                }
                case "percent": {
                    ((DecimalSymbols)object2).setPercent(string2);
                    continue block30;
                }
                case "per-mille": {
                    ((DecimalSymbols)object2).setPerMille(string2);
                    continue block30;
                }
                case "zero-digit": {
                    try {
                        ((DecimalSymbols)object2).setZeroDigit(string2);
                        continue block30;
                    }
                    catch (XPathException xPathException) {
                        object = xPathException;
                        xPathException.setErrorCode("XQST0097");
                        throw object;
                    }
                }
                case "digit": {
                    ((DecimalSymbols)object2).setDigit(string2);
                    continue block30;
                }
                case "pattern-separator": {
                    ((DecimalSymbols)object2).setPatternSeparator(string2);
                    continue block30;
                }
                case "exponent-separator": {
                    ((DecimalSymbols)object2).setExponentSeparator(string2);
                    continue block30;
                }
            }
            this.grumble("Unknown decimal-format property: " + string, "XPST0003", n3);
        }
        try {
            ((DecimalSymbols)object2).checkConsistency((StructuredQName)object);
            return;
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), "XQST0098", n2);
            return;
        }
    }

    private void p() {
        if (this.k) {
            this.grumble("default function namespace appears more than once", "XQST0066");
        }
        this.k = true;
        this.nextToken();
        this.expect(201);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default function', expected 'namespace'");
        }
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser = this;
        String string = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
        if (string.equals("http://www.w3.org/XML/1998/namespace") || string.equals("http://www.w3.org/2000/xmlns/")) {
            this.grumble("Reserved namespace used as default element/type namespace", "XQST0070");
        }
        ((QueryModule)this.env).setDefaultFunctionNamespace(string);
        this.nextToken();
    }

    private void q() {
        if (this.l) {
            this.grumble("default element namespace appears more than once", "XQST0066");
        }
        this.l = true;
        this.nextToken();
        this.expect(201);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default element', expected 'namespace'");
        }
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser = this;
        String string = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
        if (string.equals("http://www.w3.org/XML/1998/namespace") || string.equals("http://www.w3.org/2000/xmlns/")) {
            this.grumble("Reserved namespace used as default element/type namespace", "XQST0070");
        }
        ((QueryModule)this.env).setDefaultElementNamespace(string);
        this.nextToken();
    }

    private void r() {
        this.nextToken();
        this.expect(201);
        Object object = this.t.currentTokenValue;
        if (!NameChecker.isValidNCName((CharSequence)object)) {
            this.grumble("Invalid namespace prefix " + Err.wrap((CharSequence)object));
        }
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser = this;
        String string = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
        this.a((String)object, string);
        if ("xml".equals(object)) {
            this.grumble("Namespace prefix 'xml' cannot be declared", "XQST0070");
        }
        try {
            ((QueryModule)this.env).declarePrologNamespace((String)object, string);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.setLocator(this.makeLocation());
            this.a((XPathException)object);
        }
        this.nextToken();
    }

    private void a(String string, String string2) {
        if (string != null && !string.isEmpty() && !NameChecker.isValidNCName(string)) {
            this.grumble("The namespace prefix " + Err.wrap(string) + " is not a valid NCName");
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ("xmlns".equals(string)) {
            this.grumble("The namespace prefix 'xmlns' cannot be redeclared", "XQST0070");
        }
        if (string2.equals("http://www.w3.org/2000/xmlns/")) {
            this.grumble("The xmlns namespace URI is reserved", "XQST0070");
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace") && !string.equals("xml")) {
            this.grumble("The XML namespace cannot be bound to any prefix other than 'xml'", "XQST0070");
        }
        if (string.equals("xml") && !string2.equals("http://www.w3.org/XML/1998/namespace")) {
            this.grumble("The prefix 'xml' cannot be bound to any namespace other than http://www.w3.org/XML/1998/namespace", "XQST0070");
        }
    }

    private void a(AnnotationList object) {
        Object object2;
        int n2 = this.t.currentTokenStartOffset;
        Object object3 = new GlobalVariable();
        ((Actor)object3).setPackageData(this.env.getPackageData());
        ((Actor)object3).setLineNumber(this.t.getLineNumber() + 1);
        ((Actor)object3).setSystemId(this.env.getSystemId());
        if (object != null) {
            ((GlobalVariable)object3).setPrivate(((AnnotationList)object).includes(Annotation.PRIVATE));
        }
        this.nextToken();
        this.expect(21);
        this.t.setState(1);
        this.nextToken();
        this.expect(201);
        object = this.t.currentTokenValue;
        XQueryParser xQueryParser = this;
        StructuredQName structuredQName = xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, "");
        assert (structuredQName != null);
        ((GlobalVariable)object3).setVariableQName(structuredQName);
        String string = structuredQName.getURI();
        Object object4 = ((QueryModule)this.env).getModuleNamespace();
        if (object4 != null && !((String)object4).equals(string)) {
            this.grumble("A variable declared in a library module must be in the module namespace", "XQST0048", n2);
        }
        this.nextToken();
        object4 = SequenceType.ANY_SEQUENCE;
        if (this.t.currentToken == 71) {
            this.t.setState(2);
            this.nextToken();
            object4 = this.parseSequenceType();
        }
        ((GlobalVariable)object3).setRequiredType((SequenceType)object4);
        if (this.t.currentToken == 58) {
            this.t.setState(0);
            this.nextToken();
            object4 = this.parseExprSingle();
            ((GlobalVariable)object3).setSelectExpression(this.makeTracer(n2, (Expression)object4, 206, structuredQName));
        } else if (this.t.currentToken == 201) {
            if ("external".equals(this.t.currentTokenValue)) {
                object4 = new GlobalParam();
                ((Actor)object4).setPackageData(this.env.getPackageData());
                ((Actor)object4).setLineNumber(((Actor)object3).getLineNumber());
                ((Actor)object4).setSystemId(((Actor)object3).getSystemId());
                ((GlobalVariable)object4).setVariableQName(((GlobalVariable)object3).getVariableQName());
                ((GlobalVariable)object4).setRequiredType(((GlobalVariable)object3).getRequiredType());
                object3 = object4;
                this.nextToken();
                if (this.t.currentToken == 58) {
                    this.t.setState(0);
                    this.nextToken();
                    object2 = this.parseExprSingle();
                    ((GlobalVariable)object3).setSelectExpression(this.makeTracer(n2, (Expression)object2, 206, structuredQName));
                }
            } else {
                this.grumble("Variable must either be initialized or be declared as external");
            }
        } else {
            this.grumble("Expected ':=' or 'external' in variable declaration");
        }
        object4 = (QueryModule)this.env;
        object2 = this.env.makeRetainedStaticContext();
        ((Actor)object3).setRetainedStaticContext((RetainedStaticContext)object2);
        if (((Actor)object3).getBody() != null) {
            ExpressionTool.setDeepRetainedStaticContext(((Actor)object3).getBody(), (RetainedStaticContext)object2);
        }
        if (((QueryModule)object4).getModuleNamespace() != null && !string.equals(((QueryModule)object4).getModuleNamespace())) {
            this.grumble("Variable " + Err.wrap((CharSequence)object, 5) + " is not defined in the module namespace");
        }
        try {
            ((QueryModule)object4).declareVariable((GlobalVariable)object3);
            return;
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), -1);
            return;
        }
    }

    private void s() {
        Object object;
        Object object2;
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        if (!this.isKeyword("item")) {
            this.grumble("After 'declare context', expected 'item'");
        }
        if (this.n) {
            this.grumble("More than one context item declaration found", "XQST0099", n2);
        }
        this.n = true;
        GlobalContextRequirement globalContextRequirement = new GlobalContextRequirement();
        globalContextRequirement.setAbsentFocus(false);
        this.t.setState(1);
        this.nextToken();
        ItemType itemType = AnyItemType.getInstance();
        if (this.t.currentToken == 71) {
            this.t.setState(2);
            this.nextToken();
            itemType = this.parseItemType();
        }
        globalContextRequirement.addRequiredItemType(itemType);
        if (this.t.currentToken == 58) {
            if (!((QueryModule)this.env).isMainModule()) {
                this.grumble("The context item must not be initialized in a library module", "XQST0113");
            }
            this.t.setState(0);
            this.nextToken();
            object2 = this.parseExprSingle();
            ((Expression)object2).setRetainedStaticContext(this.env.makeRetainedStaticContext());
            object = new RoleDiagnostic(13, "context item declaration", 0);
            object2 = CardinalityChecker.makeCardinalityChecker((Expression)object2, 16384, (RoleDiagnostic)object);
            ExpressionVisitor expressionVisitor = ExpressionVisitor.make(this.env);
            object2 = ((Expression)object2).simplify();
            ContextItemStaticInfo object3 = this.env.getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), true);
            ((Expression)object2).setRetainedStaticContext(this.env.makeRetainedStaticContext());
            object2 = ((Expression)object2).typeCheck(expressionVisitor, object3);
            globalContextRequirement.setDefaultValue((Expression)object2);
            globalContextRequirement.setExternal(false);
        } else if (this.t.currentToken == 201 && "external".equals(this.t.currentTokenValue)) {
            globalContextRequirement.setAbsentFocus(false);
            globalContextRequirement.setExternal(true);
            this.nextToken();
            if (this.t.currentToken == 58) {
                if (!((QueryModule)this.env).isMainModule()) {
                    this.grumble("The context item must not be initialized in a library module", "XQST0113");
                }
                this.t.setState(0);
                this.nextToken();
                object2 = this.parseExprSingle();
                object = new RoleDiagnostic(13, "context item declaration", 0);
                object2 = CardinalityChecker.makeCardinalityChecker((Expression)object2, 16384, (RoleDiagnostic)object);
                ((Expression)object2).setRetainedStaticContext(this.env.makeRetainedStaticContext());
                globalContextRequirement.setDefaultValue((Expression)object2);
            }
        } else {
            this.grumble("Expected ':=' or 'external' in context item declaration");
        }
        object2 = this.getExecutable();
        if (((Executable)object2).getGlobalContextRequirement() != null) {
            object = ((Executable)object2).getGlobalContextRequirement();
            if (((GlobalContextRequirement)object).getDefaultValue() == null && globalContextRequirement.getDefaultValue() != null) {
                ((GlobalContextRequirement)object).setDefaultValue(globalContextRequirement.getDefaultValue());
            }
            for (ItemType itemType2 : ((GlobalContextRequirement)object).getRequiredItemTypes()) {
                TypeHierarchy typeHierarchy;
                int n3;
                if (itemType2 == AnyItemType.getInstance() || (n3 = (typeHierarchy = this.env.getConfiguration().getTypeHierarchy()).relationship(itemType, itemType2)) != 4) continue;
                this.grumble("Different modules specify incompatible requirements for the type of the initial context item", "XPTY0004");
            }
            ((GlobalContextRequirement)object).addRequiredItemType(itemType);
            return;
        }
        ((Executable)object2).setGlobalContextRequirement(globalContextRequirement);
    }

    public void parseFunctionDeclaration(AnnotationList iterable) {
        Object object;
        Object object2;
        Object object3;
        if (((AnnotationList)iterable).includes(SAXON_MEMO_FUNCTION)) {
            if (this.env.getConfiguration().getEditionCode().equals("HE")) {
                this.warning("saxon:memo-function option is ignored under Saxon-HE");
            } else {
                this.a = true;
            }
        }
        int n2 = this.t.currentTokenStartOffset;
        this.t.setState(0);
        this.nextToken();
        this.expect(35);
        if (this.t.currentTokenValue.indexOf(58) < 0) {
            object3 = this.env.getDefaultFunctionNamespace();
            object2 = new StructuredQName("", (String)object3, this.t.currentTokenValue);
        } else {
            XQueryParser xQueryParser = this;
            object2 = xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, "");
            object3 = object2.getURI();
        }
        if (((String)object3).isEmpty()) {
            this.grumble("The function must be in a namespace", "XQST0060");
        }
        if ((object = ((QueryModule)this.env).getModuleNamespace()) != null && !((String)object).equals(object3)) {
            this.grumble("A function in a library module must be in the module namespace", "XQST0048");
        }
        if (this.isReservedInQuery((String)object3)) {
            this.grumble("The function name " + this.t.currentTokenValue + " is in a reserved namespace", "XQST0045");
        }
        object3 = new XQueryFunction();
        ((XQueryFunction)object3).setFunctionName((StructuredQName)object2);
        ((XQueryFunction)object3).setResultType(SequenceType.ANY_SEQUENCE);
        ((XQueryFunction)object3).setBody(null);
        XQueryParser xQueryParser = this;
        Location location = xQueryParser.makeNestedLocation(xQueryParser.env.getContainingLocation(), this.t.getLineNumber(n2), this.t.getColumnNumber(n2), null);
        ((XQueryFunction)object3).setLocation(location);
        ((XQueryFunction)object3).setStaticContext((QueryModule)this.env);
        ((XQueryFunction)object3).setMemoFunction(this.a);
        ((XQueryFunction)object3).setUpdating(((AnnotationList)iterable).includes(Annotation.UPDATING));
        ((XQueryFunction)object3).setAnnotations((AnnotationList)iterable);
        this.nextToken();
        iterable = new HashSet(8);
        boolean bl2 = false;
        if (this.t.currentToken != 204) {
            while (true) {
                this.expect(21);
                this.nextToken();
                this.expect(201);
                XQueryParser xQueryParser2 = this;
                object2 = xQueryParser2.makeStructuredQName(xQueryParser2.t.currentTokenValue, "");
                if (((HashSet)iterable).contains(object2)) {
                    this.grumble("Duplicate parameter name " + Err.wrap(this.t.currentTokenValue, 5), "XQST0039");
                }
                ((HashSet)iterable).add((StructuredQName)object2);
                object = SequenceType.ANY_SEQUENCE;
                this.nextToken();
                if (this.t.currentToken == 71) {
                    this.nextToken();
                    object = this.parseSequenceType();
                }
                UserFunctionParameter userFunctionParameter = new UserFunctionParameter();
                userFunctionParameter.setRequiredType((SequenceType)object);
                userFunctionParameter.setVariableQName((StructuredQName)object2);
                ((XQueryFunction)object3).addArgument(userFunctionParameter);
                this.declareRangeVariable(userFunctionParameter);
                if (this.t.currentToken == 204) break;
                if (this.t.currentToken == 7) {
                    this.nextToken();
                    continue;
                }
                this.grumble("Expected ',' or ')' after function argument, found '" + Token.tokens[this.t.currentToken] + '\'');
            }
        }
        this.t.setState(1);
        this.nextToken();
        if (this.t.currentToken == 71) {
            if (((XQueryFunction)object3).isUpdating()) {
                this.grumble("Cannot specify a return type for an updating function", "XUST0028");
            }
            this.t.setState(2);
            this.nextToken();
            ((XQueryFunction)object3).setResultType(this.parseSequenceType());
        }
        if (this.isKeyword("external")) {
            bl2 = true;
        } else {
            this.expect(59);
            this.t.setState(0);
            this.nextToken();
            if (this.t.currentToken == 215) {
                object2 = Literal.makeEmptySequence();
                object2.setRetainedStaticContext(this.env.makeRetainedStaticContext());
                this.setLocation((Expression)object2);
                ((XQueryFunction)object3).setBody((Expression)object2);
            } else {
                object2 = this.parseExpression();
                ((XQueryFunction)object3).setBody((Expression)object2);
                ExpressionTool.setDeepRetainedStaticContext((Expression)object2, this.env.makeRetainedStaticContext());
            }
            this.expect(215);
            this.lookAhead();
        }
        object2 = ((XQueryFunction)object3).getParameterDefinitions();
        object = object2;
        int n3 = ((UserFunctionParameter[])object2).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            UserFunctionParameter cfr_ignored_0 = object[i2];
            this.undeclareRangeVariable();
        }
        this.t.setState(0);
        this.nextToken();
        object = (QueryModule)this.env;
        if (bl2) {
            this.parserExtension.handleExternalFunctionDeclaration(this, (XQueryFunction)object3);
        } else {
            try {
                ((QueryModule)object).declareFunction((XQueryFunction)object3);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), -1);
            }
        }
        this.a = false;
    }

    protected void parseTypeAliasDeclaration() {
        this.parserExtension.parseTypeAliasDeclaration(this);
    }

    private void t() {
        this.nextToken();
        this.expect(201);
        Object object = "http://www.w3.org/2012/xquery";
        XQueryParser xQueryParser = this;
        object = xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, (String)object);
        assert (object != null);
        String string = ((StructuredQName)object).getURI();
        if (string.isEmpty()) {
            this.grumble("The QName identifying an option declaration must be prefixed", "XPST0081");
            return;
        }
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser2 = this;
        String string2 = xQueryParser2.unescape(xQueryParser2.t.currentTokenValue).toString();
        if (string.equals("http://www.w3.org/2010/xslt-xquery-serialization")) {
            this.parseOutputDeclaration((StructuredQName)object, string2);
        } else if (string.equals("http://saxon.sf.net/")) {
            block5 : switch (((StructuredQName)object).getLocalPart()) {
                case "output": {
                    this.c(string2);
                    break;
                }
                case "memo-function": {
                    string2 = string2.trim();
                    switch (string2) {
                        case "true": {
                            this.a = true;
                            if (!this.env.getConfiguration().getEditionCode().equals("HE")) break block5;
                            this.warning("saxon:memo-function option is ignored under Saxon-HE");
                            break;
                        }
                        case "false": {
                            this.a = false;
                            break;
                        }
                        default: {
                            this.warning("Value of saxon:memo-function must be 'true' or 'false'");
                            break;
                        }
                    }
                    break;
                }
                case "allow-cycles": {
                    this.warning("Value of saxon:allow-cycles is ignored");
                    break;
                }
                default: {
                    this.warning("Unknown Saxon option declaration: " + ((StructuredQName)object).getDisplayName());
                }
            }
        }
        this.nextToken();
    }

    protected void parseOutputDeclaration(StructuredQName object, String object2) {
        if (!((QueryModule)this.env).isMainModule()) {
            this.grumble("Output declarations must not appear in a library module", "XQST0108");
        }
        String string = ((StructuredQName)object).getLocalPart();
        if (this.u.contains(object)) {
            this.grumble("Duplicate output declaration (" + object + ")", "XQST0110");
        }
        this.u.add((StructuredQName)object);
        switch (string) {
            case "parameter-document": {
                try {
                    object = this.env.getConfiguration().getURIResolver().resolve((String)object2, this.env.getStaticBaseURI());
                }
                catch (TransformerException transformerException) {
                    object2 = transformerException;
                    throw XPathException.makeXPathException(transformerException);
                }
                object2 = new ParseOptions();
                ((ParseOptions)object2).setSchemaValidationMode(2);
                object = this.env.getConfiguration().buildDocumentTree((Source)object);
                object2 = new SerializationParamsHandler(this.v);
                ((SerializationParamsHandler)object2).setSerializationParams(object.getRootNode());
                object = ((SerializationParamsHandler)object2).getCharacterMap();
                if (object == null) break;
                object2 = new CharacterMapIndex();
                ((CharacterMapIndex)object2).putCharacterMap(((CharacterMap)object).getName(), (CharacterMap)object);
                this.getExecutable().setCharacterMapIndex((CharacterMapIndex)object2);
                this.v.setProperty("use-character-maps", ((CharacterMap)object).getName().getClarkName());
                return;
            }
            case "use-character-maps": {
                this.grumble("Output declaration use-character-maps cannot appear except in a parameter file", "XQST0109");
                return;
            }
            default: {
                object = this.getExecutable().getPrimarySerializationProperties().getProperties();
                ResultDocument.setSerializationProperty((Properties)object, "", string, (String)object2, this.env.getNamespaceResolver(), false, this.env.getConfiguration());
            }
        }
    }

    private void c(String string) {
        int n2 = string.indexOf("=");
        if (n2 < 0) {
            this.d("no equals sign");
        } else if (n2 == 0) {
            this.d("starts with '=");
        }
        Object object = Whitespace.trim(string.substring(0, n2));
        string = n2 == string.length() - 1 ? "" : Whitespace.trim(string.substring(n2 + 1));
        Properties properties = this.getExecutable().getPrimarySerializationProperties().getProperties();
        try {
            object = this.makeStructuredQName((String)object, "");
            String string2 = ((StructuredQName)object).getLocalPart();
            object = ((StructuredQName)object).getURI();
            ResultDocument.setSerializationProperty(properties, (String)object, string2, string, this.env.getNamespaceResolver(), false, this.env.getConfiguration());
            return;
        }
        catch (XPathException xPathException) {
            this.d(xPathException.getMessage());
            return;
        }
    }

    private void d(String string) {
        this.warning("Invalid serialization property (" + string + ")");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Expression parseFLWORExpression() {
        ArrayList<c> arrayList;
        int n2;
        FLWORExpression fLWORExpression = new FLWORExpression();
        int n3 = this.t.currentTokenStartOffset;
        ArrayList<Clause> arrayList2 = new ArrayList<Clause>(4);
        while (true) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object7;
            n2 = this.t.currentTokenStartOffset;
            if (this.t.currentToken == 211) {
                ArrayList<Clause> arrayList3 = arrayList2;
                arrayList = fLWORExpression;
                object7 = this;
                boolean bl2 = true;
                do {
                    SequenceType sequenceType;
                    ForClause i5 = new ForClause();
                    i5.setRepeated(!bl2 || XQueryParser.containsLoopingClause(arrayList3));
                    ((XPathParser)object7).setLocation(i5, ((XPathParser)object7).t.currentTokenStartOffset);
                    arrayList3.add(i5);
                    ((XPathParser)object7).nextToken();
                    if (bl2) {
                        bl2 = false;
                    }
                    ((XPathParser)object7).expect(21);
                    ((XPathParser)object7).nextToken();
                    ((XPathParser)object7).expect(201);
                    XQueryParser xQueryParser = object7;
                    object5 = xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, "");
                    object4 = SequenceType.SINGLE_ITEM;
                    ((XPathParser)object7).nextToken();
                    boolean bl3 = false;
                    if (((XPathParser)object7).t.currentToken == 71) {
                        bl3 = true;
                        ((XPathParser)object7).nextToken();
                        object4 = ((XPathParser)object7).parseSequenceType();
                    }
                    boolean bl4 = false;
                    if (((XPathParser)object7).isKeyword("allowing")) {
                        bl4 = true;
                        i5.setAllowingEmpty(true);
                        if (!bl3) {
                            object4 = SequenceType.OPTIONAL_ITEM;
                        }
                        ((XPathParser)object7).nextToken();
                        if (!((XPathParser)object7).isKeyword("empty")) {
                            ((XPathParser)object7).grumble("After 'allowing', expected 'empty'");
                        }
                        ((XPathParser)object7).nextToken();
                    }
                    if (bl3 && !bl4 && ((SequenceType)object4).getCardinality() != 16384) {
                        ((XPathParser)object7).warning("Occurrence indicator on singleton range variable has no effect");
                        object4 = SequenceType.makeSequenceType(((SequenceType)object4).getPrimaryType(), 16384);
                    }
                    object3 = new LocalVariableBinding((StructuredQName)object5, (SequenceType)object4);
                    i5.setRangeVariable((LocalVariableBinding)object3);
                    if (((XPathParser)object7).isKeyword("at")) {
                        ((XPathParser)object7).nextToken();
                        ((XPathParser)object7).expect(21);
                        ((XPathParser)object7).nextToken();
                        ((XPathParser)object7).expect(201);
                        Object object6 = object7;
                        object2 = ((XPathParser)object6).makeStructuredQName(((XPathParser)object6).t.currentTokenValue, "");
                        if (!((XPathParser)object7).scanOnly && ((StructuredQName)object2).equals(object5)) {
                            ((XPathParser)object7).grumble("The two variables declared in a single 'for' clause must have different names", "XQST0089");
                        }
                        object = new LocalVariableBinding((StructuredQName)object2, SequenceType.SINGLE_INTEGER);
                        i5.setPositionVariable((LocalVariableBinding)object);
                        ((XPathParser)object7).nextToken();
                    }
                    ((XPathParser)object7).expect(31);
                    ((XPathParser)object7).nextToken();
                    i5.initSequence((FLWORExpression)((Object)arrayList), ((XPathParser)object7).parseExprSingle());
                    ((XPathParser)object7).declareRangeVariable(i5.getRangeVariable());
                    if (i5.getPositionVariable() != null) {
                        ((XPathParser)object7).declareRangeVariable(i5.getPositionVariable());
                    }
                    if (!bl4) continue;
                    Object object8 = object7;
                    if (!((XPathParser)object8).allowXPath30Syntax) {
                        ((XPathParser)object8).grumble("The 'allowing empty' option requires XQuery 3.0");
                    }
                    if (Cardinality.allowsZero((sequenceType = i5.getRangeVariable().getRequiredType()).getCardinality())) continue;
                    ((XPathParser)object8).warning("When 'allowing empty' is specified, the occurrence indicator on the range variable type should be '?'");
                } while (((XPathParser)object7).t.currentToken == 7);
            } else if (this.t.currentToken == 216) {
                ArrayList<Clause> i7 = arrayList2;
                arrayList = fLWORExpression;
                object7 = this;
                do {
                    LetClause orderByClause = new LetClause();
                    ((XPathParser)object7).setLocation(orderByClause, ((XPathParser)object7).t.currentTokenStartOffset);
                    orderByClause.setRepeated(XQueryParser.containsLoopingClause(i7));
                    i7.add(orderByClause);
                    ((XPathParser)object7).nextToken();
                    ((XPathParser)object7).expect(21);
                    ((XPathParser)object7).nextToken();
                    ((XPathParser)object7).expect(201);
                    object5 = ((XPathParser)object7).t.currentTokenValue;
                    object4 = ((XPathParser)object7).makeStructuredQName((String)object5, "");
                    SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
                    ((XPathParser)object7).nextToken();
                    if (((XPathParser)object7).t.currentToken == 71) {
                        ((XPathParser)object7).nextToken();
                        sequenceType = ((XPathParser)object7).parseSequenceType();
                    }
                    LocalVariableBinding localVariableBinding = new LocalVariableBinding((StructuredQName)object4, sequenceType);
                    ((XPathParser)object7).expect(58);
                    ((XPathParser)object7).nextToken();
                    orderByClause.initSequence((FLWORExpression)((Object)arrayList), ((XPathParser)object7).parseExprSingle());
                    orderByClause.setRangeVariable(localVariableBinding);
                    ((XPathParser)object7).declareRangeVariable(localVariableBinding);
                } while (((XPathParser)object7).t.currentToken == 7);
            } else if (this.t.currentToken == 220) {
                arrayList = arrayList2;
                object7 = this;
                do {
                    CountClause clause = new CountClause();
                    ((XPathParser)object7).setLocation(clause, ((XPathParser)object7).t.currentTokenStartOffset);
                    clause.setRepeated(XQueryParser.containsLoopingClause((List<Clause>)arrayList));
                    arrayList.add((c)((Object)clause));
                    ((XPathParser)object7).nextToken();
                    ((XPathParser)object7).expect(21);
                    ((XPathParser)object7).nextToken();
                    ((XPathParser)object7).expect(201);
                    String string = ((XPathParser)object7).t.currentTokenValue;
                    StructuredQName structuredQName = ((XPathParser)object7).makeStructuredQName(string, "");
                    object5 = SequenceType.ANY_SEQUENCE;
                    ((XPathParser)object7).nextToken();
                    object4 = new LocalVariableBinding(structuredQName, (SequenceType)object5);
                    clause.setRangeVariable((LocalVariableBinding)object4);
                    ((XPathParser)object7).declareRangeVariable((LocalBinding)object4);
                } while (((XPathParser)object7).t.currentToken == 7);
            } else if (this.t.currentToken == 72) {
                int n4;
                void var17_69;
                int n5;
                int n6;
                IdentityComparable identityComparable;
                ArrayList<Clause> arrayList4 = arrayList2;
                arrayList = fLWORExpression;
                object7 = this;
                GroupByClause groupByClause = new GroupByClause(((XPathParser)object7).env.getConfiguration());
                ((XPathParser)object7).setLocation(groupByClause, ((XPathParser)object7).t.currentTokenStartOffset);
                groupByClause.setRepeated(XQueryParser.containsLoopingClause(arrayList4));
                ArrayList<StructuredQName> arrayList5 = new ArrayList<StructuredQName>();
                object5 = new ArrayList();
                ((XPathParser)object7).nextToken();
                while (true) {
                    object4 = SequenceType.ANY_SEQUENCE;
                    identityComparable = super.u();
                    if (((XPathParser)object7).t.currentToken == 71) {
                        ((XPathParser)object7).nextToken();
                        object4 = ((XPathParser)object7).parseSequenceType();
                        if (((XPathParser)object7).t.currentToken != 58) {
                            ((XPathParser)object7).grumble("In group by, if the type is declared then it must be followed by ':= value'");
                        }
                    }
                    if (((XPathParser)object7).t.currentToken == 58) {
                        LetClause letClause = new LetClause();
                        arrayList4.add(letClause);
                        ((XPathParser)object7).nextToken();
                        object3 = new LocalVariableBinding((StructuredQName)identityComparable, (SequenceType)object4);
                        object2 = ((XPathParser)object7).parseExprSingle();
                        object = new RoleDiagnostic(20, "grouping key", 0);
                        Expression expression = Atomizer.makeAtomizer((Expression)object2, (RoleDiagnostic)object);
                        letClause.initSequence((FLWORExpression)((Object)arrayList), expression);
                        letClause.setRangeVariable((LocalVariableBinding)object3);
                        ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                    }
                    arrayList5.add((StructuredQName)identityComparable);
                    if (((XPathParser)object7).isKeyword("collation")) {
                        ((XPathParser)object7).nextToken();
                        ((XPathParser)object7).expect(202);
                        object5.add(((XPathParser)object7).t.currentTokenValue);
                        ((XPathParser)object7).nextToken();
                    } else {
                        object5.add(((XPathParser)object7).env.getDefaultCollationName());
                    }
                    if (((XPathParser)object7).t.currentToken != 7) break;
                    ((XPathParser)object7).nextToken();
                }
                object4 = new TupleExpression();
                identityComparable = new TupleExpression();
                ArrayList<LocalVariableReference> arrayList6 = new ArrayList<LocalVariableReference>();
                object3 = new ArrayList();
                object2 = new ArrayList();
                for (StructuredQName structuredQName : arrayList5) {
                    boolean bl5 = false;
                    block6: for (n6 = arrayList4.size() - 1; n6 >= 0; --n6) {
                        LocalVariableBinding[] localVariableBindingArray = ((Clause)arrayList4.get(n6)).getRangeVariables();
                        n5 = localVariableBindingArray.length;
                        for (int i2 = 0; i2 < n5; ++i2) {
                            LocalVariableBinding localVariableBinding = localVariableBindingArray[i2];
                            if (!structuredQName.equals(localVariableBinding.getVariableQName())) continue;
                            object2.add(localVariableBinding);
                            arrayList6.add(new LocalVariableReference(localVariableBinding));
                            bl5 = true;
                            break block6;
                        }
                    }
                    if (bl5) continue;
                    ((XPathParser)object7).grumble("The grouping variable " + structuredQName.getDisplayName() + " must be the name of a variable bound earlier in the FLWOR expression", "XQST0094");
                }
                ((TupleExpression)object4).setVariables(arrayList6);
                groupByClause.initGroupingTupleExpression((FLWORExpression)((Object)arrayList), (TupleExpression)object4);
                object = new ArrayList();
                int n7 = arrayList4.size() - 1;
                while (var17_69 >= 0) {
                    LocalVariableBinding[] localVariableBindingArray = ((Clause)arrayList4.get((int)var17_69)).getRangeVariables();
                    n6 = localVariableBindingArray.length;
                    for (int i3 = 0; i3 < n6; ++i3) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[i3];
                        if (object2.contains(localVariableBinding)) continue;
                        object.add(localVariableBinding);
                        object3.add(new LocalVariableReference(localVariableBinding));
                    }
                    --var17_69;
                }
                ((TupleExpression)identityComparable).setVariables((List<LocalVariableReference>)object3);
                groupByClause.initRetainedTupleExpression((FLWORExpression)((Object)arrayList), (TupleExpression)identityComparable);
                LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[object2.size() + object.size()];
                int n8 = 0;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    LocalVariableBinding localVariableBinding = (LocalVariableBinding)iterator.next();
                    localVariableBindingArray[n8] = new LocalVariableBinding(localVariableBinding.getVariableQName(), localVariableBinding.getRequiredType());
                    ++n8;
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    LocalVariableBinding localVariableBinding = (LocalVariableBinding)iterator.next();
                    ItemType itemType = localVariableBinding.getRequiredType().getPrimaryType();
                    localVariableBindingArray[n8] = new LocalVariableBinding(localVariableBinding.getVariableQName(), SequenceType.makeSequenceType(itemType, 57344));
                    ++n8;
                }
                for (n4 = object2.size(); n4 < localVariableBindingArray.length; ++n4) {
                    ((XPathParser)object7).declareRangeVariable(localVariableBindingArray[n4]);
                }
                for (n4 = 0; n4 < object2.size(); ++n4) {
                    ((XPathParser)object7).declareRangeVariable(localVariableBindingArray[n4]);
                }
                groupByClause.setVariableBindings(localVariableBindingArray);
                GenericAtomicComparer[] genericAtomicComparerArray = new GenericAtomicComparer[object5.size()];
                XPathContext xPathContext = ((XPathParser)object7).env.makeEarlyEvaluationContext();
                for (n5 = 0; n5 < genericAtomicComparerArray.length; ++n5) {
                    StringCollator stringCollator = ((XPathParser)object7).env.getConfiguration().getCollation((String)object5.get(n5));
                    BuiltInAtomicType builtInAtomicType = BuiltInAtomicType.ANY_ATOMIC;
                    genericAtomicComparerArray[n5] = (GenericAtomicComparer)GenericAtomicComparer.makeAtomicComparer(builtInAtomicType, builtInAtomicType, stringCollator, xPathContext);
                }
                groupByClause.setComparers(genericAtomicComparerArray);
                arrayList4.add(groupByClause);
            } else if (this.t.currentToken == 73 || this.t.currentToken == 74) {
                ArrayList<Clause> arrayList7 = arrayList2;
                arrayList = fLWORExpression;
                object7 = this;
                WindowClause windowClause = new WindowClause();
                ((XPathParser)object7).setLocation(windowClause, ((XPathParser)object7).t.currentTokenStartOffset);
                windowClause.setRepeated(XQueryParser.containsLoopingClause(arrayList7));
                windowClause.setIsSlidingWindow(((XPathParser)object7).t.currentToken == 74);
                ((XPathParser)object7).nextToken();
                if (!((XPathParser)object7).isKeyword("window")) {
                    ((XPathParser)object7).grumble("after 'sliding' or 'tumbling', expected 'window', but found " + ((XPathParser)object7).currentTokenDisplay());
                }
                ((XPathParser)object7).nextToken();
                StructuredQName structuredQName = super.u();
                object5 = SequenceType.ANY_SEQUENCE;
                if (((XPathParser)object7).t.currentToken == 71) {
                    ((XPathParser)object7).nextToken();
                    object5 = ((XPathParser)object7).parseSequenceType();
                }
                object4 = new LocalVariableBinding(structuredQName, (SequenceType)object5);
                windowClause.setVariableBinding(0, (LocalVariableBinding)object4);
                SequenceType sequenceType = SequenceType.SINGLE_ITEM;
                SequenceType sequenceType2 = SequenceType.OPTIONAL_ITEM;
                ((XPathParser)object7).expect(31);
                ((XPathParser)object7).nextToken();
                windowClause.initSequence((FLWORExpression)((Object)arrayList), ((XPathParser)object7).parseExprSingle());
                if (!((XPathParser)object7).isKeyword("start")) {
                    ((XPathParser)object7).grumble("in window clause, expected 'start', but found " + ((XPathParser)object7).currentTokenDisplay());
                }
                ((XPathParser)object7).t.setState(1);
                ((XPathParser)object7).nextToken();
                if (((XPathParser)object7).t.currentToken == 21) {
                    object3 = new LocalVariableBinding(super.u(), sequenceType);
                    windowClause.setVariableBinding(1, (LocalVariableBinding)object3);
                    ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                }
                if (((XPathParser)object7).isKeyword("at")) {
                    ((XPathParser)object7).nextToken();
                    object3 = new LocalVariableBinding(super.u(), SequenceType.SINGLE_INTEGER);
                    windowClause.setVariableBinding(2, (LocalVariableBinding)object3);
                    ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                }
                if (((XPathParser)object7).isKeyword("previous")) {
                    ((XPathParser)object7).nextToken();
                    object3 = new LocalVariableBinding(super.u(), sequenceType2);
                    windowClause.setVariableBinding(3, (LocalVariableBinding)object3);
                    ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                }
                if (((XPathParser)object7).isKeyword("next")) {
                    ((XPathParser)object7).nextToken();
                    object3 = new LocalVariableBinding(super.u(), sequenceType2);
                    windowClause.setVariableBinding(4, (LocalVariableBinding)object3);
                    ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                }
                if (!((XPathParser)object7).isKeyword("when")) {
                    ((XPathParser)object7).grumble("Expected 'when' condition for window start, but found " + ((XPathParser)object7).currentTokenDisplay());
                }
                ((XPathParser)object7).t.setState(0);
                ((XPathParser)object7).nextToken();
                windowClause.initStartCondition((FLWORExpression)((Object)arrayList), ((XPathParser)object7).parseExprSingle());
                if (((XPathParser)object7).isKeyword("only")) {
                    windowClause.setIncludeUnclosedWindows(false);
                    ((XPathParser)object7).nextToken();
                }
                if (((XPathParser)object7).isKeyword("end")) {
                    ((XPathParser)object7).t.setState(1);
                    ((XPathParser)object7).nextToken();
                    if (((XPathParser)object7).t.currentToken == 21) {
                        object3 = new LocalVariableBinding(super.u(), sequenceType);
                        windowClause.setVariableBinding(5, (LocalVariableBinding)object3);
                        ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                    }
                    if (((XPathParser)object7).isKeyword("at")) {
                        ((XPathParser)object7).nextToken();
                        object3 = new LocalVariableBinding(super.u(), SequenceType.SINGLE_INTEGER);
                        windowClause.setVariableBinding(6, (LocalVariableBinding)object3);
                        ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                    }
                    if (((XPathParser)object7).isKeyword("previous")) {
                        ((XPathParser)object7).nextToken();
                        object3 = new LocalVariableBinding(super.u(), sequenceType2);
                        windowClause.setVariableBinding(7, (LocalVariableBinding)object3);
                        ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                    }
                    if (((XPathParser)object7).isKeyword("next")) {
                        ((XPathParser)object7).nextToken();
                        object3 = new LocalVariableBinding(super.u(), sequenceType2);
                        windowClause.setVariableBinding(8, (LocalVariableBinding)object3);
                        ((XPathParser)object7).declareRangeVariable((LocalBinding)object3);
                    }
                    if (!((XPathParser)object7).isKeyword("when")) {
                        ((XPathParser)object7).grumble("Expected 'when' condition for window end, but found " + ((XPathParser)object7).currentTokenDisplay());
                    }
                    ((XPathParser)object7).t.setState(0);
                    ((XPathParser)object7).nextToken();
                    windowClause.initEndCondition((FLWORExpression)((Object)arrayList), ((XPathParser)object7).parseExprSingle());
                } else if (windowClause.isSlidingWindow()) {
                    ((XPathParser)object7).grumble("A sliding window requires an end condition");
                }
                ((XPathParser)object7).declareRangeVariable((LocalBinding)object4);
                arrayList7.add(windowClause);
            } else if (this.t.currentToken == 28 || this.isKeyword("where")) {
                this.nextToken();
                Expression expression = this.parseExprSingle();
                object7 = new WhereClause(fLWORExpression, expression);
                ((Clause)object7).setRepeated(XQueryParser.containsLoopingClause(arrayList2));
                arrayList2.add((Clause)object7);
            } else {
                if (!this.isKeyword("stable") && !this.isKeyword("order")) break;
                if (this.isKeyword("stable")) {
                    this.nextToken();
                    if (!this.isKeyword("order")) {
                        this.grumble("'stable' must be followed by 'order by'");
                    }
                }
                TupleExpression tupleExpression = new TupleExpression();
                object7 = new ArrayList<LocalVariableReference>();
                for (Clause clause : arrayList2) {
                    for (LocalVariableBinding localVariableBinding : clause.getRangeVariables()) {
                        object7.add((LocalVariableReference)new LocalVariableReference(localVariableBinding));
                    }
                }
                tupleExpression.setVariables((List<LocalVariableReference>)object7);
                this.t.setState(1);
                this.nextToken();
                if (!this.isKeyword("by")) {
                    this.grumble("'order' must be followed by 'by'");
                }
                this.t.setState(0);
                this.nextToken();
                object7 = this;
                arrayList = new ArrayList<c>(5);
                while (true) {
                    c c2 = new c(0);
                    new c(0).a = ((XPathParser)object7).parseExprSingle();
                    c2.b = true;
                    c2.c = ((QueryModule)((XPathParser)object7).env).isEmptyLeast();
                    c2.d = ((XPathParser)object7).env.getDefaultCollationName();
                    if (((XPathParser)object7).isKeyword("ascending")) {
                        ((XPathParser)object7).nextToken();
                    } else if (((XPathParser)object7).isKeyword("descending")) {
                        c2.b = false;
                        ((XPathParser)object7).nextToken();
                    }
                    if (((XPathParser)object7).isKeyword("empty")) {
                        ((XPathParser)object7).nextToken();
                        if (((XPathParser)object7).isKeyword("greatest")) {
                            c2.c = false;
                            ((XPathParser)object7).nextToken();
                        } else if (((XPathParser)object7).isKeyword("least")) {
                            c2.c = true;
                            ((XPathParser)object7).nextToken();
                        } else {
                            ((XPathParser)object7).grumble("'empty' must be followed by 'greatest' or 'least'");
                        }
                    }
                    if (((XPathParser)object7).isKeyword("collation")) {
                        c2.d = ((XQueryParser)object7).readCollationName();
                    }
                    arrayList.add(c2);
                    if (((XPathParser)object7).t.currentToken != 7) break;
                    ((XPathParser)object7).nextToken();
                }
                SortKeyDefinition[] sortKeyDefinitionArray = new SortKeyDefinition[arrayList.size()];
                for (int i4 = 0; i4 < sortKeyDefinitionArray.length; ++i4) {
                    c c3 = (c)arrayList.get(i4);
                    SortKeyDefinition sortKeyDefinition = new SortKeyDefinition();
                    sortKeyDefinition.setSortKey(((c)arrayList.get((int)i4)).a, false);
                    sortKeyDefinition.setOrder(new StringLiteral(c3.b ? "ascending" : "descending"));
                    sortKeyDefinition.setEmptyLeast(c3.c);
                    if (c3.d != null) {
                        StringCollator stringCollator = this.env.getConfiguration().getCollation(c3.d);
                        if (stringCollator == null) {
                            this.grumble("Unknown collation '" + c3.d + '\'', "XQST0076");
                        }
                        sortKeyDefinition.setCollation(stringCollator);
                    }
                    sortKeyDefinitionArray[i4] = sortKeyDefinition;
                }
                OrderByClause orderByClause = new OrderByClause(fLWORExpression, sortKeyDefinitionArray, tupleExpression);
                orderByClause.setRepeated(XQueryParser.containsLoopingClause(arrayList2));
                arrayList2.add(orderByClause);
            }
            ArrayList<Clause> arrayList8 = arrayList2;
            this.setLocation((Clause)arrayList8.get(arrayList8.size() - 1), n2);
        }
        n2 = this.t.currentTokenStartOffset;
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Expression expression = this.parseExprSingle();
        expression = this.makeTracer(n2, expression, 2014, null);
        for (int i6 = arrayList2.size() - 1; i6 >= 0; --i6) {
            arrayList = (Clause)arrayList2.get(i6);
            for (int i5 = 0; i5 < ((Clause)((Object)arrayList)).getRangeVariables().length; ++i5) {
                this.undeclareRangeVariable();
            }
        }
        if (this.codeInjector != null) {
            ArrayList arrayList6 = new ArrayList(arrayList2.size() << 1);
            arrayList6.add(arrayList2.get(0));
            for (int i8 = 1; i8 < arrayList2.size(); ++i8) {
                Clause clause = this.codeInjector.injectClause((Clause)arrayList2.get(i8 - 1), this.env);
                if (clause != null) {
                    arrayList6.add(clause);
                }
                arrayList6.add(arrayList2.get(i8));
            }
            ArrayList<Clause> arrayList9 = arrayList2;
            Clause clause = this.codeInjector.injectClause((Clause)arrayList9.get(arrayList9.size() - 1), this.env);
            if (clause != null) {
                arrayList6.add(clause);
            }
            arrayList2 = arrayList6;
        }
        fLWORExpression.init(arrayList2, expression);
        this.setLocation(fLWORExpression, n3);
        return fLWORExpression;
    }

    protected LetExpression makeLetExpression() {
        if (((QueryModule)this.env).getUserQueryContext().isCompileWithTracing()) {
            return new EagerLetExpression();
        }
        return new LetExpression();
    }

    protected static boolean containsLoopingClause(List<Clause> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Clause clause = (Clause)object.next();
            if (!FLWORExpression.isLoopingClause(clause)) continue;
            return true;
        }
        return false;
    }

    private StructuredQName u() {
        this.expect(21);
        this.nextToken();
        this.expect(201);
        String string = this.t.currentTokenValue;
        this.nextToken();
        return this.makeStructuredQName(string, "");
    }

    public static Expression makeStringJoin(Expression expression, StaticContext object) {
        ItemType itemType = (expression = Atomizer.makeAtomizer(expression, null)).getItemType();
        if (!itemType.equals(BuiltInAtomicType.STRING) && !itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            expression = new AtomicSequenceConverter(expression, BuiltInAtomicType.STRING);
            ((AtomicSequenceConverter)expression).allocateConverterStatically(object.getConfiguration(), false);
        }
        if (expression.getCardinality() == 16384) {
            return expression;
        }
        object = new RetainedStaticContext((StaticContext)object);
        object = SystemFunction.makeCall("string-join", (RetainedStaticContext)object, expression, new StringLiteral(StringValue.SINGLE_SPACE));
        ExpressionTool.copyLocationInfo(expression, (Expression)object);
        return object;
    }

    protected String readCollationName() {
        this.nextToken();
        this.expect(202);
        XQueryParser xQueryParser = this;
        String string = xQueryParser.uriLiteral(xQueryParser.t.currentTokenValue);
        try {
            URI uRI = new URI(string);
            if (!uRI.isAbsolute()) {
                URI uRI2 = new URI(this.env.getStaticBaseURI());
                uRI = uRI2.resolve(uRI);
                string = uRI.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.grumble("Collation name '" + string + "' is not a valid URI", "XQST0046");
            string = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        }
        this.nextToken();
        return string;
    }

    @Override
    protected Expression parseTypeswitchExpression() {
        Object object;
        IdentityComparable identityComparable;
        Object object2;
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression expression = this.parseExpression();
        ArrayList<List<SequenceType>> arrayList = new ArrayList<List<SequenceType>>(10);
        ArrayList<List<SequenceType>> arrayList2 = new ArrayList<List<SequenceType>>(10);
        this.expect(204);
        this.nextToken();
        LetExpression letExpression = this.makeLetExpression();
        letExpression.setRequiredType(SequenceType.ANY_SEQUENCE);
        letExpression.setVariableQName(new StructuredQName("zz", "http://saxon.sf.net/", "zz_typeswitchVar"));
        letExpression.setSequence(expression);
        while (this.t.currentToken == 67) {
            int n3 = this.t.currentTokenStartOffset;
            this.nextToken();
            if (this.t.currentToken == 21) {
                this.nextToken();
                this.expect(201);
                object2 = this.t.currentTokenValue;
                identityComparable = this.makeStructuredQName((String)object2, "");
                this.nextToken();
                this.expect(71);
                this.nextToken();
                object2 = this.v();
                object = this.makeTracer(n3, this.a((StructuredQName)identityComparable, letExpression), 2021, (StructuredQName)identityComparable);
                if (object instanceof TraceExpression) {
                    ((TraceExpression)object).setProperty("type", ((SequenceType)object2.get(0)).toString());
                }
            } else {
                object2 = this.v();
                object = this.makeTracer(n3, this.parseExprSingle(), 2021, null);
                if (object instanceof TraceExpression) {
                    ((TraceExpression)object).setProperty("type", ((SequenceType)object2.get(0)).toString());
                }
            }
            arrayList.add((List<SequenceType>)object2);
            arrayList2.add((List<SequenceType>)object);
        }
        if (arrayList.isEmpty()) {
            this.grumble("At least one case clause is required in a typeswitch");
        }
        this.expect(212);
        int n4 = this.t.currentTokenStartOffset;
        this.nextToken();
        if (this.t.currentToken == 21) {
            this.nextToken();
            this.expect(201);
            object = this.t.currentTokenValue;
            object2 = this.makeStructuredQName((String)object, "");
            this.nextToken();
            this.expect(25);
            this.nextToken();
            object2 = this.makeTracer(n4, this.a((StructuredQName)object2, letExpression), 2022, (StructuredQName)object2);
        } else {
            this.t.treatCurrentAsOperator();
            this.expect(25);
            this.nextToken();
            object2 = this.makeTracer(n4, this.parseExprSingle(), 2022, null);
        }
        object = object2;
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            identityComparable = new LocalVariableReference(letExpression);
            this.setLocation((Expression)identityComparable);
            Expression expression2 = new InstanceOfExpression((Expression)identityComparable, (SequenceType)((List)arrayList.get(i2)).get(0));
            for (int i3 = 1; i3 < ((List)arrayList.get(i2)).size(); ++i3) {
                expression2 = new OrExpression(expression2, new InstanceOfExpression(((Expression)identityComparable).copy(new RebindingMap()), (SequenceType)((List)arrayList.get(i2)).get(i3)));
            }
            this.setLocation(expression2);
            Expression expression3 = Choose.makeConditional(expression2, (Expression)arrayList2.get(i2), (Expression)object);
            this.setLocation(expression3);
            object = expression3;
        }
        letExpression.setAction((Expression)object);
        return this.makeTracer(n2, letExpression, 2020, null);
    }

    private List<SequenceType> v() {
        ArrayList<SequenceType> arrayList = new ArrayList<SequenceType>();
        while (true) {
            SequenceType sequenceType = this.parseSequenceType();
            arrayList.add(sequenceType);
            this.t.treatCurrentAsOperator();
            if (this.t.currentToken != 1) break;
            this.nextToken();
        }
        this.expect(25);
        this.nextToken();
        return arrayList;
    }

    private LetExpression a(StructuredQName identityComparable, LetExpression letExpression) {
        LetExpression letExpression2 = this.makeLetExpression();
        letExpression2.setRequiredType(SequenceType.ANY_SEQUENCE);
        letExpression2.setVariableQName((StructuredQName)identityComparable);
        letExpression2.setSequence(new LocalVariableReference(letExpression));
        this.declareRangeVariable(letExpression2);
        identityComparable = this.parseExprSingle();
        this.undeclareRangeVariable();
        letExpression2.setAction((Expression)identityComparable);
        return letExpression2;
    }

    @Override
    protected Expression parseSwitchExpression() {
        Expression expression;
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        Object object = this.parseExpression();
        this.expect(204);
        this.nextToken();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(10);
        LetExpression letExpression = this.makeLetExpression();
        letExpression.setRequiredType(SequenceType.OPTIONAL_ATOMIC);
        letExpression.setVariableQName(new StructuredQName("zz", "http://saxon.sf.net/", "zz_switchVar"));
        letExpression.setSequence(Atomizer.makeAtomizer((Expression)object, null));
        do {
            object = new ArrayList(4);
            this.expect(67);
            do {
                this.nextToken();
                expression = this.parseExprSingle();
                object.add(expression);
            } while (this.t.currentToken == 67);
            this.expect(25);
            this.nextToken();
            expression = this.parseExprSingle();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                BinaryExpression binaryExpression = new EquivalenceComparison(new LocalVariableReference(letExpression), 50, (Expression)object.get(i2));
                if (i2 == 0) {
                    arrayList.add(binaryExpression);
                    arrayList2.add(expression);
                    continue;
                }
                ArrayList<Expression> arrayList3 = arrayList;
                binaryExpression = new OrExpression((Expression)arrayList3.remove(arrayList3.size() - 1), binaryExpression);
                arrayList.add(binaryExpression);
            }
        } while (this.t.currentToken == 67);
        this.expect(212);
        this.nextToken();
        this.expect(25);
        this.nextToken();
        object = this.parseExprSingle();
        arrayList.add(Literal.makeLiteral(BooleanValue.TRUE));
        arrayList2.add(object);
        expression = new Choose(arrayList.toArray(new Expression[0]), arrayList2.toArray(new Expression[arrayList.size()]));
        letExpression.setAction(expression);
        return this.makeTracer(n2, letExpression, 2026, null);
    }

    @Override
    protected Expression parseValidateExpression() {
        int n2 = this.t.currentTokenStartOffset;
        int n3 = 1;
        boolean bl2 = false;
        SchemaType schemaType = null;
        this.ensureSchemaAware("validate expression");
        switch (this.t.currentToken) {
            case 103: {
                n3 = 1;
                this.nextToken();
                break;
            }
            case 104: {
                n3 = 2;
                this.nextToken();
                break;
            }
            case 105: {
                n3 = 8;
                this.nextToken();
                this.expect(60);
                if (!NameChecker.isQName(this.t.currentTokenValue)) {
                    this.grumble("Schema type name expected after 'validate type");
                }
                XQueryParser xQueryParser = this;
                schemaType = this.env.getConfiguration().getSchemaType(xQueryParser.makeStructuredQName(xQueryParser.t.currentTokenValue, this.env.getDefaultElementNamespace()));
                if (schemaType == null) {
                    this.grumble("Unknown schema type " + this.t.currentTokenValue, "XQST0104");
                }
                bl2 = true;
                break;
            }
            case 60: {
                if (!this.t.currentTokenValue.equals("validate")) {
                    throw new AssertionError((Object)"shouldn't be parsing a validate expression");
                }
                n3 = 1;
                bl2 = true;
            }
        }
        if (!bl2) {
            this.expect(59);
        }
        this.nextToken();
        Expression expression = this.parseExpression();
        if (expression instanceof ParentNodeConstructor) {
            int n4 = n3;
            ((ParentNodeConstructor)expression).setValidationAction(n4, n4 == 8 ? schemaType : null);
        } else {
            expression = new CopyOf(expression, true, n3, schemaType, true);
            this.setLocation(expression);
            ((CopyOf)expression).setRequireDocumentOrElement(true);
        }
        this.expect(215);
        this.t.lookAhead();
        this.nextToken();
        return this.makeTracer(n2, expression, 2023, null);
    }

    @Override
    protected Expression parseExtensionExpression() {
        int n2;
        SchemaType schemaType = null;
        CharSequence charSequence = Whitespace.removeLeadingWhitespace(this.t.currentTokenValue);
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && " \t\r\n".indexOf(charSequence.charAt(n2)) < 0; ++n2) {
        }
        String string = charSequence.subSequence(0, n2).toString();
        String string2 = "";
        while (n2 < n3 && " \t\r\n".indexOf(charSequence.charAt(n2)) >= 0) {
            ++n2;
        }
        if (n2 < n3) {
            string2 = charSequence.subSequence(n2, n3).toString();
        }
        boolean bl2 = false;
        Object object = this.makeStructuredQName(string, "");
        assert (object != null);
        String string3 = ((StructuredQName)object).getURI();
        object = ((StructuredQName)object).getLocalPart();
        if (string3.equals("http://saxon.sf.net/")) {
            int n4 = -1;
            switch (((String)object).hashCode()) {
                case -877013615: {
                    if (!((String)object).equals("validate-type")) break;
                    n4 = 0;
                }
            }
            switch (n4) {
                case 0: {
                    if (!this.env.getConfiguration().isLicensedFeature(4)) {
                        this.warning("Ignoring saxon:validate-type. To use this feature you need the Saxon-EE processor from http://www.saxonica.com/");
                        break;
                    }
                    String string4 = Whitespace.trim(string2);
                    if (!NameChecker.isQName(string4)) {
                        this.grumble("Schema type name expected in saxon:validate-type pragma: found " + Err.wrap(string4));
                    }
                    if ((schemaType = this.env.getConfiguration().getSchemaType(this.makeStructuredQName(string4, this.env.getDefaultElementNamespace()))) == null) {
                        this.grumble("Unknown schema type " + string4);
                    }
                    bl2 = true;
                    break;
                }
                default: {
                    this.warning("Ignored pragma " + string + " (unrecognized Saxon pragma)");
                }
            }
        }
        this.nextToken();
        if (this.t.currentToken == 218) {
            object = this.parseExtensionExpression();
        } else {
            this.expect(59);
            this.nextToken();
            if (this.t.currentToken == 215) {
                this.t.lookAhead();
                this.nextToken();
                this.grumble("Unrecognized pragma, with no fallback expression", "XQST0079");
            }
            object = this.parseExpression();
            this.expect(215);
            this.t.lookAhead();
            this.nextToken();
        }
        if (bl2) {
            if (object instanceof ParentNodeConstructor) {
                ((ParentNodeConstructor)object).setValidationAction(8, schemaType);
                return object;
            }
            if (object instanceof AttributeCreator) {
                if (!(schemaType instanceof SimpleType)) {
                    this.grumble("The type used for validating an attribute must be a simple type");
                }
                ((AttributeCreator)object).setSchemaType((SimpleType)schemaType);
                ((AttributeCreator)object).setValidationAction(8);
                return object;
            }
            CopyOf copyOf = new CopyOf((Expression)object, true, 8, schemaType, true);
            copyOf.setLocation(this.makeLocation());
            return copyOf;
        }
        return object;
    }

    @Override
    protected Expression parseConstructor() {
        int n2 = this.t.currentTokenStartOffset;
        switch (this.t.currentToken) {
            case 217: {
                Expression expression = this.a(false);
                this.lookAhead();
                this.t.setState(3);
                this.nextToken();
                return expression;
            }
            case 60: {
                switch (this.t.currentTokenValue) {
                    case "validate": {
                        this.grumble("A validate expression is not allowed within a path expression");
                        break;
                    }
                    case "ordered": 
                    case "unordered": {
                        this.nextToken();
                        Expression expression = this.t.currentToken == 215 && this.allowXPath31Syntax ? Literal.makeEmptySequence() : this.parseExpression();
                        this.expect(215);
                        this.lookAhead();
                        this.nextToken();
                        return expression;
                    }
                    case "document": {
                        int n3 = n2;
                        XQueryParser xQueryParser = this;
                        xQueryParser.nextToken();
                        Expression expression = xQueryParser.t.currentToken == 215 && xQueryParser.allowXPath31Syntax ? Literal.makeEmptySequence() : xQueryParser.parseExpression();
                        xQueryParser.expect(215);
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        DocumentInstr documentInstr = new DocumentInstr(false, null);
                        if (!((QueryModule)xQueryParser.env).isPreserveNamespaces()) {
                            expression = new CopyOf(expression, false, 3, null, true);
                        }
                        documentInstr.setValidationAction(((QueryModule)xQueryParser.env).getConstructionMode(), null);
                        documentInstr.setContentExpression(expression);
                        xQueryParser.setLocation(documentInstr, n3);
                        return documentInstr;
                    }
                    case "element": {
                        return this.a(n2);
                    }
                    case "attribute": {
                        return this.b(n2);
                    }
                    case "text": {
                        int n4 = n2;
                        XQueryParser xQueryParser = this;
                        xQueryParser.nextToken();
                        Expression expression = xQueryParser.t.currentToken == 215 && xQueryParser.allowXPath31Syntax ? Literal.makeEmptySequence() : xQueryParser.parseExpression();
                        xQueryParser.expect(215);
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        Expression expression2 = XQueryParser.stringify(expression, true, xQueryParser.env);
                        ValueOf valueOf = new ValueOf(expression2, false, true);
                        xQueryParser.setLocation(valueOf, n4);
                        return xQueryParser.makeTracer(n4, valueOf, 201, null);
                    }
                    case "comment": {
                        int n5 = n2;
                        XQueryParser xQueryParser = this;
                        xQueryParser.nextToken();
                        Expression expression = xQueryParser.t.currentToken == 215 && xQueryParser.allowXPath31Syntax ? Literal.makeEmptySequence() : xQueryParser.parseExpression();
                        xQueryParser.expect(215);
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        Comment comment = new Comment();
                        xQueryParser.makeSimpleContent(expression, comment, n5);
                        return xQueryParser.makeTracer(n5, comment, 143, null);
                    }
                    case "processing-instruction": {
                        int n6 = n2;
                        XQueryParser xQueryParser = this;
                        xQueryParser.nextToken();
                        Expression expression = xQueryParser.parseExpression();
                        xQueryParser.expect(215);
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        xQueryParser.expect(59);
                        xQueryParser.t.setState(0);
                        xQueryParser.nextToken();
                        Expression expression3 = null;
                        if (xQueryParser.t.currentToken != 215) {
                            expression3 = xQueryParser.parseExpression();
                            xQueryParser.expect(215);
                        }
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        ProcessingInstruction processingInstruction = new ProcessingInstruction(expression);
                        xQueryParser.makeSimpleContent(expression3, processingInstruction, n6);
                        return xQueryParser.makeTracer(n6, processingInstruction, 192, null);
                    }
                    case "namespace": {
                        int n7 = n2;
                        XQueryParser xQueryParser = this;
                        if (!xQueryParser.allowXPath30Syntax) {
                            xQueryParser.grumble("Namespace node constructors require XQuery 3.0");
                        }
                        xQueryParser.nextToken();
                        Expression expression = xQueryParser.parseExpression();
                        xQueryParser.expect(215);
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        xQueryParser.expect(59);
                        xQueryParser.t.setState(0);
                        xQueryParser.nextToken();
                        Expression expression4 = null;
                        if (xQueryParser.t.currentToken != 215) {
                            expression4 = xQueryParser.parseExpression();
                            xQueryParser.expect(215);
                        }
                        xQueryParser.lookAhead();
                        xQueryParser.nextToken();
                        NamespaceConstructor namespaceConstructor = new NamespaceConstructor(expression);
                        xQueryParser.setLocation(namespaceConstructor);
                        xQueryParser.makeSimpleContent(expression4, namespaceConstructor, n7);
                        return xQueryParser.makeTracer(n7, namespaceConstructor, 175, null);
                    }
                    default: {
                        this.grumble("Unrecognized node constructor " + this.t.currentTokenValue + "{}");
                    }
                }
            }
            case 61: {
                int n8 = n2;
                XQueryParser xQueryParser = this;
                NodeName nodeName = xQueryParser.makeNodeName(xQueryParser.t.currentTokenValue, true);
                Expression expression = null;
                xQueryParser.nextToken();
                if (xQueryParser.t.currentToken != 215) {
                    expression = xQueryParser.parseExpression();
                    xQueryParser.expect(215);
                }
                xQueryParser.lookAhead();
                xQueryParser.nextToken();
                FixedElement fixedElement = new FixedElement(nodeName, ((QueryModule)xQueryParser.env).getActiveNamespaceCodes(), ((QueryModule)xQueryParser.env).isInheritNamespaces(), true, null, ((QueryModule)xQueryParser.env).getConstructionMode());
                xQueryParser.setLocation(fixedElement, n8);
                if (expression == null) {
                    expression = Literal.makeEmptySequence();
                }
                if (!((QueryModule)xQueryParser.env).isPreserveNamespaces()) {
                    expression = new CopyOf(expression, false, 3, null, true);
                }
                fixedElement.setContentExpression(expression);
                return xQueryParser.makeTracer(n8, fixedElement, 2006, nodeName.getStructuredQName());
            }
            case 62: {
                int n9 = n2;
                XQueryParser xQueryParser = this;
                Object object = null;
                if (xQueryParser.t.currentTokenValue.equals("xmlns") || xQueryParser.t.currentTokenValue.startsWith("xmlns:")) {
                    object = "Cannot create a namespace declaration using an attribute constructor";
                }
                XQueryParser xQueryParser2 = xQueryParser;
                NodeName nodeName = xQueryParser2.makeNodeName(xQueryParser2.t.currentTokenValue, false);
                if (!nodeName.getURI().equals("") && nodeName.getPrefix().equals("")) {
                    nodeName = new FingerprintedQName("_", nodeName.getURI(), nodeName.getLocalPart());
                }
                Expression expression = null;
                xQueryParser.nextToken();
                if (xQueryParser.t.currentToken != 215) {
                    expression = xQueryParser.parseExpression();
                    xQueryParser.expect(215);
                }
                xQueryParser.lookAhead();
                xQueryParser.nextToken();
                if (object == null) {
                    object = new FixedAttribute(nodeName, 4, null);
                    ((AttributeCreator)object).setRejectDuplicates();
                    ((Expression)object).setRetainedStaticContext(xQueryParser.env.makeRetainedStaticContext());
                    xQueryParser.makeSimpleContent(expression, (SimpleNodeConstructor)object, n9);
                    return xQueryParser.makeTracer(n9, (Expression)object, 2007, nodeName.getStructuredQName());
                }
                xQueryParser.warning((String)object);
                return new ErrorExpression((String)object, "XQDY0044", false);
            }
            case 64: {
                Object object;
                int n10 = n2;
                XQueryParser xQueryParser = this;
                if (!xQueryParser.allowXPath30Syntax) {
                    xQueryParser.grumble("Namespace node constructors require XQuery 3.0");
                }
                if (!NameChecker.isValidNCName((CharSequence)(object = xQueryParser.t.currentTokenValue))) {
                    xQueryParser.grumble("Invalid namespace prefix " + Err.wrap((CharSequence)object));
                }
                StringLiteral stringLiteral = new StringLiteral((CharSequence)object);
                Expression expression = null;
                xQueryParser.nextToken();
                if (xQueryParser.t.currentToken != 215) {
                    expression = xQueryParser.parseExpression();
                    xQueryParser.expect(215);
                }
                xQueryParser.lookAhead();
                xQueryParser.nextToken();
                object = new NamespaceConstructor(stringLiteral);
                xQueryParser.makeSimpleContent(expression, (SimpleNodeConstructor)object, n10);
                return xQueryParser.makeTracer(n10, (Expression)object, 175, null);
            }
            case 63: {
                int n11 = n2;
                XQueryParser xQueryParser = this;
                Object object = xQueryParser.t.currentTokenValue;
                Object object2 = null;
                if (((String)object).equalsIgnoreCase("xml")) {
                    object2 = "A processing instruction must not be named 'xml' in any combination of upper and lower case";
                }
                if (!NameChecker.isValidNCName((CharSequence)object)) {
                    xQueryParser.grumble("Invalid processing instruction name " + Err.wrap((CharSequence)object));
                }
                StringLiteral stringLiteral = new StringLiteral((CharSequence)object);
                object = null;
                xQueryParser.nextToken();
                if (xQueryParser.t.currentToken != 215) {
                    object = xQueryParser.parseExpression();
                    xQueryParser.expect(215);
                }
                xQueryParser.lookAhead();
                xQueryParser.nextToken();
                if (object2 == null) {
                    object2 = new ProcessingInstruction(stringLiteral);
                    xQueryParser.makeSimpleContent((Expression)object, (SimpleNodeConstructor)object2, n11);
                    return xQueryParser.makeTracer(n11, (Expression)object2, 192, null);
                }
                xQueryParser.warning((String)object2);
                return new ErrorExpression((String)object2, "XQDY0064", false);
            }
        }
        return new ErrorExpression();
    }

    private Expression a(int n2) {
        this.nextToken();
        Object object = this.parseExpression();
        this.expect(215);
        this.lookAhead();
        this.nextToken();
        this.expect(59);
        this.t.setState(0);
        this.nextToken();
        Object object2 = null;
        if (this.t.currentToken != 215) {
            object2 = this.parseExpression();
            if (object2 instanceof ElementCreator && ((ElementCreator)object2).getSchemaType() == null) {
                ((ElementCreator)object2).setValidationAction(3, null);
            }
            this.expect(215);
        }
        this.lookAhead();
        this.nextToken();
        if (object instanceof Literal) {
            NodeName nodeName;
            if ((object = ((Literal)object).getValue()) instanceof StringValue && !(object instanceof AnyURIValue)) {
                String string = ((StringValue)object).getStringValue();
                try {
                    nodeName = this.makeNodeName(string, true);
                    nodeName.obtainFingerprint(this.env.getConfiguration().getNamePool());
                }
                catch (XPathException xPathException) {
                    object = xPathException;
                    object2 = xPathException.getErrorCodeLocalPart();
                    if ("XPST0008".equals(object2) || "XPST0081".equals(object2)) {
                        ((XPathException)object).setErrorCode("XQDY0074");
                    } else if ("XPST0003".equals(object2)) {
                        this.grumble("Invalid QName in element constructor: " + string, "XQDY0074", n2);
                        return new ErrorExpression();
                    }
                    ((TransformerException)object).setLocator(this.makeLocation());
                    ((XPathException)object).setIsStaticError(false);
                    return new ErrorExpression((XPathException)object);
                }
            } else if (object instanceof QualifiedNameValue) {
                String string = ((QualifiedNameValue)object).getNamespaceURI();
                nodeName = new FingerprintedQName("", string, ((QualifiedNameValue)object).getLocalName());
                nodeName.obtainFingerprint(this.env.getConfiguration().getNamePool());
            } else {
                this.grumble("Element name must be either a string or a QName", "XPTY0004", n2);
                return new ErrorExpression();
            }
            object = new FixedElement(nodeName, ((QueryModule)this.env).getActiveNamespaceCodes(), ((QueryModule)this.env).isInheritNamespaces(), true, null, ((QueryModule)this.env).getConstructionMode());
            if (object2 == null) {
                object2 = Literal.makeEmptySequence();
            }
            if (!((QueryModule)this.env).isPreserveNamespaces()) {
                object2 = new CopyOf((Expression)object2, false, 3, null, true);
            }
            ((FixedElement)object).setContentExpression((Expression)object2);
            this.setLocation((Expression)object, n2);
            return this.makeTracer(n2, (Expression)object, 2006, nodeName.getStructuredQName());
        }
        new NamespaceResolverWithDefault(this.env.getNamespaceResolver(), this.env.getDefaultElementNamespace());
        object = new ComputedElement((Expression)object, null, null, ((QueryModule)this.env).getConstructionMode(), ((QueryModule)this.env).isInheritNamespaces(), true);
        this.setLocation((Expression)object);
        if (object2 == null) {
            object2 = Literal.makeEmptySequence();
        }
        if (!((QueryModule)this.env).isPreserveNamespaces()) {
            object2 = new CopyOf((Expression)object2, false, 3, null, true);
        }
        ((ComputedElement)object).setContentExpression((Expression)object2);
        this.setLocation((Expression)object, n2);
        return this.makeTracer(n2, (Expression)object, 151, null);
    }

    private Expression b(int n2) {
        GroundedValue<?> groundedValue;
        this.nextToken();
        Object object = this.parseExpression();
        this.expect(215);
        this.lookAhead();
        this.nextToken();
        this.expect(59);
        this.t.setState(0);
        this.nextToken();
        Object object2 = null;
        if (this.t.currentToken != 215) {
            object2 = this.parseExpression();
            this.expect(215);
        }
        this.lookAhead();
        this.nextToken();
        if (object instanceof Literal) {
            groundedValue = ((Literal)object).getValue();
            if (groundedValue instanceof StringValue && !(groundedValue instanceof AnyURIValue)) {
                object = ((StringValue)groundedValue).getStringValue();
                if (((String)object).equals("xmlns") || ((String)object).startsWith("xmlns:")) {
                    this.grumble("Cannot create a namespace using an attribute constructor", "XQDY0044", n2);
                }
                try {
                    groundedValue = this.makeNodeName((String)object, false);
                }
                catch (XPathException xPathException) {
                    groundedValue = xPathException;
                    object2 = xPathException.getErrorCodeLocalPart();
                    ((TransformerException)((Object)groundedValue)).setLocator(this.makeLocation());
                    if ("XPST0008".equals(object2) || "XPST0081".equals(object2)) {
                        ((XPathException)((Object)groundedValue)).setErrorCode("XQDY0074");
                    } else if ("XPST0003".equals(object2)) {
                        this.grumble("Invalid QName in attribute constructor: " + (String)object, "XQDY0074", n2);
                        return new ErrorExpression();
                    }
                    throw groundedValue;
                }
                groundedValue = new FixedAttribute((NodeName)((Object)groundedValue), 4, null);
                ((AttributeCreator)((Object)groundedValue)).setRejectDuplicates();
                this.makeSimpleContent((Expression)object2, (SimpleNodeConstructor)((Object)groundedValue), n2);
                return this.makeTracer(n2, (Expression)((Object)groundedValue), 135, null);
            }
            if (groundedValue instanceof QNameValue) {
                object = (QNameValue)groundedValue;
                groundedValue = new FingerprintedQName(((QualifiedNameValue)object).getPrefix(), ((QualifiedNameValue)object).getNamespaceURI(), ((QualifiedNameValue)object).getLocalName());
                groundedValue.obtainFingerprint(this.env.getConfiguration().getNamePool());
                groundedValue = new FixedAttribute((NodeName)((Object)groundedValue), 4, null);
                ((AttributeCreator)((Object)groundedValue)).setRejectDuplicates();
                this.makeSimpleContent((Expression)object2, (SimpleNodeConstructor)((Object)groundedValue), n2);
                return this.makeTracer(n2, (Expression)((Object)groundedValue), 135, null);
            }
        }
        groundedValue = new ComputedAttribute((Expression)object, null, this.env.getNamespaceResolver(), 4, null, true);
        ((AttributeCreator)((Object)groundedValue)).setRejectDuplicates();
        this.makeSimpleContent((Expression)object2, (SimpleNodeConstructor)((Object)groundedValue), n2);
        return this.makeTracer(n2, (Expression)((Object)groundedValue), 135, null);
    }

    @Override
    protected Expression parseTryCatchExpression() {
        if (!this.allowXPath30Syntax) {
            this.grumble("try/catch requires XQuery 3.0");
        }
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression expression = this.t.currentToken == 215 && this.allowXPath31Syntax ? Literal.makeEmptySequence() : this.parseExpression();
        expression = new TryCatch(expression);
        this.setLocation(expression, n2);
        this.expect(215);
        this.lookAhead();
        this.nextToken();
        n2 = 0;
        ArrayList<QNameTest> arrayList = new ArrayList<QNameTest>();
        while (this.isKeyword("catch")) {
            Object object;
            arrayList.clear();
            n2 = 1;
            boolean bl2 = false;
            do {
                this.nextToken();
                object = this.t.currentTokenValue;
                switch (this.t.currentToken) {
                    case 201: {
                        this.nextToken();
                        arrayList.add(this.makeNameTest((short)1, (String)object, false));
                        break;
                    }
                    case 60: {
                        this.nextToken();
                        arrayList.add(this.makeNameTest((short)1, (String)object, false));
                        bl2 = true;
                        break;
                    }
                    case 208: {
                        this.nextToken();
                        arrayList.add(this.makeNamespaceTest((short)1, (String)object));
                        break;
                    }
                    case 70: {
                        this.nextToken();
                        object = this.t.currentTokenValue;
                        if (this.t.currentToken != 201) {
                            if (this.t.currentToken == 60) {
                                bl2 = true;
                            } else {
                                this.grumble("Expected name after '*:'");
                            }
                        }
                        this.nextToken();
                        arrayList.add(this.makeLocalNameTest((short)1, (String)object));
                        break;
                    }
                    case 17: 
                    case 207: {
                        this.nextToken();
                        arrayList.add(AnyNodeTest.getInstance());
                        break;
                    }
                    default: {
                        this.grumble("Unrecognized name test");
                        return null;
                    }
                }
            } while (this.t.currentToken == 1 && !this.t.currentTokenValue.equals("union"));
            if (!bl2) {
                this.expect(59);
                this.nextToken();
            }
            object = arrayList.size() == 1 ? (QNameTest)arrayList.get(0) : new UnionQNameTest(arrayList);
            ++this.catchDepth;
            Expression expression2 = this.t.currentToken == 215 && this.allowXPath31Syntax ? Literal.makeEmptySequence() : this.parseExpression();
            ((TryCatch)expression).addCatchExpression((QNameTest)object, expression2);
            this.expect(215);
            this.lookAhead();
            this.nextToken();
            --this.catchDepth;
        }
        if (n2 == 0) {
            this.grumble("After try{}, expected 'catch'");
        }
        return expression;
    }

    protected void makeSimpleContent(Expression expression, SimpleNodeConstructor simpleNodeConstructor, int n2) {
        if (expression == null) {
            simpleNodeConstructor.setSelect(new StringLiteral(StringValue.EMPTY_STRING));
        } else {
            simpleNodeConstructor.setSelect(XQueryParser.stringify(expression, false, this.env));
        }
        this.setLocation(simpleNodeConstructor, n2);
    }

    private Expression a(boolean bl2) {
        try {
            Expression expression;
            int n2 = this.t.inputOffset;
            char c2 = this.t.nextChar();
            switch (c2) {
                case '!': {
                    c2 = this.t.nextChar();
                    if (c2 == '-') {
                        expression = this.x();
                        break;
                    }
                    if (c2 == '[') {
                        this.grumble("A CDATA section is allowed only in element content");
                        return null;
                    }
                    this.grumble("Expected '--' or '[CDATA[' after '<!'");
                    return null;
                }
                case '?': {
                    expression = this.w();
                    break;
                }
                case '/': {
                    if (bl2) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                        while ((c2 = this.t.nextChar()) != '>') {
                            fastStringBuffer.append(c2);
                        }
                        return new StringLiteral(fastStringBuffer.toString());
                    }
                    this.grumble("Unmatched XML end tag");
                    return new ErrorExpression();
                }
                default: {
                    this.t.unreadChar();
                    expression = this.b(bl2);
                }
            }
            this.setLocation(expression, n2);
            return expression;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("End of input encountered while parsing direct constructor");
            return new ErrorExpression();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Expression b(boolean bl2) {
        void var17_47;
        StructuredQName structuredQName;
        Object object;
        String string;
        int n2;
        Object object3;
        Object object4;
        Object object5;
        char c2;
        Object object6 = this.env.getConfiguration().getNamePool();
        boolean bl3 = false;
        int n3 = this.t.inputOffset - 1;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        int n4 = 0;
        while ((c2 = this.t.nextChar()) != ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t' && c2 != '/' && c2 != '>') {
            fastStringBuffer.append(c2);
        }
        String string2 = fastStringBuffer.toString();
        if (string2.isEmpty()) {
            this.grumble("Expected element name after '<'");
        }
        LinkedHashMap<Object, a> linkedHashMap = new LinkedHashMap<Object, a>(10);
        while ((c2 = this.a(c2)) != '/' && c2 != '>') {
            void block;
            int n5;
            int n6;
            int n7;
            int n8 = this.t.inputOffset - 1;
            fastStringBuffer.setLength(0);
            do {
                fastStringBuffer.append(c2);
            } while ((c2 = this.t.nextChar()) != ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t' && c2 != '=');
            object5 = fastStringBuffer.toString();
            if (!NameChecker.isQName((String)object5)) {
                this.grumble("Invalid attribute name " + Err.wrap((CharSequence)object5, 2));
            }
            c2 = this.a(c2);
            this.a(c2, '=');
            c2 = this.t.nextChar();
            char c3 = c2 = this.a(c2);
            boolean bl4 = "xmlns".equals(object5) || ((String)object5).startsWith("xmlns:");
            if (bl4) {
                char c4 = c3;
                int n9 = this.t.inputOffset;
                String string3 = this.t.input;
                n7 = n9;
                n6 = string3.length();
                while (n7 < n6) {
                    int n10 = string3.indexOf(c4, n7);
                    if (n10 < 0) {
                        object6 = new XPathException("Namespace declaration is not properly terminated");
                        ((XPathException)object6).setIsStaticError(true);
                        throw object6;
                    }
                    if (n10 + 1 < string3.length() && string3.charAt(n10 + 1) == c4) {
                        n7 = n10 + 2;
                        continue;
                    }
                    n7 = n10;
                    break;
                }
                n5 = n7;
                bl3 = true;
            } else {
                try {
                    XQueryParser xQueryParser = this;
                    object4 = xQueryParser.a(xQueryParser.t.input, this.t.inputOffset, c3, true);
                }
                catch (XPathException xPathException) {
                    object3 = xPathException;
                    if (!xPathException.hasBeenReported()) {
                        this.grumble(((Throwable)object3).getMessage());
                    }
                    throw object3;
                }
                n5 = (int)((NumericValue)((Int64Value)((Literal)object4).getValue())).longValue();
            }
            object4 = this.t.input.substring(this.t.inputOffset - 1, n5 + 1);
            object3 = this.t.input.substring(this.t.inputOffset, n5);
            Object i3 = object4;
            while ((n6 = block.indexOf(10)) >= 0) {
                this.t.incrementLineNumber(this.t.inputOffset - 1 + n6);
                String string3 = block.substring(n6 + 1);
            }
            this.t.inputOffset = n5 + 1;
            if (bl4) {
                FastStringBuffer fastStringBuffer2 = new FastStringBuffer(((String)object3).length());
                n7 = 0;
                n2 = 0;
                boolean bl5 = false;
                for (int i2 = 0; i2 < ((String)object3).length(); ++i2) {
                    char c4 = ((String)object3).charAt(i2);
                    if (c4 == c3 && (n7 = n7 == 0 ? 1 : 0) != 0) continue;
                    if (c4 == '{') {
                        if ((n2 = n2 == 0 ? 1 : 0) != 0) {
                            continue;
                        }
                    } else if (n2 != 0) {
                        this.grumble("Namespace must not contain an unescaped opening brace", "XQST0022");
                    }
                    if (c4 == '}') {
                        if (bl5 = !bl5) {
                            continue;
                        }
                    } else if (bl5) {
                        this.grumble("Namespace must not contain an unescaped closing brace", "XPST0003");
                    }
                    fastStringBuffer2.append(c4);
                }
                if (n2 != 0) {
                    this.grumble("Namespace must not contain an unescaped opening brace", "XQST0022");
                }
                if (bl5) {
                    this.grumble("Namespace must not contain an unescaped closing brace", "XPST0003");
                }
                object3 = fastStringBuffer2.toString();
                string = this.uriLiteral((String)object3);
                if (!StandardURIChecker.getInstance().isValidURI(string)) {
                    this.grumble("Namespace must be a valid URI value", "XQST0046");
                }
                if ("xmlns".equals(object5)) {
                    object = "";
                    if (string.equals("http://www.w3.org/XML/1998/namespace")) {
                        this.grumble("Cannot have the XML namespace as the default namespace", "XQST0070");
                    }
                } else {
                    object = ((String)object5).substring(6);
                    if (((String)object).equals("xml") && !string.equals("http://www.w3.org/XML/1998/namespace")) {
                        this.grumble("Cannot bind the prefix 'xml' to a namespace other than the XML namespace", "XQST0070");
                    } else if (string.equals("http://www.w3.org/XML/1998/namespace") && !((String)object).equals("xml")) {
                        this.grumble("Cannot bind a prefix other than 'xml' to the XML namespace", "XQST0070");
                    } else if (((String)object).equals("xmlns")) {
                        this.grumble("Cannot use xmlns as a namespace prefix", "XQST0070");
                    }
                    if (string.isEmpty() && this.env.getConfiguration().getXMLVersion() == 10) {
                        this.grumble("Namespace URI must not be empty", "XQST0085");
                    }
                }
                ++n4;
                ((QueryModule)this.env).declareActiveNamespace((String)object, string);
            }
            if (linkedHashMap.get(object5) != null) {
                if (bl4) {
                    this.grumble("Duplicate namespace declaration " + (String)object5, "XQST0071", n8);
                } else {
                    this.grumble("Duplicate attribute name " + (String)object5, "XQST0040", n8);
                }
            }
            a object22 = new a(0);
            new a(0).a = object4;
            object22.b = n8;
            linkedHashMap.put(object5, object22);
            c2 = this.t.nextChar();
            if (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '/' || c2 == '>') continue;
            this.grumble("There must be whitespace after every attribute except the last");
        }
        if (this.scanOnly) {
            structuredQName = StandardNames.getStructuredQName(151);
        } else {
            try {
                object5 = NameChecker.getQNameParts(string2);
                String string4 = ((QueryModule)this.env).checkURIForPrefix(object5[0]);
                if (string4 == null) {
                    this.grumble("Undeclared prefix in element name " + Err.wrap(string2, 1), "XPST0081", n3);
                }
                structuredQName = new StructuredQName(object5[0], string4, object5[1]);
            }
            catch (QNameException qNameException) {
                this.grumble("Invalid element name " + Err.wrap(string2, 1), "XPST0003", n3);
                structuredQName = StandardNames.getStructuredQName(151);
            }
        }
        int n11 = ((QueryModule)this.env).getConstructionMode();
        FingerprintedQName fingerprintedQName = new FingerprintedQName(structuredQName.getPrefix(), structuredQName.getURI(), structuredQName.getLocalPart(), ((NamePool)object6).allocateFingerprint(structuredQName.getURI(), structuredQName.getLocalPart()));
        FixedElement fixedElement = new FixedElement(fingerprintedQName, ((QueryModule)this.env).getActiveNamespaceCodes(), ((QueryModule)this.env).isInheritNamespaces(), !bl2, null, n11);
        this.setLocation(fixedElement, n3);
        Expression[] expressionArray = new ArrayList(10);
        object4 = new IntHashSet(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Expression expression;
            String string4 = (String)entry.getKey();
            a a2 = (a)entry.getValue();
            String string5 = a2.a;
            n2 = a2.b;
            if ("xmlns".equals(string4) || string4.startsWith("xmlns:") || this.scanOnly) continue;
            FingerprintedQName fingerprintedQName2 = null;
            try {
                object = NameChecker.getQNameParts(string4);
                string = object[0].isEmpty() ? "" : ((QueryModule)this.env).checkURIForPrefix(object[0]);
                if (string == null) {
                    this.grumble("Undeclared prefix in attribute name " + Err.wrap(string4, 2), "XPST0081", n2);
                }
                if (((IntHashSet)object4).contains((bl2 = (fingerprintedQName2 = new FingerprintedQName(object[0], string, object[1])).obtainFingerprint((NamePool)object6)) ? 1 : 0)) {
                    this.grumble("Duplicate expanded attribute name " + string4, "XQST0040", n2);
                }
                ((IntHashSet)object4).add(bl2 ? 1 : 0);
            }
            catch (QNameException qNameException) {
                this.grumble("Invalid attribute name " + Err.wrap(string4, 2), "XPST0003", n2);
            }
            assert (fingerprintedQName2 != null);
            object = new FixedAttribute(fingerprintedQName2, 4, null);
            this.setLocation((Expression)object);
            try {
                expression = this.a(string5, 1, string5.charAt(0), false);
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.setIsStaticError(true);
                throw xPathException2;
            }
            ((Expression)object).setRetainedStaticContext(this.env.makeRetainedStaticContext());
            ((SimpleNodeConstructor)object).setSelect(expression);
            ((AttributeCreator)object).setRejectDuplicates();
            this.setLocation((Expression)object);
            expressionArray.add(this.makeTracer(n2, (Expression)object, 2007, fingerprintedQName2.getStructuredQName()));
        }
        if (c2 == '/') {
            XQueryParser xQueryParser = this;
            xQueryParser.a(xQueryParser.t.nextChar(), '>');
        } else {
            object3 = expressionArray;
            object4 = string2;
            XQueryParser xQueryParser = this;
            try {
                bl2 = false;
                while (true) {
                    char c5;
                    FastStringBuffer fastStringBuffer3 = new FastStringBuffer(64);
                    boolean bl6 = false;
                    while (true) {
                        if ((c5 = xQueryParser.t.nextChar()) == '<') {
                            if (xQueryParser.t.nextChar() == '!') {
                                if (xQueryParser.t.nextChar() == '[') {
                                    xQueryParser.a(fastStringBuffer3);
                                    bl6 = true;
                                    continue;
                                }
                                xQueryParser.t.unreadChar();
                                xQueryParser.t.unreadChar();
                                break;
                            }
                            xQueryParser.t.unreadChar();
                            break;
                        }
                        if (c5 == '&') {
                            fastStringBuffer3.append(xQueryParser.y());
                            bl6 = true;
                            continue;
                        }
                        if (c5 == '}') {
                            c5 = xQueryParser.t.nextChar();
                            if (c5 != '}') {
                                xQueryParser.grumble("'}' must be written as '}}' within element content");
                            }
                            fastStringBuffer3.append(c5);
                            continue;
                        }
                        if (c5 == '{') {
                            c5 = xQueryParser.t.nextChar();
                            if (c5 != '{') {
                                c5 = '{';
                                break;
                            }
                            fastStringBuffer3.append(c5);
                            continue;
                        }
                        if (!xQueryParser.charChecker.test(c5) && !UTF16CharacterSet.isSurrogate(c5)) {
                            xQueryParser.grumble("Character code " + c5 + " is not a valid XML character");
                        }
                        fastStringBuffer3.append(c5);
                    }
                    if (!(fastStringBuffer3.isEmpty() || !(bl6 | ((QueryModule)xQueryParser.env).isPreserveBoundarySpace()) && Whitespace.isWhite(fastStringBuffer3))) {
                        ValueOf valueOf = new ValueOf(new StringLiteral(new StringValue(fastStringBuffer3.condense())), false, false);
                        xQueryParser.setLocation(valueOf);
                        object3.add(valueOf);
                        bl2 = false;
                    }
                    if (c5 == '<') {
                        object6 = xQueryParser.a(true);
                        if (object6 instanceof StringLiteral) {
                            if (Whitespace.isWhitespace(((String)(object6 = ((StringLiteral)object6).getStringValue())).charAt(0))) {
                                xQueryParser.grumble("End tag contains whitespace before the name");
                            }
                            if (!((String)(object6 = Whitespace.trim((CharSequence)object6))).equals(object4)) {
                                xQueryParser.grumble("End tag </" + (String)object6 + "> does not match start tag <" + (String)object4 + '>', "XQST0118");
                                continue;
                            }
                            break;
                        }
                        object3.add(object6);
                        continue;
                    }
                    if (bl2) {
                        Object object2 = object3;
                        Expression expression = (Expression)object2.get(object2.size() - 1);
                        Object object8 = expression.getStaticUType(UType.ANY);
                        boolean bl7 = UType.ANY_NODE.subsumes((UType)object8);
                        if (!bl7) {
                            object8 = new ValueOf(new StringLiteral(StringValue.EMPTY_STRING), false, false);
                            xQueryParser.setLocation((Expression)object8);
                            object3.add(object8);
                        }
                    }
                    xQueryParser.t.unreadChar();
                    xQueryParser.t.setState(0);
                    xQueryParser.lookAhead();
                    xQueryParser.nextToken();
                    if (xQueryParser.t.currentToken == 215 && xQueryParser.allowXPath31Syntax) {
                        object3.add(Literal.makeEmptySequence());
                    } else {
                        Expression expression = xQueryParser.parseExpression();
                        if (!((QueryModule)xQueryParser.env).isPreserveNamespaces()) {
                            expression = new CopyOf(expression, false, 3, null, true);
                        }
                        object3.add(expression);
                        xQueryParser.expect(215);
                    }
                    bl2 = true;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                xQueryParser.grumble("No closing end tag found for direct element constructor");
            }
        }
        object3 = new Expression[expressionArray.size()];
        boolean bl7 = false;
        while (var17_47 < expressionArray.size()) {
            if (n11 != 4) {
                ((Expression)expressionArray.get((int)var17_47)).suppressValidation(n11);
            }
            object3[var17_47] = (Expression)expressionArray.get((int)var17_47);
            ++var17_47;
        }
        Block block = new Block((Expression[])object3);
        if (bl3) {
            block.setRetainedStaticContext(this.env.makeRetainedStaticContext());
        }
        fixedElement.setContentExpression(block);
        for (int i3 = 0; i3 < n4; ++i3) {
            ((QueryModule)this.env).undeclareNamespace();
        }
        return this.makeTracer(n3, fixedElement, 2006, structuredQName);
    }

    private Expression a(String object, int n2, char c2, boolean bl2) {
        Location location = this.makeLocation();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        int n3 = n2;
        int n4 = ((String)object).length();
        while (n3 < n4) {
            int n5 = ((String)object).indexOf(c2, n3);
            if (n5 < 0) {
                XPathException xPathException = new XPathException("Attribute constructor is not properly terminated");
                xPathException.setIsStaticError(true);
                throw xPathException;
            }
            n2 = ((String)object).indexOf("{", n3);
            int n6 = ((String)object).indexOf("{{", n3);
            int n7 = ((String)object).indexOf("}", n3);
            int n8 = ((String)object).indexOf("}}", n3);
            if (!(n2 >= 0 && n5 >= n2 || n7 >= 0 && n5 >= n7)) {
                this.a(arrayList, (String)object, n3, n5);
                if (n5 + 1 < ((String)object).length() && ((String)object).charAt(n5 + 1) == c2) {
                    arrayList.add(new StringLiteral("" + c2));
                    n3 = n5 + 2;
                    continue;
                }
                n3 = n5;
                break;
            }
            if (n7 >= 0 && (n2 < 0 || n7 < n2)) {
                if (n7 != n8) {
                    XPathException xPathException = new XPathException("Closing curly brace in attribute value template \"" + (String)object + "\" must be doubled");
                    xPathException.setIsStaticError(true);
                    throw xPathException;
                }
                this.a(arrayList, (String)object, n3, n7 + 1);
                n3 = n7 + 2;
                continue;
            }
            if (n6 >= 0 && n6 == n2) {
                this.a(arrayList, (String)object, n3, n6 + 1);
                n3 = n6 + 2;
                continue;
            }
            if (n2 >= 0) {
                if (n2 > n3) {
                    this.a(arrayList, (String)object, n3, n2);
                }
                XQueryParser xQueryParser = this.newParser();
                this.newParser().executable = this.executable;
                xQueryParser.setAllowAbsentExpression(this.allowXPath31Syntax);
                xQueryParser.setScanOnly(bl2);
                xQueryParser.setRangeVariableStack(this.rangeVariables);
                xQueryParser.setCatchDepth(this.catchDepth);
                Expression expression = xQueryParser.parse((String)object, n2 + 1, 215, this.env);
                if (!bl2) {
                    expression = expression.simplify();
                }
                n3 = xQueryParser.getTokenizer().currentTokenStartOffset + 1;
                arrayList.add(XQueryParser.makeStringJoin(expression, this.env));
                continue;
            }
            throw new IllegalStateException("Internal error parsing direct attribute constructor");
        }
        if (bl2) {
            return Literal.makeLiteral(Int64Value.makeIntegerValue(n3));
        }
        if (arrayList.isEmpty()) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        if (arrayList.size() == 1) {
            return (Expression)arrayList.get(0);
        }
        Expression[] expressionArray = new Expression[arrayList.size()];
        arrayList.toArray(expressionArray);
        RetainedStaticContext retainedStaticContext = new RetainedStaticContext(this.env);
        object = SystemFunction.makeCall("concat", retainedStaticContext, expressionArray);
        assert (object != null);
        ((Expression)object).setLocation(location);
        return object;
    }

    private void a(List<Expression> list, String string, int n2, int n3) {
        if (n2 < n3) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(n3 - n2);
            while (n2 < n3) {
                int n4 = string.charAt(n2);
                switch (n4) {
                    case 38: {
                        n4 = string.indexOf(59, n2);
                        if (n4 < 0) {
                            this.grumble("No closing ';' found for entity or character reference");
                            break;
                        }
                        String string2 = string.substring(n2 + 1, n4);
                        fastStringBuffer.append(new Unescaper(this.env.getConfiguration().getValidCharacterChecker()).a(string2));
                        n2 = n4;
                        break;
                    }
                    case 60: {
                        this.grumble("The < character must not appear in attribute content");
                        break;
                    }
                    case 9: 
                    case 10: {
                        fastStringBuffer.append(' ');
                        break;
                    }
                    case 13: {
                        fastStringBuffer.append(' ');
                        if (n2 + 1 >= n3 || string.charAt(n2 + 1) != '\n') break;
                        ++n2;
                        break;
                    }
                    default: {
                        fastStringBuffer.append((char)n4);
                    }
                }
                ++n2;
            }
            list.add(new StringLiteral(fastStringBuffer.toString()));
        }
    }

    private ProcessingInstruction w() {
        try {
            String string;
            Object object = new FastStringBuffer(64);
            int n2 = -1;
            while (!((FastStringBuffer)object).toString().endsWith("?>")) {
                char c2 = this.t.nextChar();
                if (n2 < 0 && " \t\r\n".indexOf(c2) >= 0) {
                    n2 = ((FastStringBuffer)object).length();
                }
                ((FastStringBuffer)object).append(c2);
            }
            FastStringBuffer fastStringBuffer = object;
            fastStringBuffer.setLength(fastStringBuffer.length() - 2);
            String string2 = "";
            if (n2 < 0) {
                string = ((FastStringBuffer)object).toString();
            } else {
                string = ((FastStringBuffer)object).toString().substring(0, n2);
                ++n2;
                while (n2 < ((FastStringBuffer)object).length() && " \t\r\n".indexOf(((FastStringBuffer)object).charAt(n2)) >= 0) {
                    ++n2;
                }
                string2 = ((FastStringBuffer)object).toString().substring(n2);
            }
            if (!NameChecker.isValidNCName(string)) {
                this.grumble("Invalid processing instruction name " + Err.wrap(string));
            }
            if (string.equalsIgnoreCase("xml")) {
                this.grumble("A processing instruction must not be named 'xml' in any combination of upper and lower case");
            }
            object = new ProcessingInstruction(new StringLiteral(string));
            ((SimpleNodeConstructor)object).setSelect(new StringLiteral(string2));
            this.setLocation((Expression)object);
            return object;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '?>' found for processing instruction");
            return null;
        }
    }

    private void a(FastStringBuffer fastStringBuffer) {
        try {
            char c2 = this.t.nextChar();
            this.a(c2, 'C');
            c2 = this.t.nextChar();
            this.a(c2, 'D');
            c2 = this.t.nextChar();
            this.a(c2, 'A');
            c2 = this.t.nextChar();
            this.a(c2, 'T');
            c2 = this.t.nextChar();
            this.a(c2, 'A');
            c2 = this.t.nextChar();
            this.a(c2, '[');
            while (!fastStringBuffer.toString().endsWith("]]>")) {
                fastStringBuffer.append(this.t.nextChar());
            }
            FastStringBuffer fastStringBuffer2 = fastStringBuffer;
            fastStringBuffer2.setLength(fastStringBuffer2.length() - 3);
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ']]>' found for CDATA section");
            return;
        }
    }

    private Comment x() {
        try {
            char c2 = this.t.nextChar();
            this.a(c2, '-');
            CharSequence charSequence = new FastStringBuffer(256);
            while (!charSequence.toString().endsWith("--")) {
                charSequence.append(this.t.nextChar());
            }
            if (this.t.nextChar() != '>') {
                this.grumble("'--' is not permitted in an XML comment");
            }
            charSequence = charSequence.subSequence(0, charSequence.length() - 2);
            Comment comment = new Comment();
            comment.setSelect(new StringLiteral(new StringValue(charSequence)));
            this.setLocation(comment);
            return comment;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '-->' found for comment constructor");
            return null;
        }
    }

    public static Expression stringify(Expression expression, boolean bl2, StaticContext staticContext) {
        if (expression instanceof StringLiteral) {
            return expression;
        }
        if (expression.getLocalRetainedStaticContext() == null) {
            expression.setRetainedStaticContext(staticContext.makeRetainedStaticContext());
        }
        expression = Atomizer.makeAtomizer(expression, null);
        expression = new AtomicSequenceConverter(expression, BuiltInAtomicType.STRING);
        expression = SystemFunction.makeCall("string-join", expression.getRetainedStaticContext(), expression, new StringLiteral(StringValue.SINGLE_SPACE));
        assert (expression != null);
        if (bl2) {
            ((StringJoin)((SystemFunctionCall)expression).getTargetFunction()).setReturnEmptyIfEmpty(true);
        }
        return expression;
    }

    @Override
    protected Literal makeStringLiteral(String object) {
        if (((String)object).indexOf(38) == -1) {
            object = new StringLiteral((CharSequence)object);
        } else {
            object = this.unescape((String)object);
            object = new StringLiteral(StringValue.makeStringValue((CharSequence)object));
        }
        this.setLocation((Expression)object);
        return object;
    }

    @Override
    protected CharSequence unescape(String string) {
        return new Unescaper(this.env.getConfiguration().getValidCharacterChecker()).unescape(string);
    }

    private String y() {
        try {
            char c2;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            while ((c2 = this.t.nextChar()) != ';') {
                fastStringBuffer.append(c2);
            }
            String string = fastStringBuffer.toString();
            return new Unescaper(this.env.getConfiguration().getValidCharacterChecker()).a(string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ';' found for entity or character reference");
            return "";
        }
    }

    @Override
    public Expression parseStringTemplate(boolean bl2) {
        int n2 = this.t.currentTokenStartOffset;
        if (!this.allowXPath31Syntax) {
            throw new XPathException("String constructor expressions require XQuery 3.1");
        }
        if (bl2) {
            StringLiteral stringLiteral = new StringLiteral(this.t.currentTokenValue);
            this.setLocation(stringLiteral, n2);
            this.t.next();
            return stringLiteral;
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(new StringLiteral(this.t.currentTokenValue));
        this.t.next();
        block2: while (true) {
            boolean bl3;
            boolean bl4 = bl3 = this.t.currentToken == 215;
            if (this.t.currentToken != 221 && this.t.currentToken != 78) {
                if (bl3) {
                    arrayList.add(new StringLiteral(StringValue.EMPTY_STRING));
                } else {
                    Expression expression = this.parseExpression();
                    Expression expression2 = SystemFunction.makeCall("string-join", this.env.makeRetainedStaticContext(), expression, new StringLiteral(" "));
                    arrayList.add(expression2);
                }
                if (this.t.currentToken != 215) {
                    this.grumble("Expected '}' after enclosed expression in string constructor");
                }
                FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
                char c2 = this.t.nextChar();
                if (c2 != '`') {
                    this.grumble("Expected '}`' after enclosed expression in string constructor");
                }
                int n3 = 0;
                int n4 = 0;
                try {
                    while (true) {
                        c2 = this.t.nextChar();
                        if (n3 == 96 && c2 == '{') {
                            FastStringBuffer fastStringBuffer2 = fastStringBuffer;
                            fastStringBuffer2.setLength(fastStringBuffer2.length() - 1);
                            arrayList.add(new StringLiteral(fastStringBuffer));
                            this.t.lookAhead();
                            this.t.next();
                            if (this.t.currentToken != 215) continue block2;
                            arrayList.add(Literal.makeEmptySequence());
                            fastStringBuffer.setLength(0);
                            continue;
                        }
                        if (n4 == 93 && n3 == 96 && c2 == '`') {
                            FastStringBuffer fastStringBuffer3 = fastStringBuffer;
                            fastStringBuffer3.setLength(fastStringBuffer3.length() - 2);
                            arrayList.add(new StringLiteral(fastStringBuffer));
                            this.t.lookAhead();
                            this.t.next();
                            break block2;
                        }
                        fastStringBuffer.append(c2);
                        n4 = n3;
                        n3 = c2;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.grumble("String constructor is missing ]`` terminator ");
                }
            }
            if (this.t.currentToken == 221) {
                arrayList.add(new StringLiteral(this.t.currentTokenValue));
                this.t.next();
                break;
            }
            if (this.t.currentToken == 78) {
                arrayList.add(new StringLiteral(this.t.currentTokenValue));
                this.t.next();
                continue;
            }
            this.grumble("Expected '}`' after enclosed expression in string template");
        }
        Object object = arrayList.toArray(new Expression[0]);
        object = SystemFunction.makeCall("concat", this.env.makeRetainedStaticContext(), object);
        this.setLocation((Expression)object, n2);
        return object;
    }

    public String uriLiteral(String string) {
        return Whitespace.applyWhitespaceNormalization(2, this.unescape(string)).toString();
    }

    protected void lookAhead() {
        try {
            this.t.lookAhead();
            return;
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
            return;
        }
    }

    @Override
    protected boolean atStartOfRelativePath() {
        return this.t.currentToken == 217 || super.atStartOfRelativePath();
    }

    @Override
    protected void testPermittedAxis(byte by, String string) {
        if (by == 8 && this.language == 3) {
            this.grumble("The namespace axis is not available in XQuery", string);
        }
    }

    private char a(char c2) {
        while (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
            c2 = this.t.nextChar();
        }
        return c2;
    }

    private void a(char c2, char c3) {
        if (c2 != c3) {
            this.grumble("Expected '" + c3 + "', found '" + c2 + '\'');
        }
    }

    @Override
    protected String getLanguage() {
        return "XQuery";
    }

    private static class b {
        String a;
        List<String> b;

        private b() {
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    private static final class a {
        String a;
        int b;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    public static class Unescaper {
        private final IntPredicate a;

        public Unescaper(IntPredicate intPredicate) {
            this.a = intPredicate;
        }

        public CharSequence unescape(String string) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
            for (int i2 = 0; i2 < string.length(); ++i2) {
                int n2 = string.charAt(i2);
                if (n2 == 38) {
                    n2 = string.indexOf(59, i2);
                    if (n2 < 0) {
                        throw new XPathException("No closing ';' found for entity or character reference", "XPST0003");
                    }
                    String string2 = string.substring(i2 + 1, n2);
                    fastStringBuffer.append(this.a(string2));
                    i2 = n2;
                    continue;
                }
                fastStringBuffer.append((char)n2);
            }
            return fastStringBuffer;
        }

        private String a(String string) {
            if ("lt".equals(string)) {
                return "<";
            }
            if ("gt".equals(string)) {
                return ">";
            }
            if ("amp".equals(string)) {
                return "&";
            }
            if ("quot".equals(string)) {
                return "\"";
            }
            if ("apos".equals(string)) {
                return "'";
            }
            if (string.length() < 2 || string.charAt(0) != '#') {
                throw new XPathException("invalid character reference &" + string + ';', "XPST0003");
            }
            return this.b(string);
        }

        private String b(String string) {
            int n2 = 0;
            if (string.charAt(1) == 'x') {
                if (string.length() < 3) {
                    throw new XPathException("No hex digits in hexadecimal character reference", "XPST0003");
                }
                string = string.toLowerCase();
                for (int i2 = 2; i2 < string.length(); ++i2) {
                    int n3 = "0123456789abcdef".indexOf(string.charAt(i2));
                    if (n3 < 0) {
                        throw new XPathException("Invalid hex digit '" + string.charAt(i2) + "' in character reference", "XPST0003");
                    }
                    if ((n2 = (n2 << 4) + n3) <= 0x10FFFF) continue;
                    throw new XPathException("Character reference exceeds Unicode codepoint limit", "XQST0090");
                }
            } else {
                for (int i3 = 1; i3 < string.length(); ++i3) {
                    int n4 = "0123456789".indexOf(string.charAt(i3));
                    if (n4 < 0) {
                        throw new XPathException("Invalid digit '" + string.charAt(i3) + "' in decimal character reference", "XPST0003");
                    }
                    if ((n2 = n2 * 10 + n4) <= 0x10FFFF) continue;
                    throw new XPathException("Character reference exceeds Unicode codepoint limit", "XQST0090");
                }
            }
            if (!this.a.test(n2)) {
                throw new XPathException("Invalid XML character reference x" + Integer.toHexString(n2), "XQST0090");
            }
            if (n2 <= 65535) {
                return "" + (char)n2;
            }
            assert (n2 <= 0x10FFFF);
            return "" + (char)(0xD800 | (n2 -= 65536) >> 10) + (char)(0xDC00 | n2 & 0x3FF);
        }
    }

    private static final class c {
        public Expression a;
        public boolean b;
        public boolean c;
        public String d;

        private c() {
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }
}

