/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.JRegexIterator;
import net.sf.saxon.regex.JTokenIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.StringValue;

public class JavaRegularExpression
implements RegularExpression {
    private Pattern a;
    private String b;
    private int c;

    public JavaRegularExpression(CharSequence charSequence, String string) {
        this.c = JavaRegularExpression.setFlags(string);
        this.b = charSequence.toString();
        try {
            this.a = Pattern.compile(this.b, this.c & 0xFFFFFFFB);
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new XPathException("Incorrect syntax for Java regular expression", patternSyntaxException);
        }
    }

    public String getJavaRegularExpression() {
        return this.b;
    }

    public int getFlagBits() {
        return this.c;
    }

    @Override
    public RegexIterator analyze(CharSequence charSequence) {
        return new JRegexIterator(charSequence.toString(), this.a);
    }

    @Override
    public boolean containsMatch(CharSequence charSequence) {
        return this.a.matcher(charSequence).find();
    }

    @Override
    public boolean matches(CharSequence charSequence) {
        return this.a.matcher(charSequence).matches();
    }

    @Override
    public CharSequence replace(CharSequence object, CharSequence charSequence) {
        object = this.a.matcher((CharSequence)object);
        try {
            return ((Matcher)object).replaceAll(charSequence.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new XPathException(indexOutOfBoundsException.getMessage(), "FORX0004");
        }
    }

    @Override
    public SequenceIterator<StringValue> tokenize(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return EmptyIterator.getInstance();
        }
        return new JTokenIterator(charSequence, this.a);
    }

    public static int setFlags(CharSequence object) {
        int n2 = 1;
        block10: for (int i2 = 0; i2 < object.length(); ++i2) {
            char c2 = object.charAt(i2);
            switch (c2) {
                case 'd': {
                    n2 |= 1;
                    continue block10;
                }
                case 'm': {
                    n2 |= 8;
                    continue block10;
                }
                case 'i': {
                    n2 |= 2;
                    continue block10;
                }
                case 's': {
                    n2 |= 0x20;
                    continue block10;
                }
                case 'x': {
                    n2 |= 4;
                    continue block10;
                }
                case 'u': {
                    n2 |= 0x40;
                    continue block10;
                }
                case 'q': {
                    n2 |= 0x10;
                    continue block10;
                }
                case 'c': {
                    n2 |= 0x80;
                    continue block10;
                }
                default: {
                    object = new XPathException("Invalid character '" + c2 + "' in regular expression flags");
                    ((XPathException)object).setErrorCode("FORX0001");
                    throw object;
                }
            }
        }
        return n2;
    }

    @Override
    public String getFlags() {
        String string = "";
        if ((this.c & 1) != 0) {
            string = string + 'd';
        }
        if ((this.c & 8) != 0) {
            string = string + 'm';
        }
        if ((this.c & 2) != 0) {
            string = string + 'i';
        }
        if ((this.c & 0x20) != 0) {
            string = string + 's';
        }
        if ((this.c & 4) != 0) {
            string = string + 'x';
        }
        if ((this.c & 0x40) != 0) {
            string = string + 'u';
        }
        if ((this.c & 0x10) != 0) {
            string = string + 'q';
        }
        if ((this.c & 0x80) != 0) {
            string = string + 'c';
        }
        return string;
    }
}

