/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.IntPredicate;
import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.EmptyCharacterClass;
import net.sf.saxon.regex.charclass.IntSetCharacterClass;
import net.sf.saxon.regex.charclass.SingletonCharacterClass;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntSingletonIterator;
import net.sf.saxon.z.IntSingletonSet;
import net.sf.saxon.z.IntStepIterator;

public abstract class Operation {
    public static final int MATCHES_ZLS_AT_START = 1;
    public static final int MATCHES_ZLS_AT_END = 2;
    public static final int MATCHES_ZLS_ANYWHERE = 7;
    public static final int MATCHES_ZLS_NEVER = 1024;

    public abstract IntIterator iterateMatches(REMatcher var1, int var2);

    public int getMatchLength() {
        return -1;
    }

    public int getMinimumMatchLength() {
        int n2 = this.getMatchLength();
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public abstract int matchesEmptyString();

    public boolean containsCapturingExpressions() {
        return false;
    }

    public CharacterClass getInitialCharacterClass(boolean bl2) {
        return EmptyCharacterClass.getComplement();
    }

    public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
        return this;
    }

    public abstract String display();

    private static final class a
    implements IntIterator {
        private IntIterator a;
        private int b = 0;
        private int c = -1;

        public a(IntIterator intIterator) {
            this.a = intIterator;
        }

        @Override
        public final boolean hasNext() {
            return this.b <= 3 && this.a.hasNext();
        }

        @Override
        public final int next() {
            int n2 = this.a.next();
            if (n2 == this.c) {
                ++this.b;
            } else {
                this.b = 0;
                this.c = n2;
            }
            return n2;
        }
    }

    public static class OpTrace
    extends Operation {
        private Operation a;
        private static int b = 0;

        public OpTrace(Operation operation) {
            this.a = operation;
        }

        @Override
        public IntIterator iterateMatches(REMatcher object, int n2) {
            object = this.a.iterateMatches((REMatcher)object, n2);
            int n3 = b++;
            String string = object.getClass().getName();
            int n4 = string.lastIndexOf(".");
            string = string.substring(n4 + 1);
            System.err.println("Iterating over " + this.a.getClass().getSimpleName() + " " + this.a.display() + " at position " + n2 + " returning " + string + " " + n3);
            return new IntIterator(this, (IntIterator)object, n3){
                private /* synthetic */ IntIterator a;
                private /* synthetic */ int b;
                private /* synthetic */ OpTrace c;
                {
                    this.c = opTrace;
                    this.a = intIterator;
                    this.b = n2;
                }

                @Override
                public final boolean hasNext() {
                    boolean bl2 = this.a.hasNext();
                    System.err.println("IntIterator " + this.b + " hasNext() = " + bl2);
                    return bl2;
                }

                @Override
                public final int next() {
                    int n2 = this.a.next();
                    System.err.println("IntIterator " + this.b + " next() = " + n2);
                    return n2;
                }
            };
        }

        @Override
        public int getMatchLength() {
            return this.a.getMatchLength();
        }

        @Override
        public int matchesEmptyString() {
            return this.a.matchesEmptyString();
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            this.a = this.a.optimize(rEProgram, rEFlags);
            return this;
        }

        @Override
        public String display() {
            return this.a.display();
        }
    }

    public static class OpNothing
    extends Operation {
        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            return new IntSingletonIterator(n2);
        }

        @Override
        public int matchesEmptyString() {
            return 7;
        }

        @Override
        public int getMatchLength() {
            return 0;
        }

        @Override
        public String display() {
            return "()";
        }
    }

    public static class OpBackReference
    extends Operation {
        public int groupNr;

        public OpBackReference(int n2) {
            this.groupNr = n2;
        }

        @Override
        public int matchesEmptyString() {
            return 0;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            int n3 = rEMatcher.e[this.groupNr];
            int n4 = rEMatcher.f[this.groupNr];
            if (n3 == -1 || n4 == -1) {
                return EmptyIntIterator.getInstance();
            }
            if (n3 == n4) {
                return new IntSingletonIterator(n2);
            }
            UnicodeString unicodeString = rEMatcher.b;
            if (unicodeString.isEnd(n2 + (n4 -= n3) - 1)) {
                return EmptyIntIterator.getInstance();
            }
            if (rEMatcher.a.b.isCaseIndependent()) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (REMatcher.a(unicodeString.uCharAt(n2 + i2), unicodeString.uCharAt(n3 + i2))) continue;
                    return EmptyIntIterator.getInstance();
                }
            } else {
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (unicodeString.uCharAt(n2 + i3) == unicodeString.uCharAt(n3 + i3)) continue;
                    return EmptyIntIterator.getInstance();
                }
            }
            return new IntSingletonIterator(n2 + n4);
        }

        @Override
        public String display() {
            return "\\" + this.groupNr;
        }
    }

    public static class OpCapture
    extends Operation {
        public int groupNr;
        public Operation childOp;

        public OpCapture(Operation operation, int n2) {
            this.childOp = operation;
            this.groupNr = n2;
        }

        @Override
        public int getMatchLength() {
            return this.childOp.getMatchLength();
        }

        @Override
        public int getMinimumMatchLength() {
            return this.childOp.getMinimumMatchLength();
        }

        @Override
        public int matchesEmptyString() {
            return this.childOp.matchesEmptyString();
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            this.childOp = this.childOp.optimize(rEProgram, rEFlags);
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            if ((rEMatcher.a.g & 1) != 0) {
                rEMatcher.e[this.groupNr] = n2;
            }
            IntIterator intIterator = this.childOp.iterateMatches(rEMatcher, n2);
            return new IntIterator(this, intIterator, rEMatcher, n2){
                private /* synthetic */ IntIterator a;
                private /* synthetic */ REMatcher b;
                private /* synthetic */ int c;
                private /* synthetic */ OpCapture d;
                {
                    this.d = opCapture;
                    this.a = intIterator;
                    this.b = rEMatcher;
                    this.c = n2;
                }

                @Override
                public final boolean hasNext() {
                    return this.a.hasNext();
                }

                @Override
                public final int next() {
                    int n2 = this.a.next();
                    if (this.d.groupNr >= this.b.d.a) {
                        this.b.d.a = this.d.groupNr + 1;
                    }
                    this.b.setParenStart(this.d.groupNr, this.c);
                    this.b.setParenEnd(this.d.groupNr, n2);
                    if ((this.b.a.g & 1) != 0) {
                        this.b.e[this.d.groupNr] = this.c;
                        this.b.f[this.d.groupNr] = n2;
                    }
                    return n2;
                }
            };
        }

        @Override
        public String display() {
            return "(" + this.childOp.display() + ")";
        }
    }

    public static class OpEOL
    extends Operation {
        @Override
        public int getMatchLength() {
            return 0;
        }

        @Override
        public int matchesEmptyString() {
            return 2;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            UnicodeString unicodeString = rEMatcher.b;
            if (rEMatcher.a.b.isMultiLine()) {
                if (unicodeString.isEnd(0) || unicodeString.isEnd(n2) || rEMatcher.a(n2)) {
                    return new IntSingletonIterator(n2);
                }
                return EmptyIntIterator.getInstance();
            }
            if (unicodeString.isEnd(0) || unicodeString.isEnd(n2)) {
                return new IntSingletonIterator(n2);
            }
            return EmptyIntIterator.getInstance();
        }

        @Override
        public String display() {
            return "$";
        }
    }

    public static class OpBOL
    extends Operation {
        @Override
        public int getMatchLength() {
            return 0;
        }

        @Override
        public int matchesEmptyString() {
            return 1;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            if (n2 != 0) {
                if (rEMatcher.a.b.isMultiLine() && rEMatcher.a(n2 - 1) && !rEMatcher.b.isEnd(n2)) {
                    return new IntSingletonIterator(n2);
                }
                return EmptyIntIterator.getInstance();
            }
            return new IntSingletonIterator(n2);
        }

        @Override
        public String display() {
            return "^";
        }
    }

    public static class OpEndProgram
    extends Operation {
        @Override
        public int getMatchLength() {
            return 0;
        }

        @Override
        public int matchesEmptyString() {
            return 7;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            if (rEMatcher.h) {
                if (rEMatcher.b.isEnd(n2)) {
                    return new IntSingletonIterator(n2);
                }
                return EmptyIntIterator.getInstance();
            }
            rEMatcher.setParenEnd(0, n2);
            return new IntSingletonIterator(n2);
        }

        @Override
        public String display() {
            return "\\Z";
        }
    }

    public static class OpReluctantFixed
    extends OpRepeat {
        private int a;

        public OpReluctantFixed(Operation operation, int n2, int n3, int n4) {
            super(operation, n2, n3, false);
            this.a = n4;
        }

        @Override
        public int getMatchLength() {
            if (this.min == this.max) {
                return this.min * this.a;
            }
            return -1;
        }

        @Override
        public int matchesEmptyString() {
            if (this.min == 0) {
                return 7;
            }
            return this.op.matchesEmptyString();
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            this.op = this.op.optimize(rEProgram, rEFlags);
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            return new IntIterator(this, n2, rEMatcher){
                private int a;
                private int b;
                private boolean c;
                private /* synthetic */ int d;
                private /* synthetic */ REMatcher e;
                private /* synthetic */ OpReluctantFixed f;
                {
                    this.f = opReluctantFixed;
                    this.d = n2;
                    this.e = rEMatcher;
                    this.a = this.d;
                    this.b = 0;
                    this.c = false;
                }

                @Override
                public final boolean hasNext() {
                    if (!this.c) {
                        this.c = true;
                        while (this.b < this.f.min) {
                            IntIterator intIterator = this.f.op.iterateMatches(this.e, this.a);
                            if (intIterator.hasNext()) {
                                this.a = intIterator.next();
                                ++this.b;
                                continue;
                            }
                            return false;
                        }
                        return true;
                    }
                    if (this.b < this.f.max) {
                        this.e.clearCapturedGroupsBeyond(this.a);
                        IntIterator intIterator = this.f.op.iterateMatches(this.e, this.a);
                        if (intIterator.hasNext()) {
                            this.a = intIterator.next();
                            ++this.b;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public final int next() {
                    return this.a;
                }
            };
        }
    }

    public static class OpRepeat
    extends Operation {
        protected Operation op;
        protected int min;
        protected int max;
        protected boolean greedy;

        public OpRepeat(Operation operation, int n2, int n3, boolean bl2) {
            this.op = operation;
            this.min = n2;
            this.max = n3;
            this.greedy = bl2;
        }

        public Operation getRepeatedOperation() {
            return this.op;
        }

        @Override
        public int matchesEmptyString() {
            if (this.min == 0) {
                return 7;
            }
            return this.op.matchesEmptyString();
        }

        @Override
        public boolean containsCapturingExpressions() {
            return this.op instanceof OpCapture || this.op.containsCapturingExpressions();
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean bl2) {
            return this.op.getInitialCharacterClass(bl2);
        }

        @Override
        public int getMatchLength() {
            if (this.min == this.max && this.op.getMatchLength() >= 0) {
                return this.min * this.op.getMatchLength();
            }
            return -1;
        }

        @Override
        public int getMinimumMatchLength() {
            return this.min * this.op.getMinimumMatchLength();
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            this.op = this.op.optimize(rEProgram, rEFlags);
            if (this.min == 0 && this.op.matchesEmptyString() == 7) {
                this.min = 1;
            }
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            Stack<IntIterator> stack = new Stack<IntIterator>();
            Stack<Integer> stack2 = new Stack<Integer>();
            int n3 = Math.min(this.max, rEMatcher.b.uLength() - n2 + 1);
            int n4 = n2;
            if (this.greedy) {
                if (this.min == 0 && !rEMatcher.c.isDuplicateZeroLengthMatch(this, n2)) {
                    stack.push(new IntSingletonIterator(n2));
                    stack2.push(n2);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    IntIterator intIterator = this.op.iterateMatches(rEMatcher, n4);
                    if (!intIterator.hasNext()) {
                        if (!stack.isEmpty()) break;
                        return EmptyIntIterator.getInstance();
                    }
                    n4 = intIterator.next();
                    stack.push(intIterator);
                    stack2.push(n4);
                }
                IntIterator intIterator = new IntIterator(this, stack, stack2, n3, rEMatcher){
                    private boolean a = true;
                    private /* synthetic */ Stack b;
                    private /* synthetic */ Stack c;
                    private /* synthetic */ int d;
                    private /* synthetic */ REMatcher e;
                    private /* synthetic */ OpRepeat f;
                    {
                        this.f = opRepeat;
                        this.b = stack;
                        this.c = stack2;
                        this.d = n2;
                        this.e = rEMatcher;
                    }

                    @Override
                    public final boolean hasNext() {
                        if (this.a && this.b.size() >= this.f.min) {
                            return !this.b.isEmpty();
                        }
                        if (this.b.isEmpty()) {
                            return false;
                        }
                        do {
                            1 var1_1 = this;
                            IntIterator intIterator = (IntIterator)var1_1.b.peek();
                            if (intIterator.hasNext()) {
                                IntIterator intIterator2;
                                int n2 = intIterator.next();
                                var1_1.c.pop();
                                var1_1.c.push(n2);
                                while (var1_1.b.size() < var1_1.d && (intIterator2 = var1_1.f.op.iterateMatches(var1_1.e, n2)).hasNext()) {
                                    n2 = intIterator2.next();
                                    var1_1.b.push(intIterator2);
                                    var1_1.c.push(n2);
                                }
                            } else {
                                var1_1.b.pop();
                                var1_1.c.pop();
                            }
                        } while (this.b.size() < this.f.min && !this.b.isEmpty());
                        return !this.b.isEmpty();
                    }

                    @Override
                    public final int next() {
                        this.a = false;
                        return (Integer)this.c.peek();
                    }
                };
                return new a(intIterator);
            }
            IntIterator intIterator = new IntIterator(this, n2, rEMatcher){
                private int a;
                private int b;
                private /* synthetic */ int c;
                private /* synthetic */ REMatcher d;
                private /* synthetic */ OpRepeat e;
                {
                    this.e = opRepeat;
                    this.c = n2;
                    this.d = rEMatcher;
                    this.a = this.c;
                    this.b = 0;
                }

                @Override
                public final boolean hasNext() {
                    do {
                        2 var1_1 = this;
                        IntIterator intIterator = var1_1.e.op.iterateMatches(var1_1.d, var1_1.a);
                        if (intIterator.hasNext()) {
                            var1_1.a = intIterator.next();
                            if (++var1_1.b <= var1_1.e.max) continue;
                        } else if (var1_1.e.min == 0 && var1_1.b == 0) {
                            ++var1_1.b;
                            continue;
                        }
                        var1_1.a = -1;
                    } while (this.b < this.e.min && this.a >= 0);
                    return this.a >= 0;
                }

                @Override
                public final int next() {
                    return this.a;
                }
            };
            return new a(intIterator);
        }

        @Override
        public String display() {
            String string = this.min == 0 && this.max == Integer.MAX_VALUE ? "*" : (this.min == 1 && this.max == Integer.MAX_VALUE ? "+" : (this.min == 0 && this.max == 1 ? "?" : "{" + this.min + "," + this.max + "}"));
            if (!this.greedy) {
                string = string + "?";
            }
            return this.op.display() + string;
        }
    }

    public static class OpUnambiguousRepeat
    extends OpRepeat {
        public OpUnambiguousRepeat(Operation operation, int n2, int n3) {
            super(operation, n2, n3, true);
        }

        @Override
        public int matchesEmptyString() {
            if (this.min == 0) {
                return 7;
            }
            return this.op.matchesEmptyString();
        }

        @Override
        public int getMatchLength() {
            if (this.op.getMatchLength() != -1 && this.min == this.max) {
                return this.op.getMatchLength() * this.min;
            }
            return -1;
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            this.op = this.op.optimize(rEProgram, rEFlags);
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            IntIterator intIterator;
            int n3;
            int n4 = rEMatcher.b.uLength();
            for (n3 = 0; n3 < this.max && n2 <= n4 && (intIterator = this.op.iterateMatches(rEMatcher, n2)).hasNext(); ++n3) {
                n2 = intIterator.next();
            }
            if (n3 < this.min) {
                return EmptyIntIterator.getInstance();
            }
            return new IntSingletonIterator(n2);
        }
    }

    public static class OpGreedyFixed
    extends OpRepeat {
        private int a;

        public OpGreedyFixed(Operation operation, int n2, int n3, int n4) {
            super(operation, n2, n3, true);
            this.a = n4;
        }

        @Override
        public int getMatchLength() {
            if (this.min == this.max) {
                return this.min * this.a;
            }
            return -1;
        }

        @Override
        public int matchesEmptyString() {
            if (this.min == 0) {
                return 7;
            }
            return this.op.matchesEmptyString();
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            if (this.max == 0) {
                return new OpNothing();
            }
            if (this.op.getMatchLength() == 0) {
                return this.op;
            }
            this.op = this.op.optimize(rEProgram, rEFlags);
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            int n3;
            int n4 = rEMatcher.b.uLength();
            if (this.max < Integer.MAX_VALUE) {
                n4 = Math.min(n4, n2 + this.a * this.max);
            }
            if (n2 >= n4 && this.min > 0) {
                return EmptyIntIterator.getInstance();
            }
            int n5 = 0;
            for (n3 = n2; n3 <= n4; n3 += this.a) {
                IntIterator intIterator = this.op.iterateMatches(rEMatcher, n3);
                boolean bl2 = false;
                if (intIterator.hasNext()) {
                    bl2 = true;
                    intIterator.next();
                }
                if (!bl2) break;
                if (++n5 != this.max) continue;
            }
            if (n5 < this.min) {
                return EmptyIntIterator.getInstance();
            }
            return new IntStepIterator(n3, -this.a, n2 + this.a * this.min);
        }
    }

    public static class OpAtom
    extends Operation {
        private UnicodeString a;
        private int b;

        public OpAtom(UnicodeString unicodeString) {
            this.a = unicodeString;
            this.b = unicodeString.uLength();
        }

        public UnicodeString getAtom() {
            return this.a;
        }

        @Override
        public int getMatchLength() {
            return this.b;
        }

        @Override
        public int matchesEmptyString() {
            if (this.b == 0) {
                return 7;
            }
            return 1024;
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean bl2) {
            int n2;
            int[] nArray;
            if (this.b == 0) {
                return EmptyCharacterClass.getInstance();
            }
            if (bl2 && (nArray = CaseVariants.getCaseVariants(n2 = this.a.uCharAt(0))).length > 0) {
                IntHashSet intHashSet = new IntHashSet(nArray.length);
                intHashSet.add(n2);
                int[] nArray2 = nArray;
                int n3 = nArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = nArray2[i2];
                    intHashSet.add(n4);
                }
                return new IntSetCharacterClass(intHashSet);
            }
            return new SingletonCharacterClass(this.a.uCharAt(0));
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            UnicodeString unicodeString = rEMatcher.b;
            if (n2 + this.b > unicodeString.uLength()) {
                return EmptyIntIterator.getInstance();
            }
            if (rEMatcher.a.b.isCaseIndependent()) {
                for (int i2 = 0; i2 < this.b; ++i2) {
                    if (REMatcher.a(unicodeString.uCharAt(n2 + i2), this.a.uCharAt(i2))) continue;
                    return EmptyIntIterator.getInstance();
                }
            } else {
                for (int i3 = 0; i3 < this.b; ++i3) {
                    if (unicodeString.uCharAt(n2 + i3) == this.a.uCharAt(i3)) continue;
                    return EmptyIntIterator.getInstance();
                }
            }
            return new IntSingletonIterator(n2 + this.b);
        }

        @Override
        public String display() {
            return this.a.toString();
        }
    }

    public static class OpCharClass
    extends Operation {
        private IntPredicate a;

        public OpCharClass(IntPredicate intPredicate) {
            this.a = intPredicate;
        }

        public IntPredicate getPredicate() {
            return this.a;
        }

        @Override
        public int getMatchLength() {
            return 1;
        }

        @Override
        public int matchesEmptyString() {
            return 1024;
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean bl2) {
            if (this.a instanceof CharacterClass) {
                return (CharacterClass)this.a;
            }
            return super.getInitialCharacterClass(bl2);
        }

        @Override
        public IntIterator iterateMatches(REMatcher object, int n2) {
            object = ((REMatcher)object).b;
            if (n2 < ((UnicodeString)object).uLength() && this.a.test(((UnicodeString)object).uCharAt(n2))) {
                return new IntSingletonIterator(n2 + 1);
            }
            return EmptyIntIterator.getInstance();
        }

        @Override
        public String display() {
            if (this.a instanceof IntSetPredicate) {
                IntSet intSet = ((IntSetPredicate)this.a).getIntSet();
                if (intSet instanceof IntSingletonSet) {
                    return "" + (char)((IntSingletonSet)intSet).getMember();
                }
                if (intSet instanceof IntRangeSet) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
                    intSet = (IntRangeSet)intSet;
                    fastStringBuffer.append("[");
                    for (int i2 = 0; i2 < ((IntRangeSet)intSet).getNumberOfRanges(); ++i2) {
                        fastStringBuffer.append((char)((IntRangeSet)intSet).getStartPoints()[1]);
                        fastStringBuffer.append("-");
                        fastStringBuffer.append((char)((IntRangeSet)intSet).getEndPoints()[1]);
                    }
                    fastStringBuffer.append("[");
                    return fastStringBuffer.toString();
                }
                return "[....]";
            }
            return "[....]";
        }
    }

    public static class OpSequence
    extends Operation {
        private List<Operation> a;

        public OpSequence(List<Operation> list) {
            this.a = list;
        }

        public List<Operation> getOperations() {
            return this.a;
        }

        @Override
        public int getMatchLength() {
            int n2 = 0;
            for (Operation operation : this.a) {
                int n3 = operation.getMatchLength();
                if (n3 == -1) {
                    return -1;
                }
                n2 += n3;
            }
            return n2;
        }

        @Override
        public int getMinimumMatchLength() {
            int n2 = 0;
            for (Operation operation : this.a) {
                n2 += operation.getMinimumMatchLength();
            }
            return n2;
        }

        @Override
        public int matchesEmptyString() {
            boolean bl2;
            boolean bl22 = true;
            for (Operation object : this.a) {
                int n2 = object.matchesEmptyString();
                if (n2 == 1024) {
                    return 1024;
                }
                if (n2 == 7) continue;
                bl22 = false;
                break;
            }
            if (bl22) {
                return 7;
            }
            boolean bl3 = true;
            for (Operation operation : this.a) {
                if ((operation.matchesEmptyString() & 1) != 0) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                return 1;
            }
            boolean bl4 = true;
            for (Operation operation : this.a) {
                if ((operation.matchesEmptyString() & 2) != 0) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                return 2;
            }
            return 0;
        }

        @Override
        public boolean containsCapturingExpressions() {
            for (Operation operation : this.a) {
                if (!(operation instanceof OpCapture) && !operation.containsCapturingExpressions()) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean bl2) {
            CharacterClass characterClass = EmptyCharacterClass.getInstance();
            for (Operation operation : this.a) {
                characterClass = RECompiler.makeUnion(characterClass, operation.getInitialCharacterClass(bl2));
                if (operation.matchesEmptyString() != 1024) continue;
                return characterClass;
            }
            return characterClass;
        }

        @Override
        public String display() {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            for (Operation operation : this.a) {
                fastStringBuffer.append(operation.display());
            }
            return fastStringBuffer.toString();
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            if (this.a.size() == 0) {
                return new OpNothing();
            }
            if (this.a.size() == 1) {
                return this.a.get(0);
            }
            for (int i2 = 0; i2 < this.a.size() - 1; ++i2) {
                Operation operation;
                Operation operation2 = this.a.get(i2);
                if (operation2 != (operation = operation2.optimize(rEProgram, rEFlags))) {
                    this.a.set(i2, operation);
                }
                if (!(operation instanceof OpRepeat) || !((operation = ((OpRepeat)operation2).getRepeatedOperation()) instanceof OpAtom) && !(operation instanceof OpCharClass)) continue;
                Operation operation3 = this.a.get(i2 + 1);
                if (((OpRepeat)operation2).min != ((OpRepeat)operation2).max && !RECompiler.a(operation, operation3, rEFlags.isCaseIndependent(), !((OpRepeat)operation2).greedy)) continue;
                this.a.set(i2, new OpUnambiguousRepeat(operation, ((OpRepeat)operation2).min, ((OpRepeat)operation2).max));
            }
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            Stack stack = new Stack();
            REMatcher.State state = ((Operation)this).containsCapturingExpressions() ? rEMatcher.captureState() : null;
            int n3 = rEMatcher.getProgram().getBacktrackingLimit();
            return new IntIterator(this, stack, rEMatcher, n3, state, n2){
                private boolean a = false;
                private int b;
                private /* synthetic */ Stack c;
                private /* synthetic */ REMatcher d;
                private /* synthetic */ int e;
                private /* synthetic */ REMatcher.State f;
                private /* synthetic */ int g;
                private /* synthetic */ OpSequence h;
                {
                    this.h = opSequence;
                    this.c = stack;
                    this.d = rEMatcher;
                    this.e = n2;
                    this.f = state;
                    this.g = n3;
                }

                @Override
                public final boolean hasNext() {
                    block5: {
                        int n2;
                        if (!this.a) {
                            this.c.push(((Operation)this.h.a.get(0)).iterateMatches(this.d, this.g));
                            this.a = true;
                        }
                        1 var1_1 = this;
                        int n3 = 0;
                        while (!var1_1.c.isEmpty()) {
                            IntIterator intIterator = (IntIterator)var1_1.c.peek();
                            while (intIterator.hasNext()) {
                                int n4 = intIterator.next();
                                var1_1.d.clearCapturedGroupsBeyond(n4);
                                int n5 = var1_1.c.size();
                                if (n5 >= var1_1.h.a.size()) {
                                    n2 = n4;
                                    break block5;
                                }
                                intIterator = ((Operation)var1_1.h.a.get(n5)).iterateMatches(var1_1.d, n4);
                                var1_1.c.push(intIterator);
                            }
                            var1_1.c.pop();
                            if (var1_1.e < 0 || n3++ <= var1_1.e) continue;
                            throw new UncheckedXPathException(new XPathException("Regex backtracking limit exceeded processing " + var1_1.d.g.display() + ". Simplify the regular expression, or set Feature.REGEX_BACKTRACKING_LIMIT to -1 to remove this limit."));
                        }
                        if (var1_1.f != null) {
                            var1_1.d.resetState(var1_1.f);
                        }
                        n2 = this.b = -1;
                    }
                    return this.b >= 0;
                }

                @Override
                public final int next() {
                    return this.b;
                }
            };
        }
    }

    public static class OpChoice
    extends Operation {
        List<Operation> a;

        public OpChoice(List<Operation> list) {
            this.a = list;
        }

        @Override
        public int getMatchLength() {
            int n2 = this.a.get(0).getMatchLength();
            for (int i2 = 1; i2 < this.a.size(); ++i2) {
                if (this.a.get(i2).getMatchLength() == n2) continue;
                return -1;
            }
            return n2;
        }

        @Override
        public int getMinimumMatchLength() {
            int n2 = this.a.get(0).getMinimumMatchLength();
            for (int i2 = 1; i2 < this.a.size(); ++i2) {
                int n3 = this.a.get(i2).getMinimumMatchLength();
                if (n3 >= n2) continue;
                n2 = n3;
            }
            return n2;
        }

        @Override
        public int matchesEmptyString() {
            int n2 = 0;
            for (Operation operation : this.a) {
                int n3 = operation.matchesEmptyString();
                if (n3 == 1024) continue;
                n2 |= n3;
            }
            return n2;
        }

        @Override
        public boolean containsCapturingExpressions() {
            for (Operation operation : this.a) {
                if (!(operation instanceof OpCapture) && !operation.containsCapturingExpressions()) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean bl2) {
            CharacterClass characterClass = EmptyCharacterClass.getInstance();
            for (Operation operation : this.a) {
                characterClass = RECompiler.makeUnion(characterClass, operation.getInitialCharacterClass(bl2));
            }
            return characterClass;
        }

        @Override
        public Operation optimize(REProgram rEProgram, REFlags rEFlags) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Operation operation;
                Operation operation2 = this.a.get(i2);
                if (operation2 == (operation = operation2.optimize(rEProgram, rEFlags))) continue;
                this.a.set(i2, operation);
            }
            return this;
        }

        @Override
        public IntIterator iterateMatches(REMatcher rEMatcher, int n2) {
            return new IntIterator(this, rEMatcher, n2){
                private Iterator<Operation> a;
                private IntIterator b;
                private Operation c;
                private /* synthetic */ REMatcher d;
                private /* synthetic */ int e;
                private /* synthetic */ OpChoice f;
                {
                    this.f = opChoice;
                    this.d = rEMatcher;
                    this.e = n2;
                    this.a = this.f.a.iterator();
                    this.b = null;
                    this.c = null;
                }

                @Override
                public final boolean hasNext() {
                    while (true) {
                        if (this.b == null) {
                            if (this.a.hasNext()) {
                                this.d.clearCapturedGroupsBeyond(this.e);
                                this.c = this.a.next();
                                this.b = this.c.iterateMatches(this.d, this.e);
                            } else {
                                return false;
                            }
                        }
                        if (this.b.hasNext()) {
                            return true;
                        }
                        this.b = null;
                    }
                }

                @Override
                public final int next() {
                    return this.b.next();
                }
            };
        }

        @Override
        public String display() {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            fastStringBuffer.append("(?:");
            boolean bl2 = true;
            for (Operation operation : this.a) {
                if (bl2) {
                    bl2 = false;
                } else {
                    fastStringBuffer.append('|');
                }
                fastStringBuffer.append(operation.display());
            }
            fastStringBuffer.append(")");
            return fastStringBuffer.toString();
        }
    }
}

