/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.History;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.RegexPrecondition;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntIterator;

public class REMatcher {
    REProgram a;
    UnicodeString b;
    History c = new History();
    private int i = 16;
    State d = new State();
    int[] e;
    int[] f;
    Operation g;
    boolean h;

    public REMatcher(REProgram rEProgram) {
        this.setProgram(rEProgram);
    }

    public void setProgram(REProgram rEProgram) {
        this.a = rEProgram;
        if (rEProgram != null && rEProgram.h != -1) {
            this.g = rEProgram.a;
            this.i = rEProgram.h;
            return;
        }
        this.i = 16;
    }

    public REProgram getProgram() {
        return this.a;
    }

    public int getParenCount() {
        return this.d.a;
    }

    public UnicodeString getParen(int n2) {
        int n3;
        if (n2 < this.d.a && (n3 = this.getParenStart(n2)) >= 0) {
            return this.b.uSubstring(n3, this.getParenEnd(n2));
        }
        return null;
    }

    public final int getParenStart(int n2) {
        if (n2 < this.d.b.length) {
            return this.d.b[n2];
        }
        return -1;
    }

    public final int getParenEnd(int n2) {
        if (n2 < this.d.c.length) {
            return this.d.c[n2];
        }
        return -1;
    }

    protected final void setParenStart(int n2, int n3) {
        while (n2 > this.d.b.length - 1) {
            int[] nArray = new int[this.d.b.length << 1];
            System.arraycopy(this.d.b, 0, nArray, 0, this.d.b.length);
            Arrays.fill(nArray, this.d.b.length, nArray.length, -1);
            this.d.b = nArray;
        }
        this.d.b[n2] = n3;
    }

    protected final void setParenEnd(int n2, int n3) {
        while (n2 > this.d.c.length - 1) {
            int[] nArray = new int[this.d.c.length << 1];
            System.arraycopy(this.d.c, 0, nArray, 0, this.d.c.length);
            Arrays.fill(nArray, this.d.c.length, nArray.length, -1);
            this.d.c = nArray;
        }
        this.d.c[n2] = n3;
    }

    protected void clearCapturedGroupsBeyond(int n2) {
        int n3;
        for (n3 = 0; n3 < this.d.b.length; ++n3) {
            if (this.d.b[n3] < n2) continue;
            this.d.c[n3] = this.d.b[n3];
        }
        if (this.e != null) {
            for (n3 = 0; n3 < this.e.length; ++n3) {
                if (this.e[n3] < n2) continue;
                this.f[n3] = this.e[n3];
            }
        }
    }

    protected boolean matchAt(int n2, boolean bl2) {
        IntIterator intIterator;
        this.d.a = 1;
        this.h = bl2;
        this.setParenStart(0, n2);
        if ((this.a.g & 1) != 0) {
            this.e = new int[this.i];
            this.f = new int[this.i];
        }
        if ((intIterator = this.g.iterateMatches(this, n2)).hasNext()) {
            int n3 = intIterator.next();
            this.setParenEnd(0, n3);
            return true;
        }
        this.d.a = 0;
        return false;
    }

    public boolean anchoredMatch(UnicodeString unicodeString) {
        this.b = unicodeString;
        return this.matchAt(0, true);
    }

    public boolean match(UnicodeString unicodeString, int n2) {
        this.b = unicodeString;
        this.d = new State();
        if ((this.a.g & 2) == 2) {
            if (!this.a.b.isMultiLine()) {
                return n2 == 0 && this.b(n2) && this.matchAt(n2, false);
            }
            int n3 = n2;
            if (this.matchAt(n2, false)) {
                return true;
            }
            do {
                if ((n3 = unicodeString.uIndexOf(10, n3) + 1) < unicodeString.uLength() && n3 > 0) continue;
                return false;
            } while (!this.matchAt(n3, false));
            return true;
        }
        int n4 = unicodeString.uLength() - n2;
        if (n4 < this.a.f) {
            return false;
        }
        if (this.a.c == null) {
            if (this.a.d != null) {
                IntPredicate intPredicate = this.a.d;
                while (!unicodeString.isEnd(n2)) {
                    if (intPredicate.test(unicodeString.uCharAt(n2)) && this.matchAt(n2, false)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (!this.b(n2)) {
                return false;
            }
            while (!unicodeString.isEnd(n2 - 1)) {
                if (this.matchAt(n2, false)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        UnicodeString unicodeString2 = this.a.c;
        int n5 = unicodeString2.uLength();
        boolean bl2 = this.a.b.isCaseIndependent();
        while (!unicodeString.isEnd(n2 + n5 - 1)) {
            int n6;
            int n7;
            boolean bl3 = true;
            if (bl2) {
                n7 = n2;
                for (n6 = 0; n6 < n5; ++n6) {
                    if (!REMatcher.a(unicodeString.uCharAt(n7), unicodeString2.uCharAt(n6))) {
                        bl3 = false;
                        break;
                    }
                    ++n7;
                }
            } else {
                n7 = n2;
                for (n6 = 0; n6 < n5; ++n6) {
                    if (unicodeString.uCharAt(n7) != unicodeString2.uCharAt(n6)) {
                        bl3 = false;
                        break;
                    }
                    ++n7;
                }
            }
            if (bl3 && this.matchAt(n2, false)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean b(int n2) {
        for (RegexPrecondition regexPrecondition : this.a.e) {
            int n3;
            if (regexPrecondition.fixedPosition != -1) {
                boolean bl2 = regexPrecondition.operation.iterateMatches(this, regexPrecondition.fixedPosition).hasNext();
                n3 = bl2 ? 1 : 0;
                if (bl2) continue;
                return false;
            }
            n3 = n2;
            if (n3 < regexPrecondition.minPosition) {
                n3 = regexPrecondition.minPosition;
            }
            boolean bl3 = false;
            while (!this.b.isEnd(n3)) {
                if ((regexPrecondition.fixedPosition == -1 || regexPrecondition.fixedPosition == n3) && regexPrecondition.operation.iterateMatches(this, n3).hasNext()) {
                    bl3 = true;
                    break;
                }
                ++n3;
            }
            if (bl3) continue;
            return false;
        }
        return true;
    }

    public boolean match(String charSequence) {
        charSequence = UnicodeString.makeUnicodeString(charSequence);
        return this.match((UnicodeString)charSequence, 0);
    }

    public List<UnicodeString> split(UnicodeString unicodeString) {
        ArrayList<UnicodeString> arrayList = new ArrayList<UnicodeString>();
        int n2 = 0;
        int n3 = unicodeString.uLength();
        while (n2 < n3 && this.match(unicodeString, n2)) {
            int n4 = this.getParenStart(0);
            int n5 = this.getParenEnd(0);
            if (n5 == n2) {
                arrayList.add(unicodeString.uSubstring(n2, n4 + 1));
            } else {
                arrayList.add(unicodeString.uSubstring(n2, n4));
            }
            n2 = ++n5;
        }
        UnicodeString unicodeString2 = unicodeString.uSubstring(n2, n3);
        arrayList.add(unicodeString2);
        return arrayList;
    }

    public CharSequence replace(UnicodeString unicodeString, UnicodeString unicodeString2) {
        int n2;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(unicodeString.uLength() << 1);
        int n3 = 0;
        int n4 = unicodeString.uLength();
        while (n3 < n4 && this.match(unicodeString, n3)) {
            for (n2 = n3; n2 < this.getParenStart(0); ++n2) {
                fastStringBuffer.appendWideChar(unicodeString.uCharAt(n2));
            }
            if (!this.a.b.isLiteral()) {
                n2 = this.a.h - 1;
                for (int i2 = 0; i2 < unicodeString2.uLength(); ++i2) {
                    int n5 = unicodeString2.uCharAt(i2);
                    if (n5 == 92) {
                        if ((n5 = unicodeString2.uCharAt(++i2)) == 92 || n5 == 36) {
                            fastStringBuffer.append((char)n5);
                            continue;
                        }
                        throw new RESyntaxException("Invalid escape '" + n5 + "' in replacement string");
                    }
                    if (n5 == 36) {
                        UnicodeString unicodeString3;
                        if ((n5 = unicodeString2.uCharAt(++i2)) < 48 || n5 > 57) {
                            throw new RESyntaxException("$ in replacement string must be followed by a digit");
                        }
                        int n6 = n5 - 48;
                        if (n2 <= 9) {
                            UnicodeString unicodeString4;
                            if (n2 < n6 || (unicodeString4 = this.getParen(n6)) == null) continue;
                            for (n6 = 0; n6 < unicodeString4.uLength(); ++n6) {
                                fastStringBuffer.appendWideChar(unicodeString4.uCharAt(n6));
                            }
                            continue;
                        }
                        while (++i2 < unicodeString2.uLength()) {
                            n5 = unicodeString2.uCharAt(i2);
                            if (n5 >= 48 && n5 <= 57 && (n5 = n6 * 10 + (n5 - 48)) <= n2) {
                                n6 = n5;
                                continue;
                            }
                            --i2;
                            break;
                        }
                        if ((unicodeString3 = this.getParen(n6)) == null) continue;
                        for (n6 = 0; n6 < unicodeString3.uLength(); ++n6) {
                            fastStringBuffer.appendWideChar(unicodeString3.uCharAt(n6));
                        }
                        continue;
                    }
                    fastStringBuffer.appendWideChar(n5);
                }
            } else {
                for (n2 = 0; n2 < unicodeString2.uLength(); ++n2) {
                    fastStringBuffer.appendWideChar(unicodeString2.uCharAt(n2));
                }
            }
            if ((n2 = this.getParenEnd(0)) == n3) {
                // empty if block
            }
            n3 = ++n2;
        }
        for (n2 = n3; n2 < n4; ++n2) {
            fastStringBuffer.appendWideChar(unicodeString.uCharAt(n2));
        }
        return fastStringBuffer.condense();
    }

    final boolean a(int n2) {
        return this.b.uCharAt(n2) == 10;
    }

    static boolean a(int n2, int n3) {
        if (n2 == n3) {
            return true;
        }
        for (int n4 : CaseVariants.getCaseVariants(n3)) {
            if (n2 != n4) continue;
            return true;
        }
        return false;
    }

    public State captureState() {
        return new State(this.d);
    }

    public void resetState(State state) {
        this.d = new State(state);
    }

    public static class State {
        int a;
        int[] b;
        int[] c;

        public State() {
            this.a = 0;
            this.b = new int[3];
            this.b[2] = -1;
            this.b[1] = -1;
            this.b[0] = -1;
            this.c = new int[3];
            this.c[2] = -1;
            this.c[1] = -1;
            this.c[0] = -1;
        }

        public State(State state) {
            this.a = state.a;
            this.b = Arrays.copyOf(state.b, state.b.length);
            this.c = Arrays.copyOf(state.c, state.c.length);
        }
    }
}

