/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.EmptyString;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class UnicodeString
implements CharSequence,
Comparable<UnicodeString> {
    private int a = -1;

    public static UnicodeString makeUnicodeString(CharSequence charSequence) {
        if (charSequence instanceof UnicodeString) {
            return (UnicodeString)charSequence;
        }
        if (charSequence.length() == 0) {
            return EmptyString.THE_INSTANCE;
        }
        int n2 = UnicodeString.getMaxWidth(charSequence);
        if (n2 == 1) {
            return new LatinString(charSequence);
        }
        if (n2 == 2) {
            return new BMPString(charSequence);
        }
        return new GeneralUnicodeString(charSequence);
    }

    public static UnicodeString makeUnicodeString(int[] nArray) {
        int n2;
        int n3;
        Object object = nArray;
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = object[n3];
            if (n2 <= 65535) continue;
            return new GeneralUnicodeString(nArray, 0, nArray.length);
        }
        object = new FastStringBuffer(nArray.length);
        int[] nArray2 = nArray;
        n3 = nArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = nArray2[n2];
            ((FastStringBuffer)object).append((char)n5);
        }
        return new BMPString((CharSequence)object);
    }

    public static boolean containsSurrogatePairs(CharSequence charSequence) {
        if (charSequence instanceof BMPString || charSequence instanceof LatinString || charSequence instanceof EmptyString) {
            return false;
        }
        if (charSequence instanceof GeneralUnicodeString) {
            GeneralUnicodeString generalUnicodeString = (GeneralUnicodeString)charSequence;
            for (int i2 = 0; i2 < ((UnicodeString)generalUnicodeString).uLength(); ++i2) {
                if (((UnicodeString)generalUnicodeString).uCharAt(i2) < 65535) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            char c2 = charSequence.charAt(i3);
            if (c2 < '\ud800' || c2 > '\udbff') continue;
            return true;
        }
        return false;
    }

    public static int getMaxWidth(CharSequence charSequence) {
        if (charSequence instanceof LatinString || charSequence instanceof EmptyString) {
            return 1;
        }
        if (charSequence instanceof BMPString) {
            return 2;
        }
        if (charSequence instanceof GeneralUnicodeString) {
            return 4;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 > '\u00ff') {
                bl2 = true;
            }
            if (c2 < '\ud800' || c2 > '\udbff') continue;
            return 4;
        }
        if (bl2) {
            return 2;
        }
        return 1;
    }

    public abstract UnicodeString uSubstring(int var1, int var2);

    public abstract int uIndexOf(int var1, int var2);

    public abstract int uCharAt(int var1);

    public abstract int uLength();

    public abstract boolean isEnd(int var1);

    public int hashCode() {
        if (this.a == -1) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.uLength(); ++i2) {
                n2 = n2 * 31 + this.uCharAt(i2);
            }
            this.a = n2;
        }
        return this.a;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnicodeString)) {
            return false;
        }
        if (this.uLength() != ((UnicodeString)object).uLength()) {
            return false;
        }
        for (int i2 = 0; i2 < this.uLength(); ++i2) {
            if (this.uCharAt(i2) == ((UnicodeString)object).uCharAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(UnicodeString unicodeString) {
        int n2;
        int n3;
        int n4 = this.uLength();
        int n5 = unicodeString.uLength();
        int n6 = 0;
        int n7 = 0;
        do {
            if (n6 == n4) {
                if (n7 == n5) {
                    return 0;
                }
                return -1;
            }
            if (n7 == n5) {
                return 1;
            }
            n2 = this.uCharAt(n6++);
        } while ((n2 -= (n3 = unicodeString.uCharAt(n7++))) == 0);
        return n2;
    }

    public final byte[] getCodepointCollationKey() {
        int n2 = this.uLength();
        byte[] byArray = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.uCharAt(i2);
            byArray[n3++] = (byte)(n4 >> 16);
            byArray[n3++] = (byte)(n4 >> 8);
            byArray[n3++] = (byte)n4;
        }
        return byArray;
    }
}

