/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex.charclass;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntPredicate;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.IntSetCharacterClass;
import net.sf.saxon.regex.charclass.InverseCharacterClass;
import net.sf.saxon.regex.charclass.PredicateCharacterClass;
import net.sf.saxon.regex.charclass.SingletonCharacterClass;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;

public class Categories {
    private static HashMap<String, Category> a = null;
    public static final CharacterClass ESCAPE_s = new IntSetCharacterClass(IntArraySet.make(new int[]{9, 10, 13, 32}, 4));
    public static final CharacterClass ESCAPE_S = new InverseCharacterClass(ESCAPE_s);
    public static final PredicateCharacterClass ESCAPE_i = new PredicateCharacterClass(n2 -> XMLCharacterData.isNCNameStart11(n2) || n2 == 58);
    public static final CharacterClass ESCAPE_I = new InverseCharacterClass(ESCAPE_i);
    public static final PredicateCharacterClass ESCAPE_c = new PredicateCharacterClass(n2 -> XMLCharacterData.isNCName11(n2) || n2 == 58);
    public static final CharacterClass ESCAPE_C = new InverseCharacterClass(ESCAPE_c);
    public static final Category ESCAPE_d = Categories.getCategory("Nd");
    public static final CharacterClass ESCAPE_D = new InverseCharacterClass(ESCAPE_d);
    private static Category b = Categories.getCategory("P");
    private static Category c = Categories.getCategory("Z");
    private static Category d = Categories.getCategory("C");
    public static final PredicateCharacterClass ESCAPE_w = new PredicateCharacterClass(n2 -> !b.test(n2) && !c.test(n2) && !d.test(n2));
    public static final CharacterClass ESCAPE_W = new InverseCharacterClass(ESCAPE_w);

    public static synchronized Category getCategory(String string) {
        if (a == null) {
            a = new HashMap(30);
            Object object2 = Configuration.locateResource("categories.xml", new ArrayList<String>(), new ArrayList<ClassLoader>());
            if (object2 == null) {
                throw new RuntimeException("Unable to read categories.xml file");
            }
            Configuration configuration = new Configuration();
            ParseOptions parseOptions = new ParseOptions();
            parseOptions.setSchemaValidationMode(4);
            parseOptions.setDTDValidationMode(4);
            parseOptions.setTreeModel(1);
            try {
                object2 = configuration.buildDocumentTree(new StreamSource((InputStream)object2, "categories.xml"), parseOptions).getRootNode();
            }
            catch (XPathException xPathException) {
                throw new RuntimeException("Failed to build categories.xml", xPathException);
            }
            int c2 = configuration.getNamePool().allocateFingerprint("", "name");
            int intPredicate = configuration.getNamePool().allocateFingerprint("", "f");
            int string2 = configuration.getNamePool().allocateFingerprint("", "t");
            object2 = object2.iterateAxis((byte)4, new NameTest(1, "", "cat", configuration.getNamePool()));
            object2.forEach(object -> {
                String string = ((TinyElementImpl)object).getAttributeValue(c2);
                IntRangeSet intRangeSet = new IntRangeSet();
                object = object.iterateAxis((byte)3, NodeKindTest.ELEMENT);
                object.forEach(nodeInfo -> {
                    String string = ((TinyElementImpl)nodeInfo).getAttributeValue(n2);
                    String string2 = ((TinyElementImpl)nodeInfo).getAttributeValue(n3);
                    intRangeSet.addRange(Integer.parseInt(string, 16), Integer.parseInt(string2, 16));
                });
                a.put(string, new Category(string, new IntSetPredicate(intRangeSet)));
            });
            object2 = "CLMNPSZ";
            for (int i2 = 0; i2 < ((String)object2).length(); ++i2) {
                char c3 = ((String)object2).charAt(i2);
                IntPredicate intPredicate2 = null;
                for (Map.Entry<String, Category> entry : a.entrySet()) {
                    if (entry.getKey().charAt(0) != c3) continue;
                    intPredicate2 = intPredicate2 == null ? (IntPredicate)entry.getValue() : intPredicate2.or(entry.getValue());
                }
                String string3 = "" + c3;
                a.put(string3, new Category(string3, intPredicate2));
            }
        }
        return a.get(string);
    }

    public static class Category
    implements CharacterClass {
        private String a;
        private IntPredicate b;

        public Category(String string, IntPredicate intPredicate) {
            this.a = string;
            this.b = intPredicate;
        }

        @Override
        public boolean test(int n2) {
            return this.b.test(n2);
        }

        @Override
        public boolean isDisjoint(CharacterClass object) {
            if (object instanceof Category) {
                char c2;
                char c3 = this.a.charAt(0);
                return c3 != (c2 = ((String)(object = ((Category)object).a)).charAt(0)) || this.a.length() > 1 && ((String)object).length() > 1 && !this.a.equals(object);
            }
            if (object instanceof InverseCharacterClass) {
                return object.isDisjoint(this);
            }
            if (object instanceof SingletonCharacterClass) {
                return !this.test(((SingletonCharacterClass)object).getCodepoint());
            }
            if (object instanceof IntSetCharacterClass) {
                IntSet intSet = object.getIntSet();
                if (intSet.size() > 100) {
                    return false;
                }
                object = intSet.iterator();
                while (object.hasNext()) {
                    if (!this.test(object.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public IntSet getIntSet() {
            IntPredicate intPredicate = this.b;
            if (intPredicate instanceof IntSetPredicate) {
                return ((IntSetPredicate)intPredicate).getIntSet();
            }
            return null;
        }
    }
}

