/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLReader;

public abstract class AbstractResourceCollection
implements ResourceCollection {
    protected Configuration config;
    protected String collectionURI;
    protected URIQueryParameters params = null;

    public AbstractResourceCollection(Configuration configuration) {
        this.config = configuration;
    }

    @Override
    public String getCollectionURI() {
        return this.collectionURI;
    }

    @Override
    public boolean isStable(XPathContext xPathContext) {
        if (this.params == null) {
            return false;
        }
        Boolean bl2 = this.params.getStable();
        if (bl2 == null) {
            return xPathContext.getConfiguration().getBooleanProperty(Feature.STABLE_COLLECTION_URI);
        }
        return bl2;
    }

    public void registerContentType(String string, ResourceFactory resourceFactory) {
        this.config.registerMediaType(string, resourceFactory);
    }

    protected ParseOptions optionsFromQueryParameters(URIQueryParameters object, XPathContext xPathContext) {
        ParseOptions parseOptions = new ParseOptions(xPathContext.getConfiguration().getParseOptions());
        if (object != null) {
            Object object2 = ((URIQueryParameters)object).getValidationMode();
            if (object2 != null) {
                parseOptions.setSchemaValidationMode((Integer)object2);
            }
            if ((object2 = ((URIQueryParameters)object).getXInclude()) != null) {
                parseOptions.setXIncludeAware((Boolean)object2);
            }
            if ((object2 = ((URIQueryParameters)object).getSpaceStrippingRule()) != null) {
                parseOptions.setSpaceStrippingRule((SpaceStrippingRule)object2);
            }
            if ((object2 = ((URIQueryParameters)object).getXMLReaderMaker()) != null) {
                parseOptions.setXMLReaderMaker((Maker<XMLReader>)object2);
            }
            int n2 = 1;
            if (((URIQueryParameters)object).getOnError() != null) {
                n2 = ((URIQueryParameters)object).getOnError();
            }
            object = (object = xPathContext.getController()) == null ? new StandardErrorListener() : ((Controller)object).getErrorListener();
            AbstractResourceCollection.setupErrorHandlingForCollection(parseOptions, n2, (UnfailingErrorListener)object);
        }
        return parseOptions;
    }

    public static void setupErrorHandlingForCollection(ParseOptions parseOptions, int n2, UnfailingErrorListener unfailingErrorListener) {
        if (n2 == 3) {
            parseOptions.setErrorListener(new UnfailingErrorListener(){

                @Override
                public final void warning(TransformerException transformerException) {
                }

                @Override
                public final void error(TransformerException transformerException) {
                }

                @Override
                public final void fatalError(TransformerException transformerException) {
                }
            });
            return;
        }
        if (n2 == 2) {
            parseOptions.setErrorListener(new UnfailingErrorListener(unfailingErrorListener){
                private /* synthetic */ UnfailingErrorListener a;
                {
                    this.a = unfailingErrorListener;
                }

                @Override
                public final void warning(TransformerException transformerException) {
                    this.a.warning(transformerException);
                }

                @Override
                public final void error(TransformerException transformerException) {
                    this.a.warning(transformerException);
                    XPathException xPathException = new XPathException("The document will be excluded from the collection");
                    xPathException.setLocator(transformerException.getLocator());
                    this.a.warning(xPathException);
                }

                @Override
                public final void fatalError(TransformerException transformerException) {
                    this.error(transformerException);
                }
            });
        }
    }

    protected InputDetails getInputDetails(String string) {
        InputDetails inputDetails = new InputDetails();
        try {
            Object object;
            inputDetails.resourceUri = string;
            URI uRI = new URI(string);
            if ("file".equals(uRI.getScheme())) {
                inputDetails.contentType = this.guessContentTypeFromName(string);
            } else {
                object = uRI.toURL();
                URLConnection uRLConnection = ((URL)object).openConnection();
                inputDetails.contentType = uRLConnection.getContentType();
                inputDetails.encoding = uRLConnection.getContentEncoding();
                for (String string2 : inputDetails.contentType.replace(" ", "").split(";")) {
                    if (string2.startsWith("charset=")) {
                        inputDetails.encoding = string2.split("=", 2)[1];
                        continue;
                    }
                    inputDetails.contentType = string2;
                }
            }
            if (inputDetails.contentType == null || this.config.getResourceFactoryForMediaType(inputDetails.contentType) == null) {
                if ("file".equals(uRI.getScheme())) {
                    File file = new File(uRI);
                    object = new BufferedInputStream(new FileInputStream(file));
                    if (file.length() <= 1024L) {
                        inputDetails.binaryContent = BinaryResource.readBinaryFromStream((InputStream)object, string);
                        ((InputStream)object).close();
                        object = new ByteArrayInputStream(inputDetails.binaryContent);
                    }
                } else {
                    URL uRL = uRI.toURL();
                    object = uRL.openConnection();
                    object = ((URLConnection)object).getInputStream();
                }
                inputDetails.contentType = this.guessContentTypeFromContent((InputStream)object);
                ((InputStream)object).close();
            }
            if (this.params != null && this.params.getOnError() != null) {
                inputDetails.onError = this.params.getOnError();
            }
            return inputDetails;
        }
        catch (IOException | URISyntaxException exception) {
            throw new XPathException(exception);
        }
    }

    protected String guessContentTypeFromName(String string) {
        int n2;
        int n3;
        String string2 = URLConnection.guessContentTypeFromName(string);
        if (string2 == null && (string = (n3 = string.lastIndexOf(46)) > (n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(92))) && n3 + 1 < string.length() ? string.substring(n3 + 1) : null) != null) {
            string2 = this.config.getMediaTypeForFileExtension(string);
        }
        return string2;
    }

    protected String guessContentTypeFromContent(InputStream inputStream) {
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            return URLConnection.guessContentTypeFromStream(inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Resource makeResource(Configuration configuration, InputDetails inputDetails) {
        ResourceFactory resourceFactory = null;
        String string = inputDetails.contentType;
        if (string != null) {
            resourceFactory = configuration.getResourceFactoryForMediaType(string);
        }
        if (resourceFactory == null) {
            resourceFactory = BinaryResource.FACTORY;
        }
        return resourceFactory.makeResource(configuration, inputDetails);
    }

    public Resource makeTypedResource(Configuration configuration, Resource resource) {
        String string = resource.getContentType();
        ResourceFactory resourceFactory = configuration.getResourceFactoryForMediaType(string);
        if (resourceFactory == null) {
            return resource;
        }
        if (resource instanceof BinaryResource) {
            InputDetails inputDetails = new InputDetails();
            new InputDetails().binaryContent = ((BinaryResource)resource).getData();
            inputDetails.contentType = string;
            inputDetails.resourceUri = resource.getResourceURI();
            return resourceFactory.makeResource(configuration, inputDetails);
        }
        if (resource instanceof UnparsedTextResource) {
            InputDetails inputDetails = new InputDetails();
            new InputDetails().characterContent = ((UnparsedTextResource)resource).getContent();
            inputDetails.contentType = string;
            inputDetails.resourceUri = resource.getResourceURI();
            return resourceFactory.makeResource(configuration, inputDetails);
        }
        return resource;
    }

    public Resource makeResource(Configuration configuration, String object) {
        object = this.getInputDetails((String)object);
        return this.makeResource(configuration, (InputDetails)object);
    }

    @Override
    public boolean stripWhitespace(SpaceStrippingRule spaceStrippingRule) {
        return false;
    }

    public static class InputDetails {
        public String resourceUri;
        public byte[] binaryContent;
        public String characterContent;
        public String contentType;
        public String encoding;
        public ParseOptions parseOptions;
        public int onError = 1;

        public InputStream getInputStream() {
            Object object = new URL(this.resourceUri);
            object = ((URL)object).openConnection();
            return ((URLConnection)object).getInputStream();
        }

        public byte[] obtainBinaryContent() {
            byte[] byArray;
            block16: {
                if (this.binaryContent != null) {
                    return this.binaryContent;
                }
                if (this.characterContent != null) {
                    String string = this.encoding != null ? this.encoding : "UTF-8";
                    try {
                        return this.characterContent.getBytes(string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new XPathException(string);
                    }
                }
                InputStream inputStream = this.getInputStream();
                Throwable throwable = null;
                try {
                    byArray = BinaryResource.readBinaryFromStream(inputStream, this.resourceUri);
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException iOException) {
                        throw new XPathException(iOException);
                    }
                }
                inputStream.close();
            }
            return byArray;
        }

        public String obtainCharacterContent() {
            CharSequence charSequence;
            block17: {
                if (this.characterContent != null) {
                    return this.characterContent;
                }
                if (this.binaryContent != null && this.encoding != null) {
                    try {
                        return new String(this.binaryContent, this.encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new XPathException(unsupportedEncodingException);
                    }
                }
                InputStream inputStream = this.getInputStream();
                Throwable throwable = null;
                try {
                    charSequence = this.encoding;
                    if (charSequence == null) {
                        charSequence = StandardUnparsedTextResolver.inferStreamEncoding(inputStream, null);
                    }
                    charSequence = CatalogCollection.makeStringBuilderFromStream(inputStream, (String)charSequence);
                    this.characterContent = ((StringBuilder)charSequence).toString();
                    charSequence = this.characterContent;
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException iOException) {
                        throw new XPathException(iOException);
                    }
                }
                inputStream.close();
            }
            return charSequence;
        }
    }
}

